/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.client.animation.impl.FastSwimAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.info.ActionInfo;
import com.alrex.parcool.config.ParCoolConfig;
import java.nio.ByteBuffer;
import java.util.UUID;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeMod;

public class FastSwim
extends Action {
    private static final String FAST_SWIM_MODIFIER_NAME = "parcool.modifier.fastswimming";
    private static final UUID FAST_SWIM_MODIFIER_UUID = UUID.randomUUID();
    private double speedModifier = 0.0;
    private boolean toggleStatus;

    public double getSpeedModifier(ActionInfo info) {
        return Math.min(info.getClientSetting().get(ParCoolConfig.Client.Doubles.FastSwimSpeedModifier), info.getServerLimitation().get(ParCoolConfig.Server.Doubles.MaxFastSwimSpeedModifier));
    }

    @Override
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        return this.canContinue(player, parkourability, stamina);
    }

    @Override
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        return !stamina.isExhausted() && player.m_20072_() && player.m_20202_() == null && !player.m_21255_() && player.m_20142_() && player.m_6069_() && !parkourability.get(FastRun.class).isDoing() && (ParCoolConfig.Client.FastRunControl.get() == FastRun.ControlType.PressKey && KeyBindings.getKeyFastRunning().m_90857_() || ParCoolConfig.Client.FastRunControl.get() == FastRun.ControlType.Toggle && this.toggleStatus || ParCoolConfig.Client.FastRunControl.get() == FastRun.ControlType.Auto);
    }

    @Override
    public void onClientTick(Player player, Parkourability parkourability, IStamina stamina) {
        if (player.m_7578_()) {
            if (ParCoolConfig.Client.FastRunControl.get() == FastRun.ControlType.Toggle && parkourability.getAdditionalProperties().getSprintingTick() > 3 && player.m_20072_() && player.m_6069_()) {
                if (KeyRecorder.keyFastRunning.isPressed()) {
                    this.toggleStatus = !this.toggleStatus;
                }
            } else {
                this.toggleStatus = false;
            }
        }
    }

    @Override
    public void onWorkingTickInClient(Player player, Parkourability parkourability, IStamina stamina) {
        Animation animation = Animation.get(player);
        if (animation != null && !animation.hasAnimator()) {
            animation.setAnimator(new FastSwimAnimator());
        }
    }

    @Override
    public void onStartInServer(Player player, Parkourability parkourability, ByteBuffer startData) {
        this.speedModifier = parkourability.get(FastSwim.class).getSpeedModifier(parkourability.getActionInfo());
    }

    @Override
    public void onServerTick(Player player, Parkourability parkourability, IStamina stamina) {
        AttributeInstance attr = player.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get());
        if (attr == null) {
            return;
        }
        if (attr.m_22111_(FAST_SWIM_MODIFIER_UUID) != null) {
            attr.m_22120_(FAST_SWIM_MODIFIER_UUID);
        }
        if (this.isDoing()) {
            player.m_6858_(true);
            attr.m_22118_(new AttributeModifier(FAST_SWIM_MODIFIER_UUID, FAST_SWIM_MODIFIER_NAME, this.speedModifier / 8.0, AttributeModifier.Operation.ADDITION));
        }
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnWorking;
    }
}

