/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.init.gen.data;

import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.wanmine.wab.WanAncientBeasts;
import net.wanmine.wab.init.data.WabTags;
import net.wanmine.wab.init.world.WabBlocks;
import net.wanmine.wab.init.world.WabItems;
import net.wanmine.wab.item.HangGlider;

public class WabRecipeGenerator
extends RecipeProvider
implements IConditionBuilder {
    public WabRecipeGenerator(PackOutput output) {
        super(output);
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        WabRecipeGenerator.stair(consumer, (ItemLike)WabBlocks.STRAW_STAIRS.get(), (ItemLike)WabBlocks.STRAW_BLOCK.get());
        WabRecipeGenerator.m_246658_(consumer, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)WabBlocks.STRAW_SLAB.get()), (ItemLike)((ItemLike)WabBlocks.STRAW_BLOCK.get()));
        WabRecipeGenerator.foodCampfire(consumer, (ItemLike)WabItems.FROZEN_ANCIENT_MEAT.get(), (ItemLike)WabItems.RAW_ANCIENT_MEAT.get());
        WabRecipeGenerator.foodCooking(consumer, (ItemLike)WabItems.RAW_ANCIENT_MEAT.get(), (ItemLike)WabItems.COOKED_ANCIENT_MEAT.get());
        WabRecipeGenerator.foodCooking(consumer, (ItemLike)WabItems.TOXLACANTH.get(), (ItemLike)WabItems.COOKED_TOXLACANTH.get());
        WabRecipeGenerator.trimSmithing(consumer, (Item)WabItems.SNIFF_ARMOR_TRIM_SMITHING_TEMPLATE.get());
        WabRecipeGenerator.trimSmithing(consumer, (Item)WabItems.SPIKE_ARMOR_TRIM_SMITHING_TEMPLATE.get());
        WabRecipeGenerator.ancientSmithing(consumer, RecipeCategory.COMBAT, (ItemLike)Items.f_42740_, (ItemLike)WabBlocks.CRUSHER_SPIKE.get(), (Item)WabItems.REINFORCED_SHIELD.get());
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)WabItems.ANCIENT_CLUB.get())).m_126130_("###").m_126130_("#P#").m_126130_(" S ").m_126127_(Character.valueOf('#'), (ItemLike)WabItems.EATER_TOOTH.get()).m_206416_(Character.valueOf('P'), ItemTags.f_13168_).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_).m_126132_(WabRecipeGenerator.m_176602_((ItemLike)((ItemLike)WabItems.EATER_TOOTH.get())), (CriterionTriggerInstance)WabRecipeGenerator.m_125977_((ItemLike)((ItemLike)WabItems.EATER_TOOTH.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)Items.f_42412_, (int)4).m_126130_("X").m_126130_("#").m_126130_("Y").m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42484_).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42398_).m_126127_(Character.valueOf('Y'), (ItemLike)WabItems.GLIDER_FEATHER.get()).m_126132_(WabRecipeGenerator.m_176602_((ItemLike)((ItemLike)WabItems.GLIDER_FEATHER.get())), (CriterionTriggerInstance)WabRecipeGenerator.m_125977_((ItemLike)((ItemLike)WabItems.GLIDER_FEATHER.get()))).m_126140_(consumer, WabRecipeGenerator.getConversionRecipeName((ItemLike)Items.f_42412_, "glider"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)WabItems.CHISEL.get())).m_126130_("I").m_126130_("C").m_126130_("#").m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42416_).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_151052_).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42398_).m_126132_(WabRecipeGenerator.m_176602_((ItemLike)Items.f_42416_), (CriterionTriggerInstance)WabRecipeGenerator.m_125977_((ItemLike)Items.f_42416_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)WabItems.HANG_GLIDER.get())).m_126130_("FFF").m_126130_("###").m_126130_(" F ").m_126127_(Character.valueOf('F'), (ItemLike)WabItems.GLIDER_FEATHER.get()).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42398_).m_126132_(WabRecipeGenerator.m_176602_((ItemLike)((ItemLike)WabItems.GLIDER_FEATHER.get())), (CriterionTriggerInstance)WabRecipeGenerator.m_125977_((ItemLike)((ItemLike)WabItems.GLIDER_FEATHER.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)WabBlocks.NEST.get())).m_126130_("# #").m_126130_("###").m_126127_(Character.valueOf('#'), (ItemLike)WabBlocks.STRAW_BLOCK.get()).m_126132_(WabRecipeGenerator.m_176602_((ItemLike)((ItemLike)WabBlocks.STRAW_BLOCK.get())), (CriterionTriggerInstance)WabRecipeGenerator.m_125977_((ItemLike)((ItemLike)WabBlocks.STRAW_BLOCK.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)WabBlocks.STRAW_BLOCK.get())).m_126130_("W#W").m_126130_("#W#").m_126130_("W#W").m_126127_(Character.valueOf('W'), (ItemLike)Items.f_42405_).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42398_).m_126132_(WabRecipeGenerator.m_176602_((ItemLike)Items.f_42405_), (CriterionTriggerInstance)WabRecipeGenerator.m_125977_((ItemLike)Items.f_42405_)).m_176498_(consumer);
        WabRecipeGenerator.coloredHangGlider(consumer, (HangGlider)((Object)WabItems.WHITE_HANG_GLIDER.get()), (ItemLike)Items.f_42535_);
        WabRecipeGenerator.coloredHangGlider(consumer, (HangGlider)((Object)WabItems.LIGHT_GRAY_HANG_GLIDER.get()), (ItemLike)Items.f_42491_);
        WabRecipeGenerator.coloredHangGlider(consumer, (HangGlider)((Object)WabItems.GRAY_HANG_GLIDER.get()), (ItemLike)Items.f_42490_);
        WabRecipeGenerator.coloredHangGlider(consumer, (HangGlider)((Object)WabItems.BLACK_HANG_GLIDER.get()), (ItemLike)Items.f_42498_);
        WabRecipeGenerator.coloredHangGlider(consumer, (HangGlider)((Object)WabItems.BROWN_HANG_GLIDER.get()), (ItemLike)Items.f_42495_);
        WabRecipeGenerator.coloredHangGlider(consumer, (HangGlider)((Object)WabItems.RED_HANG_GLIDER.get()), (ItemLike)Items.f_42497_);
        WabRecipeGenerator.coloredHangGlider(consumer, (HangGlider)((Object)WabItems.ORANGE_HANG_GLIDER.get()), (ItemLike)Items.f_42536_);
        WabRecipeGenerator.coloredHangGlider(consumer, (HangGlider)((Object)WabItems.YELLOW_HANG_GLIDER.get()), (ItemLike)Items.f_42539_);
        WabRecipeGenerator.coloredHangGlider(consumer, (HangGlider)((Object)WabItems.LIME_HANG_GLIDER.get()), (ItemLike)Items.f_42540_);
        WabRecipeGenerator.coloredHangGlider(consumer, (HangGlider)((Object)WabItems.GREEN_HANG_GLIDER.get()), (ItemLike)Items.f_42496_);
        WabRecipeGenerator.coloredHangGlider(consumer, (HangGlider)((Object)WabItems.LIGHT_BLUE_HANG_GLIDER.get()), (ItemLike)Items.f_42538_);
        WabRecipeGenerator.coloredHangGlider(consumer, (HangGlider)((Object)WabItems.CYAN_HANG_GLIDER.get()), (ItemLike)Items.f_42492_);
        WabRecipeGenerator.coloredHangGlider(consumer, (HangGlider)((Object)WabItems.BLUE_HANG_GLIDER.get()), (ItemLike)Items.f_42494_);
        WabRecipeGenerator.coloredHangGlider(consumer, (HangGlider)((Object)WabItems.PURPLE_HANG_GLIDER.get()), (ItemLike)Items.f_42493_);
        WabRecipeGenerator.coloredHangGlider(consumer, (HangGlider)((Object)WabItems.MAGENTA_HANG_GLIDER.get()), (ItemLike)Items.f_42537_);
        WabRecipeGenerator.coloredHangGlider(consumer, (HangGlider)((Object)WabItems.PINK_HANG_GLIDER.get()), (ItemLike)Items.f_42489_);
    }

    protected static void stair(Consumer<FinishedRecipe> consumer, ItemLike stair, ItemLike block) {
        WabRecipeGenerator.m_176710_((ItemLike)stair, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{block})).m_126132_(WabRecipeGenerator.m_176602_((ItemLike)block), (CriterionTriggerInstance)WabRecipeGenerator.m_125977_((ItemLike)block)).m_176498_(consumer);
    }

    protected static void foodCooking(Consumer<FinishedRecipe> consumer, ItemLike rawFood, ItemLike cookedFood) {
        WabRecipeGenerator.foodSmelting(consumer, rawFood, cookedFood);
        WabRecipeGenerator.foodSmoking(consumer, rawFood, cookedFood);
        WabRecipeGenerator.foodCampfire(consumer, rawFood, cookedFood);
    }

    protected static void foodSmelting(Consumer<FinishedRecipe> consumer, ItemLike rawFood, ItemLike cookedFood) {
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{rawFood}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)cookedFood, (float)0.35f, (int)200).m_126132_(WabRecipeGenerator.m_176602_((ItemLike)rawFood), (CriterionTriggerInstance)WabRecipeGenerator.m_125977_((ItemLike)rawFood)).m_176498_(consumer);
    }

    protected static void foodSmoking(Consumer<FinishedRecipe> consumer, ItemLike rawFood, ItemLike cookedFood) {
        SimpleCookingRecipeBuilder.m_246159_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{rawFood}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)cookedFood, (float)0.35f, (int)100).m_126132_(WabRecipeGenerator.m_176602_((ItemLike)rawFood), (CriterionTriggerInstance)WabRecipeGenerator.m_125977_((ItemLike)rawFood)).m_126140_(consumer, WabRecipeGenerator.getFromConversionRecipeName(cookedFood, "smoking"));
    }

    protected static void foodCampfire(Consumer<FinishedRecipe> consumer, ItemLike rawFood, ItemLike cookedFood) {
        SimpleCookingRecipeBuilder.m_247020_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{rawFood}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)cookedFood, (float)0.35f, (int)600).m_126132_(WabRecipeGenerator.m_176602_((ItemLike)rawFood), (CriterionTriggerInstance)WabRecipeGenerator.m_125977_((ItemLike)rawFood)).m_126140_(consumer, WabRecipeGenerator.getFromConversionRecipeName(cookedFood, "campfire_cooking"));
    }

    protected static void trimSmithing(Consumer<FinishedRecipe> consumer, Item item) {
        WabRecipeGenerator.m_284421_(consumer, (Item)item, (ResourceLocation)WabRecipeGenerator.getConversionRecipeName((ItemLike)item, "smithing_trim"));
    }

    protected static void ancientSmithing(Consumer<FinishedRecipe> consumer, RecipeCategory category, ItemLike base, ItemLike addition, Item item) {
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)WabItems.ANCIENT_UPGRADE_SMITHING_TEMPLATE.get()}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{base}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{addition}), (RecipeCategory)category, (Item)item).m_266439_("has_netherite_ingot", (CriterionTriggerInstance)WabRecipeGenerator.m_125977_((ItemLike)addition)).m_266371_(consumer, WabRecipeGenerator.getConversionRecipeName((ItemLike)item, "smithing"));
    }

    protected static void coloredHangGlider(Consumer<FinishedRecipe> consumer, HangGlider item, ItemLike dye) {
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)item).m_206419_(WabTags.Items.HANG_GLIDERS).m_126209_(dye).m_126132_("hang_glider", (CriterionTriggerInstance)WabRecipeGenerator.m_206406_(WabTags.Items.HANG_GLIDERS)).m_176498_(consumer);
    }

    protected static ResourceLocation getFromConversionRecipeName(ItemLike item, String method) {
        return WabRecipeGenerator.getConversionRecipeName(item, "from_" + method);
    }

    protected static ResourceLocation getConversionRecipeName(ItemLike item, String method) {
        return WanAncientBeasts.resource(WabRecipeGenerator.m_176632_((ItemLike)item) + "_" + method);
    }
}

