/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.BlockEntityBaseWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.wirelesschargers.ChargerBlockEntity;
import com.supermartijn642.wirelesschargers.screen.EnergyBarWidget;
import com.supermartijn642.wirelesschargers.screen.HighlightAreaButton;
import com.supermartijn642.wirelesschargers.screen.RedstoneModeButton;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;

public class ChargerScreen
extends BlockEntityBaseWidget<ChargerBlockEntity> {
    private final Component title;
    private final BlockPos entityPos;

    public ChargerScreen(Component title, Level entityLevel, BlockPos entityPos) {
        super(0, 0, 66, 72, entityLevel, entityPos);
        this.title = title;
        this.entityPos = entityPos;
    }

    public Component getNarrationMessage(ChargerBlockEntity object) {
        return this.title;
    }

    protected void addWidgets(ChargerBlockEntity entity) {
        this.addWidget((Widget)new EnergyBarWidget(10, 10, 20, 52, this::getEnergy, this::getCapacity));
        this.addWidget((Widget)new HighlightAreaButton(36, 11, this.entityPos, this::isAreaHighlighted));
        this.addWidget((Widget)new RedstoneModeButton(36, 41, this.entityPos, this::getRedstoneMode));
    }

    protected void renderBackground(PoseStack poseStack, int mouseX, int mouseY, ChargerBlockEntity object) {
        ScreenUtils.drawScreenBackground((PoseStack)poseStack, (float)this.x, (float)this.y, (float)this.width, (float)this.height);
        super.renderBackground(poseStack, mouseX, mouseY, (Object)object);
    }

    private int getEnergy() {
        return this.validateObjectOrClose() ? ((ChargerBlockEntity)((Object)this.object)).getEnergyStored() : 0;
    }

    private int getCapacity() {
        return this.validateObjectOrClose() ? ((ChargerBlockEntity)((Object)this.object)).getMaxEnergyStored() : 1;
    }

    private boolean isAreaHighlighted() {
        return this.validateObjectOrClose() && ((ChargerBlockEntity)((Object)this.object)).isAreaHighlighted();
    }

    private ChargerBlockEntity.RedstoneMode getRedstoneMode() {
        return this.validateObjectOrClose() ? ((ChargerBlockEntity)((Object)this.object)).getRedstoneMode() : ChargerBlockEntity.RedstoneMode.DISABLED;
    }
}

