/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers;

import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.network.PacketChannel;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.wirelesschargers.ChargerType;
import com.supermartijn642.wirelesschargers.WirelessChargersClient;
import com.supermartijn642.wirelesschargers.compat.ModCompatibility;
import com.supermartijn642.wirelesschargers.generators.ChargerAdvancementGenerator;
import com.supermartijn642.wirelesschargers.generators.ChargerBlockStateGenerator;
import com.supermartijn642.wirelesschargers.generators.ChargerLanguageGenerator;
import com.supermartijn642.wirelesschargers.generators.ChargerLootTableGenerator;
import com.supermartijn642.wirelesschargers.generators.ChargerModelGenerator;
import com.supermartijn642.wirelesschargers.generators.ChargerRecipeGenerator;
import com.supermartijn642.wirelesschargers.generators.ChargerTagGenerator;
import com.supermartijn642.wirelesschargers.packets.CycleRedstoneModePacket;
import com.supermartijn642.wirelesschargers.packets.ToggleHighlightAreaPacket;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="wirelesschargers")
public class WirelessChargers {
    public static final PacketChannel CHANNEL = PacketChannel.create((String)"wirelesschargers");
    public static final CreativeItemGroup GROUP = CreativeItemGroup.create((String)"wirelesschargers", ChargerType.ADVANCED_WIRELESS_BLOCK_CHARGER::getItem);

    public WirelessChargers() {
        CHANNEL.registerMessage(ToggleHighlightAreaPacket.class, ToggleHighlightAreaPacket::new, true);
        CHANNEL.registerMessage(CycleRedstoneModePacket.class, CycleRedstoneModePacket::new, true);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModCompatibility::init);
        WirelessChargers.register();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> WirelessChargersClient::register);
        WirelessChargers.registerGenerators();
    }

    private static void register() {
        RegistrationHandler handler = RegistrationHandler.get((String)"wirelesschargers");
        for (ChargerType type : ChargerType.values()) {
            handler.registerBlockCallback(type::registerBlock);
            handler.registerBlockEntityTypeCallback(type::registerBlockEntity);
            handler.registerItemCallback(type::registerItem);
        }
    }

    public static void registerGenerators() {
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)"wirelesschargers");
        handler.addGenerator(ChargerModelGenerator::new);
        handler.addGenerator(ChargerBlockStateGenerator::new);
        handler.addGenerator(ChargerLanguageGenerator::new);
        handler.addGenerator(ChargerLootTableGenerator::new);
        handler.addGenerator(ChargerRecipeGenerator::new);
        handler.addGenerator(ChargerTagGenerator::new);
        handler.addGenerator(ChargerAdvancementGenerator::new);
    }
}

