/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.voidtotem;

import com.affehund.voidtotem.ModConstants;
import com.affehund.voidtotem.VoidTotem;
import com.affehund.voidtotem.client.VoidTotemCuriosRenderer;
import com.affehund.voidtotem.core.ModUtils;
import com.affehund.voidtotem.core.VoidTotemConfig;
import com.affehund.voidtotem.core.VoidTotemDataGeneration;
import com.affehund.voidtotem.core.network.PacketHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod(value="voidtotem")
public class VoidTotemForge {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"voidtotem");
    public static final RegistryObject<Item> VOID_TOTEM_ITEM = ITEMS.register("totem_of_void_undying", () -> new Item(new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40757_).m_41497_(Rarity.UNCOMMON)));
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"voidtotem");
    public static final RegistryObject<SimpleParticleType> VOID_TOTEM_PARTICLE = PARTICLE_TYPES.register("void_totem", () -> new SimpleParticleType(true));

    public VoidTotemForge() {
        VoidTotem.init();
        if (ModUtils.isModLoaded("curios")) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.CHARM.getMessageBuilder().build());
            VoidTotem.LOGGER.debug("Enqueued IMC to {}", (Object)"curios");
        }
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addGenericListener(ItemStack.class, this::attachCaps);
        forgeEventBus.addListener(this::itemTooltip);
        forgeEventBus.register((Object)this);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::clientSetup);
        ITEMS.register(modEventBus);
        PARTICLE_TYPES.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)VoidTotemConfig.COMMON_SPEC);
        PacketHandler.registerMessages();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        if (ModUtils.isModLoaded("curios") && ((Boolean)VoidTotemConfig.DISPLAY_TOTEM_ON_CHEST.get()).booleanValue()) {
            CuriosRendererRegistry.register((Item)((Item)VOID_TOTEM_ITEM.get()), VoidTotemCuriosRenderer::new);
        }
    }

    private void attachCaps(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack itemStack;
        Item item;
        if (ModUtils.isModLoaded("curios") && (item = (itemStack = (ItemStack)event.getObject()).m_41720_()).equals(VOID_TOTEM_ITEM.get())) {
            event.addCapability(new ResourceLocation("voidtotem", "curios"), new ICapabilityProvider(){
                final ICurio curio = new ICurio(){

                    public boolean canEquipFromUse(SlotContext slotContext) {
                        return true;
                    }

                    public ItemStack getStack() {
                        return itemStack;
                    }
                };

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, LazyOptional.of(() -> this.curio));
                }
            });
        }
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        boolean isClientProvider = event.includeClient();
        VoidTotemDataGeneration.BlockTagsGen blockTagsProvider = new VoidTotemDataGeneration.BlockTagsGen(generator, "voidtotem", existingFileHelper);
        generator.m_236039_(isClientProvider, (DataProvider)new VoidTotemDataGeneration.ItemTagsGen(generator, blockTagsProvider, "voidtotem", existingFileHelper));
        generator.m_236039_(isClientProvider, (DataProvider)new VoidTotemDataGeneration.AdvancementGen(generator, existingFileHelper));
        generator.m_236039_(isClientProvider, (DataProvider)new VoidTotemDataGeneration.LootTableGen(generator));
        generator.m_236039_(isClientProvider, (DataProvider)new VoidTotemDataGeneration.RecipeGen(generator));
        generator.m_236039_(isClientProvider, (DataProvider)new VoidTotemDataGeneration.LanguageGen(generator, "de_de"));
        generator.m_236039_(isClientProvider, (DataProvider)new VoidTotemDataGeneration.LanguageGen(generator, "en_us"));
        generator.m_236039_(isClientProvider, (DataProvider)new VoidTotemDataGeneration.ItemModelGen(generator, "voidtotem", existingFileHelper));
    }

    @SubscribeEvent
    public void loadLootTables(LootTableLoadEvent event) {
        if (((Boolean)VoidTotemConfig.ADD_END_CITY_TREASURE.get()).booleanValue() && event.getName().equals((Object)BuiltInLootTables.f_78741_)) {
            event.getTable().addPool(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)ModConstants.END_CITY_TREASURE_INJECTION_LOCATION)).name("voidtotem_injection").m_79082_());
        }
    }

    private void itemTooltip(ItemTooltipEvent event) {
        VoidTotem.onItemTooltip(event.getItemStack(), event.getToolTip());
    }
}

