/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.UniversalGrid.item;

import com.YTrollman.UniversalGrid.UniversalGrid;
import com.YTrollman.UniversalGrid.apiiml.network.grid.WirelessUniversalGridRemoveTagMessage;
import com.YTrollman.UniversalGrid.config.UniversalGridConfig;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.api.network.grid.ICraftingGridListener;
import com.refinedmods.refinedstorage.api.network.grid.INetworkAwareGrid;
import com.refinedmods.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.refinedmods.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCache;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCacheListener;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.listener.FluidGridStorageCacheListener;
import com.refinedmods.refinedstorage.blockentity.grid.WirelessGrid;
import com.refinedmods.refinedstorage.inventory.player.PlayerSlot;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.lwjgl.glfw.GLFW;

public class WirelessUniversalGrid
extends WirelessGrid {
    @Nullable
    private final MinecraftServer server;
    private final Level level;
    private Set<ICraftingGridListener> listeners = new HashSet<ICraftingGridListener>();
    private AbstractContainerMenu craftingMenu = new AbstractContainerMenu(null, 0){

        public boolean m_6875_(Player player) {
            return false;
        }

        public ItemStack m_7648_(Player player, int index) {
            return ItemStack.f_41583_;
        }

        public void m_6199_(Container container) {
            if (WirelessUniversalGrid.this.server != null) {
                WirelessUniversalGrid.this.onCraftingMatrixChanged();
            }
        }
    };
    private CraftingRecipe currentRecipe;
    private CraftingContainer matrix = new CraftingContainer(this.craftingMenu, 3, 3);
    private ResultContainer result = new ResultContainer();
    private final int gridType;

    public WirelessUniversalGrid(ItemStack stack, Level level, @Nullable MinecraftServer server, PlayerSlot slot) {
        super(stack, server, slot);
        this.server = server;
        this.level = level;
        this.gridType = stack.m_41783_().m_128451_("gridType");
        if (stack.m_41782_()) {
            StackUtils.readItems((Container)this.matrix, (int)1, (CompoundTag)stack.m_41783_());
        }
    }

    public void setCursorPos(ItemStack stack) {
        if (stack.m_41782_()) {
            if (stack.m_41783_().m_128441_("updateCursor")) {
                if (stack.m_41783_().m_128471_("updateCursor")) {
                    UniversalGrid.NETWORK_HANDLER.sendToServer(new WirelessUniversalGridRemoveTagMessage());
                } else {
                    return;
                }
            }
            if (stack.m_41783_().m_128441_("cursorX") || stack.m_41783_().m_128441_("cursorY")) {
                int cursorX = stack.m_41783_().m_128451_("cursorX");
                int cursorY = stack.m_41783_().m_128451_("cursorY");
                GLFW.glfwSetCursorPos((long)Minecraft.m_91087_().m_91268_().m_85439_(), (double)cursorX, (double)cursorY);
            }
        }
    }

    public Component getTitle() {
        return Component.m_237115_((String)"gui.universalgrid.universal_grid");
    }

    public GridType getGridType() {
        if (this.gridType == 0) {
            return GridType.NORMAL;
        }
        if (this.gridType == 1) {
            return GridType.CRAFTING;
        }
        if (this.gridType == 2) {
            return GridType.FLUID;
        }
        return null;
    }

    public CraftingContainer getCraftingMatrix() {
        return this.matrix;
    }

    public ResultContainer getCraftingResult() {
        return this.result;
    }

    public IStorageCacheListener createListener(ServerPlayer player) {
        if (this.getGridType() != GridType.FLUID) {
            return super.createListener(player);
        }
        return new FluidGridStorageCacheListener(player, this.getNetwork());
    }

    @Nullable
    public IStorageCache getStorageCache() {
        if (this.getGridType() != GridType.FLUID) {
            return super.getStorageCache();
        }
        INetwork network = this.getNetwork();
        return network != null ? network.getFluidStorageCache() : null;
    }

    @Nullable
    public IItemGridHandler getItemHandler() {
        if (this.getGridType() != GridType.FLUID) {
            return super.getItemHandler();
        }
        return null;
    }

    @Nullable
    public IFluidGridHandler getFluidHandler() {
        if (this.getGridType() != GridType.FLUID) {
            return null;
        }
        INetwork network = this.getNetwork();
        return network != null ? network.getFluidGridHandler() : null;
    }

    public void onCraftingMatrixChanged() {
        if (this.currentRecipe == null || !this.currentRecipe.m_5818_((Container)this.matrix, this.level)) {
            this.currentRecipe = this.level.m_7465_().m_44015_(RecipeType.f_44107_, (Container)this.matrix, this.level).orElse(null);
        }
        if (this.currentRecipe == null) {
            this.result.m_6836_(0, ItemStack.f_41583_);
        } else {
            this.result.m_6836_(0, this.currentRecipe.m_5874_((Container)this.matrix));
        }
        this.listeners.forEach(ICraftingGridListener::onCraftingMatrixChanged);
        if (!this.getStack().m_41782_()) {
            this.getStack().m_41751_(new CompoundTag());
        }
        StackUtils.writeItems((Container)this.matrix, (int)1, (CompoundTag)this.getStack().m_41783_());
    }

    public void onCrafted(Player player, @Nullable IStackList<ItemStack> availableItems, @Nullable IStackList<ItemStack> usedItems) {
        UniversalGrid.RSAPI.getCraftingGridBehavior().onCrafted((INetworkAwareGrid)this, this.currentRecipe, player, availableItems, usedItems);
        INetwork network = this.getNetwork();
        if (network != null) {
            network.getNetworkItemManager().drainEnergy(player, ((Integer)UniversalGridConfig.UNIVERSAL_GRID_CRAFT_USAGE.get()).intValue());
        }
    }

    public void onClear(Player player) {
        INetwork network = this.getNetwork();
        if (network != null && network.getSecurityManager().hasPermission(Permission.INSERT, player)) {
            for (int i = 0; i < this.matrix.m_6643_(); ++i) {
                ItemStack slot = this.matrix.m_8020_(i);
                if (slot.m_41619_()) continue;
                this.matrix.m_6836_(i, network.insertItem(slot, slot.m_41613_(), Action.PERFORM));
                network.getItemStorageTracker().changed(player, (Object)slot.m_41777_());
            }
            network.getNetworkItemManager().drainEnergy(player, ((Integer)UniversalGridConfig.UNIVERSAL_GRID_CLEAR_USAGE.get()).intValue());
        }
    }

    public void onCraftedShift(Player player) {
        UniversalGrid.RSAPI.getCraftingGridBehavior().onCraftedShift((INetworkAwareGrid)this, player);
    }

    public void onRecipeTransfer(Player player, ItemStack[][] recipe) {
        UniversalGrid.RSAPI.getCraftingGridBehavior().onRecipeTransfer((INetworkAwareGrid)this, player, recipe);
    }

    public void addCraftingListener(ICraftingGridListener listener) {
        this.listeners.add(listener);
    }

    public void removeCraftingListener(ICraftingGridListener listener) {
        this.listeners.remove(listener);
    }
}

