/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen.addon;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class SlotsScreenAddon<T extends IComponentHarness>
extends BasicScreenAddon {
    private final InventoryComponent<T> handler;

    public SlotsScreenAddon(InventoryComponent<T> handler) {
        super(handler.getXPos(), handler.getYPos());
        this.handler = handler;
    }

    @Override
    public int getXSize() {
        return 0;
    }

    @Override
    public int getYSize() {
        return 0;
    }

    public static void drawAsset(PoseStack stack, Screen screen, IAssetProvider provider, int handlerPosX, int handlerPosY, int guiX, int guiY, int slots, Function<Integer, Pair<Integer, Integer>> positionFunction, Function<Integer, ItemStack> slotToStackRenderMap, boolean drawColor, Function<Integer, Color> slotToColorRenderMap, Predicate<Integer> slotEnabled) {
        Color colored;
        int posY;
        int posX;
        int slotID;
        IAsset slot = IAssetProvider.getAsset(provider, AssetTypes.SLOT);
        Rectangle area = slot.getArea();
        RenderSystem.m_157456_((int)0, (ResourceLocation)slot.getResourceLocation());
        if (drawColor) {
            for (slotID = 0; slotID < slots; ++slotID) {
                if (!slotEnabled.test(slotID)) continue;
                posX = (Integer)positionFunction.apply(slotID).getLeft();
                posY = (Integer)positionFunction.apply(slotID).getRight();
                colored = slotToColorRenderMap.apply(slotID);
                if (colored == null) continue;
                GuiComponent.m_93172_((PoseStack)stack, (int)(guiX + handlerPosX + posX - 2), (int)(guiY + handlerPosY + posY - 2), (int)(guiX + handlerPosX + posX + area.width), (int)(guiY + handlerPosY + posY + area.height), (int)new Color(colored.getRed(), colored.getGreen(), colored.getBlue(), 64).getRGB());
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        for (slotID = 0; slotID < slots; ++slotID) {
            if (!slotEnabled.test(slotID)) continue;
            posX = (Integer)positionFunction.apply(slotID).getLeft();
            posY = (Integer)positionFunction.apply(slotID).getRight();
            AssetUtil.drawAsset(stack, screen, slot, handlerPosX + posX + guiX - 1, handlerPosY + posY + guiY - 1);
            ItemStack stack1 = slotToStackRenderMap.apply(slotID);
            screen.getMinecraft().m_91291_().m_115123_(stack1, handlerPosX + posX + guiX, handlerPosY + posY + guiY);
            RenderSystem.m_69465_();
        }
        if (drawColor) {
            for (slotID = 0; slotID < slots; ++slotID) {
                if (!slotEnabled.test(slotID)) continue;
                posX = (Integer)positionFunction.apply(slotID).getLeft();
                posY = (Integer)positionFunction.apply(slotID).getRight();
                colored = slotToColorRenderMap.apply(slotID);
                if (colored == null) continue;
                GuiComponent.m_93172_((PoseStack)stack, (int)(guiX + handlerPosX + posX), (int)(guiY + handlerPosY + posY), (int)(guiX + handlerPosX + posX + area.width - 2), (int)(guiY + handlerPosY + posY + area.height - 2), (int)new Color(colored.getRed(), colored.getGreen(), colored.getBlue(), 128).getRGB());
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        RenderSystem.m_69482_();
    }

    @Override
    public void drawBackgroundLayer(PoseStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        SlotsScreenAddon.drawAsset(stack, screen, provider, guiX, guiY, this.getPosX(), this.getPosY(), this.handler.getSlots(), this.handler.getSlotPosition(), this.handler::getItemStackForSlotRendering, this.handler.isColorGuiEnabled(), this.handler::getColorForSlotRendering, this.handler.getSlotVisiblePredicate());
    }

    @Override
    public void drawForegroundLayer(PoseStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
    }
}

