/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.foundation.data;

import cofh.lib.util.helpers.DatapackHelper;
import cofh.thermal.lib.FeatureHelper;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.holdersets.AnyHolderSet;

public final class TFndBiomeModifiers {
    public static JsonCodecProvider<BiomeModifier> dataGenBiomeModifiers(DataGenerator gen, ExistingFileHelper exFileHelper, RegistryOps<JsonElement> regOps) {
        return DatapackHelper.datapackProvider((String)"thermal", (DataGenerator)gen, (ExistingFileHelper)exFileHelper, regOps, (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, TFndBiomeModifiers.generateBiomeModifiers(regOps.f_206806_));
    }

    private static Map<ResourceLocation, BiomeModifier> generateBiomeModifiers(RegistryAccess registryAccess) {
        HashMap<ResourceLocation, BiomeModifier> biomeModifierMap = new HashMap<ResourceLocation, BiomeModifier>();
        TFndBiomeModifiers.generateBiomeOres((Registry<Biome>)registryAccess.m_175515_(Registry.f_122885_), (Registry<PlacedFeature>)registryAccess.m_175515_(Registry.f_194567_), biomeModifierMap);
        return biomeModifierMap;
    }

    private static void generateBiomeOres(Registry<Biome> biomeRegistry, Registry<PlacedFeature> placedFeatureRegistry, Map<ResourceLocation, BiomeModifier> map) {
        AnyHolderSet allBiomes = new AnyHolderSet(biomeRegistry);
        HolderSet oilSandsBiomes = DatapackHelper.holderSetIntersection((HolderSet[])new HolderSet[]{biomeRegistry.m_203561_(BiomeTags.f_215817_), DatapackHelper.holderSetUnion((HolderSet[])new HolderSet[]{HolderSet.m_205809_((Holder[])new Holder[]{Holder.Reference.m_205766_(biomeRegistry, (ResourceKey)Biomes.f_48203_)}), DatapackHelper.tagsOr(biomeRegistry, (TagKey[])new TagKey[]{BiomeTags.f_207607_})})});
        HolderSet rubberwoodTreeBiomes = DatapackHelper.holderSetUnion((HolderSet[])new HolderSet[]{HolderSet.m_205809_((Holder[])new Holder[]{Holder.Reference.m_205766_(biomeRegistry, (ResourceKey)Biomes.f_48179_)}), HolderSet.m_205809_((Holder[])new Holder[]{Holder.Reference.m_205766_(biomeRegistry, (ResourceKey)Biomes.f_48197_)}), HolderSet.m_205809_((Holder[])new Holder[]{Holder.Reference.m_205766_(biomeRegistry, (ResourceKey)Biomes.f_186769_)})});
        TFndBiomeModifiers.addOreToBiomeGen(map, "apatite_ore", (HolderSet<Biome>)allBiomes, placedFeatureRegistry);
        TFndBiomeModifiers.addOreToBiomeGen(map, "cinnabar_ore", (HolderSet<Biome>)allBiomes, placedFeatureRegistry);
        TFndBiomeModifiers.addOreToBiomeGen(map, "niter_ore", (HolderSet<Biome>)allBiomes, placedFeatureRegistry);
        TFndBiomeModifiers.addOreToBiomeGen(map, "sulfur_ore", (HolderSet<Biome>)allBiomes, placedFeatureRegistry);
        TFndBiomeModifiers.addOreToBiomeGen(map, "tin_ore", (HolderSet<Biome>)allBiomes, placedFeatureRegistry);
        TFndBiomeModifiers.addOreToBiomeGen(map, "lead_ore", (HolderSet<Biome>)allBiomes, placedFeatureRegistry);
        TFndBiomeModifiers.addOreToBiomeGen(map, "silver_ore", (HolderSet<Biome>)allBiomes, placedFeatureRegistry);
        TFndBiomeModifiers.addOreToBiomeGen(map, "nickel_ore", (HolderSet<Biome>)allBiomes, placedFeatureRegistry);
        TFndBiomeModifiers.addOreToBiomeGen(map, "oil_sand", (HolderSet<Biome>)oilSandsBiomes, placedFeatureRegistry);
        TFndBiomeModifiers.addVegetationToBiomeGen(map, "rubberwood_tree", List.of("rubberwood_tree", "mega_rubberwood_tree"), (HolderSet<Biome>)rubberwoodTreeBiomes, placedFeatureRegistry);
    }

    public static void addOreToBiomeGen(Map<ResourceLocation, BiomeModifier> map, String name, HolderSet<Biome> biomes, Registry<PlacedFeature> placedFeatureRegistry) {
        map.put(new ResourceLocation("thermal", name + "_biome_spawns"), (BiomeModifier)FeatureHelper.addFeatureToBiomes((String)name, biomes, placedFeatureRegistry, (GenerationStep.Decoration)GenerationStep.Decoration.UNDERGROUND_ORES));
    }

    public static void addVegetationToBiomeGen(Map<ResourceLocation, BiomeModifier> map, String name, List<String> names, HolderSet<Biome> biomes, Registry<PlacedFeature> placedFeatureRegistry) {
        map.put(new ResourceLocation("thermal", name + "_biome_spawns"), (BiomeModifier)FeatureHelper.addFeaturesToBiomes(names, biomes, placedFeatureRegistry, (GenerationStep.Decoration)GenerationStep.Decoration.VEGETAL_DECORATION));
    }
}

