/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.block.entity.machine;

import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.item.SlotSealItem;
import cofh.thermal.core.util.managers.machine.CrystallizerRecipeManager;
import cofh.thermal.expansion.init.TExpTileEntities;
import cofh.thermal.expansion.inventory.container.machine.MachineCrystallizerContainer;
import cofh.thermal.lib.block.entity.MachineBlockEntity;
import cofh.thermal.lib.util.recipes.IMachineInventory;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;

public class MachineCrystallizerTile
extends MachineBlockEntity {
    protected ItemStorageCoFH[] inputSlots = new ItemStorageCoFH[2];
    protected ItemStorageCoFH outputSlot = new ItemStorageCoFH();
    protected FluidStorageCoFH inputTank = new FluidStorageCoFH(8000, fluid -> this.filter.valid(fluid) && CrystallizerRecipeManager.instance().validFluid(fluid));

    public MachineCrystallizerTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TExpTileEntities.MACHINE_CRYSTALLIZER_TILE.get(), pos, state);
        this.inputSlots[0] = new ItemStorageCoFH(item -> item.m_41720_() instanceof SlotSealItem || this.filter.valid(item) && CrystallizerRecipeManager.instance().validItem(item) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[1].getItemStack()));
        this.inputSlots[1] = new ItemStorageCoFH(item -> item.m_41720_() instanceof SlotSealItem || this.filter.valid(item) && CrystallizerRecipeManager.instance().validItem(item) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[0].getItemStack()));
        for (int i = 0; i < 2; ++i) {
            this.inventory.addSlot(this.inputSlots[i], StorageGroup.INPUT);
        }
        this.inventory.addSlot(this.outputSlot, StorageGroup.OUTPUT);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.tankInv.addTank(this.inputTank, StorageGroup.INPUT);
        this.addAugmentSlots(ThermalCoreConfig.machineAugments);
        this.initHandlers();
    }

    protected int getBaseProcessTick() {
        return CrystallizerRecipeManager.instance().getBasePower();
    }

    protected boolean cacheRecipe() {
        this.curRecipe = CrystallizerRecipeManager.instance().getRecipe((IThermalInventory)this);
        if (this.curRecipe != null) {
            this.itemInputCounts = this.curRecipe.getInputItemCounts((IMachineInventory)this);
            this.fluidInputCounts = this.curRecipe.getInputFluidCounts((IMachineInventory)this);
        }
        return this.curRecipe != null;
    }

    protected boolean cacheRenderFluid() {
        if (this.curRecipe == null) {
            return false;
        }
        if (this.inputTank.isEmpty()) {
            return false;
        }
        FluidStack prevFluid = this.renderFluid;
        this.renderFluid = new FluidStack(this.inputTank.getFluidStack(), 1000);
        return !FluidHelper.fluidsEqual((FluidStack)this.renderFluid, (FluidStack)prevFluid);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new MachineCrystallizerContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }
}

