/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.inventory.container.interblock;

import cofh.core.inventory.container.ContainerCoFH;
import cofh.core.network.packet.client.ContainerGuiPacket;
import cofh.core.network.packet.server.ContainerConfigPacket;
import cofh.core.util.filter.BaseFluidFilter;
import cofh.core.util.filter.IFilterOptions;
import cofh.lib.inventory.container.slot.SlotFalseCopy;
import cofh.lib.inventory.wrapper.InvWrapperFluids;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.dynamics.interblock.FluidServoInterblock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class FluidServoInterblockContainer
extends ContainerCoFH
implements IFilterOptions {
    public final FluidServoInterblock attachment = null;
    protected BaseFluidFilter filter = (BaseFluidFilter)this.attachment.getFilter();
    protected InvWrapperFluids filterInventory;

    public FluidServoInterblockContainer(int id, Level world, BlockPos pos, Direction side, Inventory inventory) {
        super(null, id, inventory, inventory.f_35978_);
        this.allowSwap = false;
        int slots = this.filter.size();
        this.filterInventory = new InvWrapperFluids((AbstractContainerMenu)this, this.filter.getFluids(), slots){

            public void m_6596_() {
                FluidServoInterblockContainer.this.filter.setFluids(FluidServoInterblockContainer.this.filterInventory.getStacks());
            }
        };
        int rows = MathHelper.clamp((int)(slots / 3), (int)1, (int)3);
        int rowSize = slots / rows;
        int xOffset = 53 - 9 * rowSize;
        int yOffset = 44 - 9 * rows;
        for (int i = 0; i < this.filter.size(); ++i) {
            this.m_38897_((Slot)new SlotFalseCopy((Container)this.filterInventory, i, xOffset + i % rowSize * 18, yOffset + i / rowSize * 18));
        }
        this.bindPlayerInventory(inventory);
    }

    public int getFilterSize() {
        return this.filter.size();
    }

    public List<FluidStack> getFilterStacks() {
        return this.filterInventory.getStacks();
    }

    protected int getMergeableSlotCount() {
        return this.filterInventory.m_6643_();
    }

    public boolean m_6875_(Player player) {
        return false;
    }

    public void m_38946_() {
        super.m_38946_();
        ContainerGuiPacket.sendToClient((ContainerCoFH)this, (Player)this.player);
    }

    public void m_6877_(Player playerIn) {
        this.filter.setFluids(this.filterInventory.getStacks());
        super.m_6877_(playerIn);
    }

    public FriendlyByteBuf getConfigPacket(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.getAllowList());
        buffer.writeBoolean(this.getCheckNBT());
        return buffer;
    }

    public void handleConfigPacket(FriendlyByteBuf buffer) {
        this.filter.setAllowList(buffer.readBoolean());
        this.filter.setCheckNBT(buffer.readBoolean());
    }

    public FriendlyByteBuf getGuiPacket(FriendlyByteBuf buffer) {
        int size = this.filter.getFluids().size();
        buffer.writeByte(size);
        for (int i = 0; i < size; ++i) {
            buffer.writeFluidStack(this.getFilterStacks().get(i));
        }
        return buffer;
    }

    public void handleGuiPacket(FriendlyByteBuf buffer) {
        int size = buffer.readByte();
        ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>(size);
        for (int i = 0; i < size; ++i) {
            fluidStacks.add(buffer.readFluidStack());
        }
        this.filterInventory.readFromSource(fluidStacks);
    }

    public boolean getAllowList() {
        return this.filter.getAllowList();
    }

    public boolean setAllowList(boolean allowList) {
        boolean ret = this.filter.setAllowList(allowList);
        ContainerConfigPacket.sendToServer((ContainerCoFH)this);
        return ret;
    }

    public boolean getCheckNBT() {
        return this.filter.getCheckNBT();
    }

    public boolean setCheckNBT(boolean checkNBT) {
        boolean ret = this.filter.setCheckNBT(checkNBT);
        ContainerConfigPacket.sendToServer((ContainerCoFH)this);
        return ret;
    }
}

