/*
 * Decompiled with CFR 0.152.
 */
package cofh.requack.collection.redblack;

import cofh.requack.collection.Object2IntPair;
import cofh.requack.collection.redblack.RedBlackNode;
import cofh.requack.util.Object2IntFunction;
import cofh.requack.util.SneakyUtils;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class BaseRedBlackTree<N extends RedBlackNode<N>> {
    private final Collection<N> entries = this.makeEntriesCollection();
    @Nullable
    private N root;
    private int _version;
    protected int count;

    public Collection<N> entries() {
        return this.entries;
    }

    public void insertAt(@Nullable N loc, boolean right, N node) {
        Object at;
        ++this.count;
        ++this._version;
        if (loc == null) {
            if (this.root != null) {
                loc = ((RedBlackNode)this.root).most(right);
            }
            if (loc == null) {
                this.setRoot(node);
                return;
            }
        }
        if ((at = ((RedBlackNode)loc).getChild(right)) != null) {
            right = !right;
            loc = ((RedBlackNode)at).most(right);
            at = ((RedBlackNode)loc).getChild(right);
        }
        boolean finalRight = right;
        Object finalLoc = loc;
        assert (SneakyUtils.sneaky(() -> this.lambda$insertAt$0(finalRight, (RedBlackNode)finalLoc, node)).booleanValue());
        ((RedBlackNode)loc).assign(right, node);
        ((RedBlackNode)node).setRed(true);
        if (((RedBlackNode)node).getParent() != null) {
            ((RedBlackNode)((RedBlackNode)node).getParent()).onChildrenChanged();
        }
        this.fixInsertion(node);
    }

    @Nullable
    public N find(Object2IntFunction<N> comp) {
        Object2IntPair<N> pair = this.closest(comp);
        return (N)(pair.getValue() == 0 ? (RedBlackNode)pair.getKey() : null);
    }

    public Object2IntPair<N> closest(Object2IntFunction<N> comp) {
        if (this.root == null) {
            return new Object2IntPair<Object>(null, 1);
        }
        Object node = this.root;
        int c;
        while ((c = comp.apply(node)) != 0) {
            Object next = ((RedBlackNode)node).getChild(c > 0);
            if (next == null) {
                return new Object2IntPair<N>(node, c);
            }
            node = next;
        }
        return new Object2IntPair<N>(node, c);
    }

    public void replace(N loc, N node) {
        assert (((RedBlackNode)loc).getRoot() == this.root);
        assert (SneakyUtils.sneaky(() -> {
            this.orderConsistencyCheck(loc.getPrev(), node);
            this.orderConsistencyCheck(node, loc.getNext());
            return true;
        }).booleanValue());
        this.replaceWith(loc, node);
        ((RedBlackNode)node).setRed(((RedBlackNode)loc).isRed());
        ((RedBlackNode)node).setLeft(((RedBlackNode)loc).getLeft());
        ((RedBlackNode)node).setRight(((RedBlackNode)loc).getRight());
        ((RedBlackNode)node).onChildrenChanged();
        if (((RedBlackNode)node).getParent() != null) {
            ((RedBlackNode)((RedBlackNode)node).getParent()).onChildrenChanged();
        }
    }

    public void insertRange(@Nullable N loc, Iterable<N> nodes) {
        for (RedBlackNode node : nodes) {
            this.orderConsistencyCheck(loc, node);
            this.insertAt(loc, true, node);
            loc = node;
        }
        assert (loc != null);
        this.orderConsistencyCheck(loc, ((RedBlackNode)loc).getNext());
    }

    public void removeRange(N first, N last) {
        this.orderConsistencyCheck(first, last);
        Object node = first;
        while (true) {
            Object next = ((RedBlackNode)node).getNext();
            this.entries.remove(node);
            if (node == last) {
                return;
            }
            node = next;
        }
    }

    public void buildFrom(List<N> nodes) {
        if (this.root != null) {
            throw new IllegalStateException("buildFrom called on non-empty tree");
        }
        int bh = 0;
        for (int i = nodes.size() + 1; i > 1; i >>= 1) {
            ++bh;
        }
        this.root = this.buildFrom(nodes, 0, nodes.size(), bh);
        this.count = nodes.size();
    }

    @Nullable
    public N buildFrom(List<N> nodes, int a, int b, int bh) {
        if (a == b) {
            return null;
        }
        int c = (a + b) / 2;
        RedBlackNode p = (RedBlackNode)nodes.get(c);
        p.setBlack(bh > 0);
        p.setLeft(this.buildFrom(nodes, a, c, bh - 1));
        p.setRight(this.buildFrom(nodes, c + 1, b, bh - 1));
        this.orderConsistencyCheck(p.getLeft(), p);
        this.orderConsistencyCheck(p, p.getRight());
        p.onChildrenChanged();
        return (N)p;
    }

    protected void orderConsistencyCheck(@Nullable N left, @Nullable N right) {
    }

    protected Entries makeEntriesCollection() {
        return new Entries();
    }

    @Nullable
    public N getRoot() {
        return this.root;
    }

    public void setRoot(@Nullable N root) {
        this.root = root;
        if (root != null) {
            ((RedBlackNode)root).makeRoot();
        }
    }

    @Nullable
    public N getLeftMost() {
        if (this.root == null) {
            return null;
        }
        return (N)((RedBlackNode)this.root).getLeftMost();
    }

    @Nullable
    public N getRightMost() {
        if (this.root == null) {
            return null;
        }
        return (N)((RedBlackNode)this.root).getRightMost();
    }

    private boolean isBlack(@Nullable N node) {
        return node == null || ((RedBlackNode)node).isBlack();
    }

    private void replaceWith(N node, @Nullable N replacement) {
        if (((RedBlackNode)node).getParent() == null) {
            this.setRoot(replacement);
        } else {
            ((RedBlackNode)((RedBlackNode)node).getParent()).assign(((RedBlackNode)node).getSide(), replacement);
        }
    }

    private void fixInsertion(N node) {
        assert (((RedBlackNode)node).isRed());
        Object p = ((RedBlackNode)node).getParent();
        if (this.isBlack(p)) {
            return;
        }
        if (p == this.root && ((RedBlackNode)p).isRed()) {
            ((RedBlackNode)p).setBlack(true);
            return;
        }
        Object g = ((RedBlackNode)p).getParent();
        Object u = ((RedBlackNode)p).getSibling();
        assert (g != null);
        if (this.isBlack(u)) {
            boolean pside;
            boolean nside = ((RedBlackNode)node).getSide();
            if (nside != (pside = ((RedBlackNode)p).getSide())) {
                this.rotate(p, !nside);
            }
            this.rotate(g, !pside);
            return;
        }
        ((RedBlackNode)p).setBlack(true);
        ((RedBlackNode)u).setBlack(true);
        ((RedBlackNode)g).setRed(true);
        this.fixInsertion(g);
    }

    private void fixRemoval(N p, boolean shortSide) {
        Object oNeph;
        Object s = ((RedBlackNode)p).getChild(!shortSide);
        assert (this.isBlack(((RedBlackNode)p).getChild(shortSide)));
        assert (s != null);
        if (((RedBlackNode)s).isRed()) {
            this.rotate(p, shortSide);
            s = ((RedBlackNode)p).getChild(!shortSide);
            assert (s != null);
            assert (((RedBlackNode)s).isBlack());
        }
        if (this.isBlack(oNeph = ((RedBlackNode)s).getChild(!shortSide))) {
            Object iNeph = ((RedBlackNode)s).getChild(shortSide);
            if (this.isBlack(iNeph)) {
                ((RedBlackNode)s).setRed(true);
                if (((RedBlackNode)p).isRed()) {
                    ((RedBlackNode)p).setBlack(true);
                } else if (p != this.root) {
                    this.fixRemoval(((RedBlackNode)p).requireParent(), ((RedBlackNode)p).getSide());
                }
                return;
            }
            this.rotate(s, !shortSide);
            ((RedBlackNode)iNeph).setBlack(true);
            oNeph = s;
            assert (this.isBlack(((RedBlackNode)p).getChild(!shortSide)));
            assert (oNeph == ((RedBlackNode)Objects.requireNonNull(((RedBlackNode)p).getChild(!shortSide))).getChild(!shortSide));
        }
        this.rotate(p, shortSide);
        ((RedBlackNode)oNeph).setBlack(true);
    }

    private void rotate(N node, boolean right) {
        N inc = ((RedBlackNode)node).getChild(!right);
        assert (inc != null);
        this.replaceWith(node, inc);
        ((RedBlackNode)node).assign(!right, ((RedBlackNode)inc).getChild(right));
        ((RedBlackNode)inc).assign(right, node);
        if (((RedBlackNode)node).isRed() != ((RedBlackNode)inc).isRed()) {
            ((RedBlackNode)node).setRed(!((RedBlackNode)node).isRed());
            ((RedBlackNode)inc).setRed(!((RedBlackNode)inc).isRed());
        }
        ((RedBlackNode)node).onChildrenChanged();
    }

    private /* synthetic */ Boolean lambda$insertAt$0(boolean finalRight, RedBlackNode finalLoc, RedBlackNode node) throws Throwable {
        RedBlackNode prev = finalRight ? finalLoc : finalLoc.getPrev();
        RedBlackNode next = finalRight ? finalLoc.getNext() : finalLoc;
        this.orderConsistencyCheck(prev, node);
        this.orderConsistencyCheck(node, next);
        return true;
    }

    protected class Entries
    extends AbstractCollection<N> {
        protected Entries() {
        }

        @Override
        public boolean remove(Object o) {
            Object child;
            if (!(o instanceof RedBlackNode)) {
                return false;
            }
            RedBlackNode maybeNode = (RedBlackNode)o;
            assert (maybeNode.getRoot() == BaseRedBlackTree.this.root);
            RedBlackNode node = (RedBlackNode)SneakyUtils.unsafeCast(maybeNode);
            --BaseRedBlackTree.this.count;
            BaseRedBlackTree.this._version++;
            RedBlackNode del = node;
            if (node.getLeft() != null && node.getRight() != null) {
                del = ((RedBlackNode)node.getRight()).getLeftMost();
            }
            assert (del.getLeft() == null || del.getRight() == null);
            Object t = child = del.getLeft() == null ? del.getRight() : del.getLeft();
            if (del.getParent() == null) {
                BaseRedBlackTree.this.setRoot(child);
                return true;
            }
            boolean doubleBlack = del.isBlack() && BaseRedBlackTree.this.isBlack(child);
            Object deletedFrom = del.getParent();
            boolean deletedSide = del.getSide();
            BaseRedBlackTree.this.replaceWith(del, child);
            if (child != null) {
                ((RedBlackNode)child).setBlack(true);
            }
            if (del != node) {
                BaseRedBlackTree.this.replaceWith(node, del);
                del.setRed(node.isRed());
                del.setLeft(node.getLeft());
                del.setRight(node.getRight());
                if (deletedFrom == node) {
                    deletedFrom = del;
                }
            }
            if (deletedFrom != null) {
                ((RedBlackNode)deletedFrom).onChildrenChanged();
            }
            if (node.getParent() != null) {
                ((RedBlackNode)node.getParent()).onChildrenChanged();
            }
            if (doubleBlack) {
                assert (deletedFrom != null);
                BaseRedBlackTree.this.fixRemoval(deletedFrom, deletedSide);
            }
            return true;
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException("Use ComparableRedBlackTree");
        }

        @Override
        public boolean add(N t) {
            throw new UnsupportedOperationException("Use ComparableRedBlackTree");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean r = false;
            for (Object o : c) {
                RedBlackNode node;
                if (!(o instanceof RedBlackNode) || (node = (RedBlackNode)o).getRoot() != BaseRedBlackTree.this.root) continue;
                r |= this.remove(node);
            }
            return r;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("Use ComparableRedBlackTree");
        }

        @Override
        public int size() {
            return BaseRedBlackTree.this.count;
        }

        @Override
        public Iterator<N> iterator() {
            final int v = BaseRedBlackTree.this._version;
            return new Iterator<N>(){
                @Nullable
                N n;
                {
                    this.n = BaseRedBlackTree.this.getLeftMost();
                }

                @Override
                public boolean hasNext() {
                    return this.n != null;
                }

                @Override
                public N next() {
                    assert (this.n != null);
                    if (v != BaseRedBlackTree.this._version) {
                        throw new ConcurrentModificationException();
                    }
                    Object curr = this.n;
                    this.n = ((RedBlackNode)curr).getNext();
                    return curr;
                }
            };
        }

        @Override
        public void clear() {
            BaseRedBlackTree.this.setRoot(null);
            BaseRedBlackTree.this.count = 0;
            BaseRedBlackTree.this._version++;
        }
    }
}

