/*
 * Decompiled with CFR 0.152.
 */
package com.syric.tetranomicon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.syric.tetranomicon.Tetranomicon;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.module.data.MaterialData;

@OnlyIn(value=Dist.CLIENT)
public class Debugging {
    @SubscribeEvent
    void addToTooltip(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull RenderTooltipEvent.GatherComponents event) {
    }

    @SubscribeEvent
    void checkMissingMaterials(ServerChatEvent event) {
        if (!((Boolean)ConfigHandler.development.get()).booleanValue()) {
            return;
        }
        String rawText = event.getRawText();
        if (rawText.contains("tetranomicon check missing")) {
            Tetranomicon.LOGGER.debug("Tetranomicon: scanning for missing materials...");
            for (MaterialData materialData : DataManager.instance.materialData.getData().values()) {
                if (materialData.material.getApplicableItemStacks().length != 0) continue;
                Tetranomicon.LOGGER.debug("Material missing item: " + materialData.key);
            }
        }
    }

    @SubscribeEvent
    void checkCandidates(ServerChatEvent event) {
        if (!((Boolean)ConfigHandler.development.get()).booleanValue()) {
            return;
        }
        String rawText = event.getRawText();
        if (rawText.contains("tetranomicon check candidates")) {
            Tetranomicon.LOGGER.debug("Tetranomicon: scanning for unused candidates...");
            ForgeRegistries.ITEMS.getEntries().stream().filter(x -> {
                ItemStack stack = ((Item)x.getValue()).m_7968_();
                String item_id = ((Item)x.getValue()).toString();
                String mod_id = ((Item)x.getValue()).getCreatorModId(stack);
                boolean likelyCandidateTags = stack.m_204117_(Tags.Items.STONE) || stack.m_204117_(ItemTags.f_13168_) || stack.m_204117_(Tags.Items.INGOTS) || stack.m_204117_(Tags.Items.GEMS);
                boolean likelyCandidateID = item_id.contains("planks") || item_id.contains("ingot") || item_id.contains("vine") || item_id.contains("bone");
                boolean minecraft = mod_id == null || mod_id.contains("minecraft");
                return likelyCandidateID || likelyCandidateTags && !minecraft;
            }).filter(x -> DataManager.instance.materialData.getData().values().stream().noneMatch(y -> {
                ItemPredicate predicate = y.material.getPredicate();
                if (predicate != null) {
                    if (y.material.isTagged()) {
                        return false;
                    }
                    return predicate.m_45049_(((Item)x.getValue()).m_7968_());
                }
                return false;
            })).filter(x -> !((Item)x.getValue()).toString().contains("vertical")).filter(x -> !((Item)x.getValue()).toString().contains("dyed")).filter(x -> !((Item)x.getValue()).toString().contains("polished")).filter(x -> !((Item)x.getValue()).toString().contains("slab")).filter(x -> !((Item)x.getValue()).toString().contains("stairs")).filter(x -> !((Item)x.getValue()).toString().contains("painted")).filter(x -> !((Item)x.getValue()).toString().contains("mossy")).filter(x -> !((Item)x.getValue()).toString().contains("olivine")).forEach(x -> Tetranomicon.LOGGER.debug("Candidate that is not a material: " + ((Item)x.getValue()).getCreatorModId(((Item)x.getValue()).m_7968_()) + ":" + x.getValue()));
        }
    }

    @SubscribeEvent
    void checkMissingReplacements(ServerChatEvent event) {
        if (!((Boolean)ConfigHandler.development.get()).booleanValue()) {
            return;
        }
        String rawText = event.getRawText();
        if (rawText.contains("tetranomicon missing replacements")) {
            Tetranomicon.LOGGER.debug("Tetranomicon: scanning for missing replacements...");
            DataManager.instance.replacementData.getData().values().forEach(replacementList -> Arrays.stream(replacementList).filter(replacement -> ForgeRegistries.ITEMS.getEntries().stream().noneMatch(item -> replacement.predicate.m_45049_(((Item)item.getValue()).m_7968_()))).forEach(replacement -> {
                JsonObject jsonObject = replacement.predicate.m_45048_().getAsJsonObject();
                JsonElement items = jsonObject.get("items");
                StringBuilder itemsList = new StringBuilder();
                if (items instanceof JsonArray) {
                    JsonArray jsonArray = (JsonArray)items;
                    for (JsonElement item : jsonArray) {
                        itemsList.append(item.getAsString());
                        itemsList.append(", ");
                    }
                }
                if (items != null) {
                    Tetranomicon.LOGGER.debug("Replacement missing item: " + replacement.itemStack.toString() + " / " + itemsList);
                }
            }));
        }
    }

    @SubscribeEvent
    void checkReplacementCandidates(ServerChatEvent event) {
        if (!((Boolean)ConfigHandler.development.get()).booleanValue()) {
            return;
        }
        String rawText = event.getRawText();
        if (rawText.contains("tetranomicon check replacement candidates")) {
            Tetranomicon.LOGGER.debug("Tetranomicon: scanning for replacement candidates...");
            ArrayList<TagKey> tagKeys = new ArrayList<TagKey>(Arrays.asList(Tags.Items.TOOLS, Tags.Items.TOOLS_AXES, Tags.Items.TOOLS_PICKAXES, Tags.Items.TOOLS_SHOVELS, Tags.Items.TOOLS_HOES, Tags.Items.TOOLS_SWORDS, Tags.Items.TOOLS_BOWS));
            ArrayList<String> tool_names = new ArrayList<String>(Arrays.asList("_axe", "_pickaxe", "_shovel", "_pick", "_hoe", "_sword", "_bow"));
            ForgeRegistries.ITEMS.getEntries().stream().filter(x -> {
                Item item = (Item)x.getValue();
                ItemStack stack = item.m_7968_();
                String item_id = item.toString();
                String mod_id = item.getCreatorModId(stack);
                boolean likelyCandidateTags = tagKeys.stream().anyMatch(arg_0 -> ((ItemStack)stack).m_204117_(arg_0));
                boolean likelyCandidateStrings = tool_names.stream().anyMatch(item_id::contains);
                boolean minecraft = mod_id == null || mod_id.contains("minecraft");
                return (likelyCandidateStrings || likelyCandidateTags) && !minecraft;
            }).filter(x -> DataManager.instance.replacementData.getData().values().stream().noneMatch(replacementList -> {
                ItemStack stack = ((Item)x.getValue()).m_7968_();
                return Arrays.stream(replacementList).anyMatch(replacement -> replacement.predicate.m_45049_(stack));
            })).forEach(x -> Tetranomicon.LOGGER.debug("Candidate tool not replaced: " + ((Item)x.getValue()).getCreatorModId(((Item)x.getValue()).m_7968_()) + ":" + x.getValue()));
        }
    }

    private static /* synthetic */ boolean lambda$addToTooltip$0(ItemStack stack, MaterialData x) {
        ItemPredicate predicate = x.material.getPredicate();
        if (predicate != null) {
            if (x.material.isTagged()) {
                return false;
            }
            return predicate.m_45049_(stack);
        }
        return false;
    }
}

