/*
 * Decompiled with CFR 0.152.
 */
package io.github.persiflagetheninth.tetra_nihilo.compat;

import dev.ftb.ftbsba.tools.recipies.CrookDropsResult;
import dev.ftb.ftbsba.tools.recipies.ItemWithChance;
import dev.ftb.ftbsba.tools.recipies.ToolsRecipeCache;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;
import novamachina.exnihilosequentia.common.block.InfestedLeavesBlock;
import novamachina.exnihilosequentia.common.crafting.ItemStackWithChance;
import novamachina.exnihilosequentia.common.crafting.crook.CrookRecipe;
import novamachina.exnihilosequentia.common.init.ExNihiloItems;
import novamachina.exnihilosequentia.common.registries.ExNihiloRegistries;
import novamachina.exnihilosequentia.common.utility.Config;

public class NihiloToolCompat {
    public static boolean isLoaded(String mod) {
        return ModList.get().isLoaded(mod);
    }

    public static boolean canHammer(BlockState state) {
        if (NihiloToolCompat.isLoaded("exnihilosequentia")) {
            return NihiloHelper.hammerable(state);
        }
        if (NihiloToolCompat.isLoaded("ftbsba")) {
            return FTBHelper.hammerable(state);
        }
        return false;
    }

    public static ObjectArrayList<ItemStack> getHammerDrops(Level level, BlockState state, RandomSource random) {
        if (NihiloToolCompat.isLoaded("exnihilosequentia")) {
            return NihiloHelper.hammerDrops(level, state.m_60734_(), random);
        }
        if (NihiloToolCompat.isLoaded("ftbsba")) {
            return FTBHelper.hammerDrops(level, new ItemStack((ItemLike)state.m_60734_()));
        }
        return new ObjectArrayList();
    }

    public static boolean canCrook(BlockState state) {
        if (NihiloToolCompat.isLoaded("exnihilosequentia")) {
            return NihiloHelper.crookable(state);
        }
        if (NihiloToolCompat.isLoaded("ftbsba")) {
            return FTBHelper.crookable(state);
        }
        return false;
    }

    public static ObjectArrayList<ItemStack> getCrookDrops(ObjectArrayList<ItemStack> generatedLoot, Level level, BlockState state, RandomSource random) {
        if (NihiloToolCompat.isLoaded("exnihilosequentia")) {
            ObjectArrayList<ItemStack> newLoot = NihiloHelper.crookDrops(level, state.m_60734_(), random);
            generatedLoot.addAll(newLoot);
            return generatedLoot;
        }
        if (NihiloToolCompat.isLoaded("ftbsba")) {
            return FTBHelper.crookDrops(level, new ItemStack((ItemLike)state.m_60734_()), random);
        }
        return new ObjectArrayList();
    }

    public static class NihiloHelper {
        public static boolean hammerable(BlockState state) {
            return ExNihiloRegistries.HAMMER_REGISTRY.isHammerable(state.m_60734_());
        }

        public static boolean crookable(BlockState state) {
            return ExNihiloRegistries.CROOK_REGISTRY.isCrookable((ItemLike)state.m_60734_());
        }

        public static ObjectArrayList<ItemStack> hammerDrops(Level level, Block block, RandomSource random) {
            ObjectArrayList loot = new ObjectArrayList();
            List list = ExNihiloRegistries.HAMMER_REGISTRY.getResult(block);
            for (ItemStackWithChance stack : list) {
                if (!(random.m_188501_() <= stack.getChance()) || stack.getStack() == ItemStack.f_41583_) continue;
                loot.add((Object)stack.getStack());
            }
            return loot;
        }

        public static ObjectArrayList<ItemStack> crookDrops(Level level, Block block, RandomSource random) {
            ObjectArrayList loot = new ObjectArrayList();
            List list = ExNihiloRegistries.CROOK_REGISTRY.getDrops((ItemLike)block);
            for (CrookRecipe recipe : list) {
                for (ItemStackWithChance stack : recipe.getOutput()) {
                    if (!(random.m_188501_() <= stack.getChance()) || stack.getStack() == ItemStack.f_41583_) continue;
                    loot.add((Object)stack.getStack());
                }
            }
            if (block instanceof InfestedLeavesBlock) {
                loot.add((Object)new ItemStack((ItemLike)Items.f_42401_, random.m_188503_(Config.getMaxBonusStringCount()) + Config.getMinStringCount()));
                if (random.m_188500_() <= 0.8) {
                    loot.add((Object)new ItemStack((ItemLike)ExNihiloItems.SILKWORM.get()));
                }
            }
            return loot;
        }
    }

    public static class FTBHelper {
        public static boolean hammerable(BlockState state) {
            return ToolsRecipeCache.hammerable((BlockState)state);
        }

        public static boolean crookable(BlockState state) {
            return ToolsRecipeCache.crookable((BlockState)state);
        }

        public static ObjectArrayList<ItemStack> hammerDrops(Level level, ItemStack block) {
            ObjectArrayList loot = new ObjectArrayList();
            List ftbLoot = ToolsRecipeCache.getHammerDrops((Level)level, (ItemStack)block);
            ftbLoot.stream().map(ItemStack::m_41777_).forEach(arg_0 -> ((ObjectArrayList)loot).add(arg_0));
            return loot;
        }

        public static ObjectArrayList<ItemStack> crookDrops(Level level, ItemStack block, RandomSource random) {
            ObjectArrayList loot = new ObjectArrayList();
            CrookDropsResult ftbLoot = ToolsRecipeCache.getCrookDrops((Level)level, (ItemStack)block);
            for (ItemWithChance stack : ftbLoot.items()) {
                if (!((double)random.m_188501_() <= stack.chance()) || stack.item() == ItemStack.f_41583_) continue;
                loot.add((Object)stack.item());
            }
            if (loot.size() > ftbLoot.max()) {
                Collections.shuffle(loot);
                loot.size(ftbLoot.max());
            }
            return loot;
        }
    }
}

