/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.improvement;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.TetraSounds;
import se.mickelus.tetra.blocks.workbench.gui.GuiModuleGlyph;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.schematic.SchematicRarity;

@ParametersAreNonnullByDefault
public class SettleToast
implements Toast {
    private static final ResourceLocation texture = new ResourceLocation("tetra", "textures/gui/toasts.png");
    private final ItemStack itemStack;
    private final String moduleName;
    private final GuiModuleGlyph glyph;
    private boolean hasPlayedSound = false;

    public SettleToast(ItemStack itemStack, String slot) {
        this.itemStack = itemStack;
        ItemModule itemModule = CastOptional.cast((Object)itemStack.m_41720_(), IModularItem.class).map(item -> item.getModuleFromSlot(itemStack, slot)).orElse(null);
        this.glyph = Optional.ofNullable(itemModule).map(module -> module.getVariantData(itemStack)).map(data -> data.glyph).map(glyphData -> new GuiModuleGlyph(0, 0, 16, 16, (GlyphData)glyphData).setShift(false)).orElse(null);
        this.moduleName = Optional.ofNullable(itemModule).map(module -> module.getName(itemStack)).orElse(slot);
    }

    public Toast.Visibility m_7172_(PoseStack matrixStack, ToastComponent toastGui, long delta) {
        if (this.itemStack != null) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            toastGui.m_93228_(matrixStack, 0, 0, 0, 0, 160, 32);
            if (!this.hasPlayedSound && delta > 0L) {
                this.hasPlayedSound = true;
                toastGui.m_94929_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)TetraSounds.settle, (float)1.0f, (float)1.0f));
            }
            if (this.glyph != null) {
                toastGui.m_93228_(matrixStack, 20, 14, 160, 0, 15, 15);
                this.glyph.draw(new PoseStack(), 19, 14, 260, 43, -1, -1, 1.0f);
            }
            toastGui.m_94929_().f_91062_.m_92883_(matrixStack, I18n.m_118938_((String)"tetra.settled.toast", (Object[])new Object[0]), 30.0f, 7.0f, SchematicRarity.hone.tint);
            toastGui.m_94929_().f_91062_.m_92883_(matrixStack, toastGui.m_94929_().f_91062_.m_92834_(this.moduleName, 118), 37.0f, 18.0f, 0x7F7F7F);
            toastGui.m_94929_().m_91291_().m_115203_(this.itemStack, 8, 8);
            return delta > 5000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
        }
        return Toast.Visibility.HIDE;
    }
}

