/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt.booster;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerInputPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltHelper;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.QuickslotInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.StorageInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.ToolbeltInventory;

@ParametersAreNonnullByDefault
public class UtilBooster {
    public static final String activeKey = "booster.active";
    public static final String chargedKey = "booster.charged";
    public static final String fuelKey = "booster.fuel";
    public static final String bufferKey = "booster.buffer";
    public static final String cooldownKey = "booster.cooldown";
    public static final int fuelCapacity = 110;
    public static final int fuelCost = 1;
    public static final int fuelCostCharged = 40;
    public static final int fuelRecharge = 1;
    public static final int cooldownTicks = 20;
    public static final int gunpowderGain = 80;
    public static final float boostStrength = 0.04f;
    public static final float chargedBoostStrength = 1.2f;
    public static final float boostLevelMultiplier = 0.4f;

    public static boolean hasBooster(Player player) {
        ItemStack itemStack = ToolbeltHelper.findToolbelt(player);
        return UtilBooster.canBoost(itemStack);
    }

    public static boolean canBoost(ItemStack itemStack) {
        return UtilBooster.getBoosterLevel(itemStack) > 0;
    }

    public static int getBoosterLevel(ItemStack itemStack) {
        if (!itemStack.m_41619_() && itemStack.m_41720_() instanceof IModularItem) {
            IModularItem item = (IModularItem)itemStack.m_41720_();
            return item.getEffectLevel(itemStack, ItemEffect.booster);
        }
        return 0;
    }

    public static boolean hasFuel(CompoundTag tag, boolean charged) {
        if (charged) {
            return tag.m_128451_(fuelKey) >= 40;
        }
        return tag.m_128451_(fuelKey) >= 1;
    }

    public static int getFuel(CompoundTag tag) {
        return tag.m_128451_(fuelKey);
    }

    public static float getFuelPercent(CompoundTag tag) {
        return (float)tag.m_128451_(fuelKey) * 1.0f / 110.0f;
    }

    public static void boostPlayer(Player player, CompoundTag tag, int level) {
        float boostBase = 0.04f + 0.04f * (float)(level - 1) * 0.4f;
        if (player.m_21255_()) {
            Vec3 Vector3d = player.m_20154_();
            player.m_5997_(Vector3d.f_82479_ * (double)0.01f + (Vector3d.f_82479_ * 1.5 - player.m_20184_().f_82479_) * (double)0.05f, Vector3d.f_82480_ * (double)0.01f + (Vector3d.f_82480_ * 1.5 - player.m_20184_().f_82480_) * (double)0.05f, Vector3d.f_82481_ * (double)0.01f + (Vector3d.f_82481_ * 1.5 - player.m_20184_().f_82481_) * (double)0.05f);
        } else if (player.m_20184_().f_82480_ > -0.1) {
            if (player.m_6047_()) {
                player.m_5997_(0.0, (double)boostBase / 1.5, 0.0);
            } else {
                player.m_5997_(0.0, (double)boostBase, 0.0);
            }
            player.f_19789_ = 0.0f;
        } else {
            player.m_5997_(0.0, (double)boostBase + 0.8 * -player.m_20184_().f_82480_, 0.0);
        }
        if (player.f_19853_ instanceof ServerLevel) {
            ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123762_, player.m_20185_() - 0.2 + Math.random() * 0.4, player.m_20186_() + Math.random() * 0.2, player.m_20189_() - 0.2 + Math.random() * 0.4, 8, 0.0, -0.3, 0.0, 0.1);
            if (Math.random() > 0.3) {
                ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123744_, player.m_20185_() - 0.2 + Math.random() * 0.4, player.m_20186_() + Math.random() * 0.2, player.m_20189_() - 0.2 + Math.random() * 0.4, 1, 0.0, -0.3, 0.0, 0.1);
            }
        }
    }

    public static void boostHorizontal(Player player) {
        ItemStack itemStack;
        int level;
        if ((player.f_20902_ != 0.0f || player.f_20900_ != 0.0f) && (level = UtilBooster.getBoosterLevel(itemStack = ToolbeltHelper.findToolbelt(player))) > 0) {
            CastOptional.cast((Object)player, LocalPlayer.class).ifPresent(cp -> cp.f_108617_.m_104955_((Packet)new ServerboundPlayerInputPacket(cp.f_20900_, cp.f_20902_, cp.f_108618_.f_108572_, cp.f_108618_.f_108573_)));
            CompoundTag tag = itemStack.m_41784_();
            if (UtilBooster.hasFuel(tag, false)) {
                UtilBooster.consumeFuel(tag, false);
                player.m_19920_(0.05f, new Vec3((double)player.f_20900_, (double)player.f_20901_, (double)player.f_20902_));
                if (player.f_19853_.f_46443_) {
                    Vec3 direction = UtilBooster.getAbsoluteMotion(-player.f_20900_, -player.f_20902_, player.m_146908_());
                    for (int i = 0; i < 8; ++i) {
                        player.m_20193_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, player.m_20185_(), player.m_20186_() + (double)player.m_20206_() * 0.4, player.m_20189_(), Math.random() * (0.2 * direction.f_82479_ + 0.07) - 0.05, Math.random() * 0.1 - 0.05, Math.random() * (0.2 * direction.f_82481_ + 0.07) - 0.05);
                    }
                    if (Math.random() > 0.3) {
                        player.m_20193_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, player.m_20185_(), player.m_20186_() + (double)player.m_20206_() * 0.4, player.m_20189_(), Math.random() * (0.2 * direction.f_82479_ + 0.07) - 0.05, Math.random() * 0.1 - 0.05, Math.random() * (0.2 * direction.f_82481_ + 0.07) - 0.05);
                    }
                }
            }
        }
    }

    private static Vec3 getAbsoluteMotion(float strafe, float forward, float facing) {
        float sin = Mth.m_14031_((float)(facing * ((float)Math.PI / 180)));
        float cos = Mth.m_14089_((float)(facing * ((float)Math.PI / 180)));
        return new Vec3((double)(strafe * cos - forward * sin), 0.0, (double)(forward * cos + strafe * sin));
    }

    public static void boostPlayerCharged(Player player, CompoundTag tag, int level) {
        float boostBase = 1.2f + 1.2f * (float)(level - 1) * 0.4f;
        Vec3 lookVector = player.m_20154_();
        player.m_20256_(lookVector.m_82490_(player.m_20184_().m_82526_(lookVector) / lookVector.m_82526_(lookVector)));
        player.m_5997_(lookVector.f_82479_ * (double)boostBase, Math.max(lookVector.f_82480_ * (double)boostBase / 2.0 + 0.3, 0.1), lookVector.f_82481_ * (double)boostBase);
        player.f_19864_ = true;
        player.m_6478_(MoverType.SELF, new Vec3(0.0, 0.4, 0.0));
        if (player.f_19853_ instanceof ServerLevel) {
            ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123755_, player.m_20185_(), player.m_20186_() + (double)player.m_20206_() * 0.4, player.m_20189_(), 10, 0.0, -0.1, 0.0, 0.1);
            ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123744_, player.m_20185_(), player.m_20186_() + (double)player.m_20206_() * 0.4, player.m_20189_(), 3, 0.0, -0.1, 0.0, 0.1);
        }
    }

    public static void consumeFuel(CompoundTag tag, boolean charged) {
        if (charged) {
            tag.m_128405_(fuelKey, tag.m_128451_(fuelKey) - 40);
        } else {
            tag.m_128405_(fuelKey, tag.m_128451_(fuelKey) - 1);
        }
        tag.m_128405_(cooldownKey, 20);
    }

    public static void consumeFuel(CompoundTag tag, int amount) {
        tag.m_128405_(fuelKey, tag.m_128451_(fuelKey) - amount);
        tag.m_128405_(cooldownKey, 20);
    }

    public static void rechargeFuel(CompoundTag tag, ItemStack itemStack) {
        int fuel = tag.m_128451_(fuelKey);
        int buffer = tag.m_128451_(bufferKey);
        int cooldown = tag.m_128451_(cooldownKey);
        if (cooldown > 0) {
            tag.m_128405_(cooldownKey, cooldown - 1);
        } else if (fuel + 1 < 110) {
            if (buffer > 0) {
                tag.m_128405_(fuelKey, fuel + 1);
                tag.m_128405_(bufferKey, buffer - 1);
            } else {
                UtilBooster.refuelBuffer(tag, itemStack);
            }
        }
    }

    private static void refuelBuffer(CompoundTag tag, ItemStack itemStack) {
        ToolbeltInventory inventory = new QuickslotInventory(itemStack);
        int index = inventory.getFirstIndexForItem(Items.f_42403_);
        if (index != -1) {
            inventory.m_7407_(index, 1);
            tag.m_128405_(bufferKey, 80);
            return;
        }
        inventory = new StorageInventory(itemStack);
        index = inventory.getFirstIndexForItem(Items.f_42403_);
        if (index != -1) {
            inventory.m_7407_(index, 1);
            tag.m_128405_(bufferKey, 80);
            return;
        }
        tag.m_128405_(cooldownKey, 20);
    }

    public static boolean isActive(CompoundTag tag) {
        return tag.m_128471_(activeKey);
    }

    public static void setActive(CompoundTag tag, boolean active, boolean charged) {
        tag.m_128379_(activeKey, active);
        if (charged) {
            tag.m_128379_(chargedKey, charged);
        }
    }
}

