/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.language.I18n;
import se.mickelus.mutil.gui.GuiAttachment;
import se.mickelus.mutil.gui.GuiClickable;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiString;
import se.mickelus.mutil.gui.GuiStringOutline;
import se.mickelus.mutil.gui.GuiTexture;
import se.mickelus.mutil.gui.animation.Applier;
import se.mickelus.mutil.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.gui.GuiTextures;

@ParametersAreNonnullByDefault
public class HoloImprovementButton
extends GuiClickable {
    private final KeyframeAnimation showAnimation;
    private final KeyframeAnimation hideAnimation;
    GuiString label = new GuiStringOutline(0, 0, I18n.m_118938_((String)"tetra.holo.craft.improvement_button", (Object[])new Object[]{"00"}));
    List<KeyframeAnimation> hoverAnimations;
    List<KeyframeAnimation> blurAnimations;
    boolean hasImprovements = false;

    public HoloImprovementButton(int x, int y, Runnable onClick) {
        super(x, y, 0, 19, onClick);
        GuiTexture texture;
        int texX;
        int i;
        this.label.setAttachment(GuiAttachment.middleCenter);
        this.width = this.label.getWidth() + 16;
        this.hoverAnimations = new ArrayList<KeyframeAnimation>();
        this.blurAnimations = new ArrayList<KeyframeAnimation>();
        for (i = 0; i < 3; ++i) {
            texX = i * -5 + 8;
            texture = new GuiTexture(texX, 0, 15, 15, 222, 16, GuiTextures.workbench);
            texture.setAttachment(GuiAttachment.middleLeft);
            this.addChild((GuiElement)texture);
            this.hoverAnimations.add(new KeyframeAnimation(100, (GuiElement)texture).applyTo(new Applier[]{new Applier.TranslateX((float)(texX - i * 3 - 2)), new Applier.TranslateY(0.0f)}).withDelay((3 - i) * 40));
            this.blurAnimations.add(new KeyframeAnimation(100, (GuiElement)texture).applyTo(new Applier[]{new Applier.TranslateX((float)texX), new Applier.TranslateY(0.0f)}).withDelay(i * 40));
        }
        for (i = 0; i < 3; ++i) {
            texX = i * 5 - 8;
            texture = new GuiTexture(texX, 0, 15, 15, 237, 16, GuiTextures.workbench);
            texture.setAttachment(GuiAttachment.middleRight);
            this.addChild((GuiElement)texture);
            this.hoverAnimations.add(new KeyframeAnimation(100, (GuiElement)texture).applyTo(new Applier[]{new Applier.TranslateX((float)(texX + i * 3 + 2)), new Applier.TranslateY(0.0f)}).withDelay((3 - i) * 40));
            this.blurAnimations.add(new KeyframeAnimation(100, (GuiElement)texture).applyTo(new Applier[]{new Applier.TranslateX((float)texX), new Applier.TranslateY(0.0f)}).withDelay(i * 40));
        }
        this.addChild(new GuiTexture(-26, 1, 11, 11, 193, 31, GuiTextures.workbench).setAttachment(GuiAttachment.middleLeft));
        this.addChild(new GuiTexture(26, 1, 11, 11, 193, 31, GuiTextures.workbench).setAttachment(GuiAttachment.middleRight));
        this.addChild((GuiElement)this.label);
        this.showAnimation = new KeyframeAnimation(60, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(1.0f)}).withDelay(100);
        this.hideAnimation = new KeyframeAnimation(60, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(0.0f)}).onStop(complete -> {
            if (complete.booleanValue()) {
                this.isVisible = false;
            }
        });
    }

    public void updateCount(int count) {
        this.label.setString(I18n.m_118938_((String)"tetra.holo.craft.improvement_button", (Object[])new Object[]{count}));
        this.hasImprovements = count > 0;
        this.label.setColor(this.hasImprovements ? 0xFFFFFF : 0x7F7F7F);
        this.blurAnimations.forEach(KeyframeAnimation::start);
    }

    public void show() {
        this.hideAnimation.stop();
        this.setVisible(true);
        this.setOpacity(0.0f);
        this.showAnimation.start();
    }

    public void hide() {
        this.showAnimation.stop();
        this.hideAnimation.start();
    }

    public boolean onMouseClick(int x, int y, int button) {
        if (this.hasImprovements) {
            return super.onMouseClick(x, y, button);
        }
        return false;
    }

    protected void onFocus() {
        super.onFocus();
        if (this.hasImprovements) {
            this.label.setColor(0xFFFFCC);
            this.blurAnimations.forEach(KeyframeAnimation::stop);
            this.hoverAnimations.forEach(KeyframeAnimation::start);
        }
    }

    protected void onBlur() {
        super.onBlur();
        if (this.hasImprovements) {
            this.label.setColor(0xFFFFFF);
            this.hoverAnimations.forEach(KeyframeAnimation::stop);
            this.blurAnimations.forEach(KeyframeAnimation::start);
        }
    }
}

