/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.interactions;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import se.mickelus.mutil.network.BlockPosPacket;
import se.mickelus.tetra.interactions.SecondaryInteraction;
import se.mickelus.tetra.interactions.SecondaryInteractionHandler;

public class SecondaryInteractionPacket
extends BlockPosPacket {
    private String key;
    private int targetId = -1;

    public SecondaryInteractionPacket() {
    }

    public SecondaryInteractionPacket(String key, BlockPos pos, Entity target) {
        super(pos);
        this.key = key;
        this.targetId = Optional.ofNullable(target).map(Entity::m_19879_).orElse(-1);
    }

    public void toBytes(FriendlyByteBuf buffer) {
        super.toBytes(buffer);
        buffer.m_130070_(this.key);
        buffer.writeInt(this.targetId);
    }

    public void fromBytes(FriendlyByteBuf buffer) {
        super.fromBytes(buffer);
        this.key = buffer.m_130277_();
        this.targetId = buffer.readInt();
    }

    public void handle(Player player) {
        Entity target = Optional.of(this.targetId).filter(id -> id != -1).map(id -> player.f_19853_.m_6815_(id.intValue())).orElse(null);
        SecondaryInteraction interaction = SecondaryInteractionHandler.getInteraction(this.key);
        if (interaction != null) {
            interaction.perform(player, player.m_9236_(), this.pos, target);
        }
    }
}

