/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.stats.getter;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.ToolAction;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;
import se.mickelus.tetra.gui.stats.getter.StatGetterAttribute;
import se.mickelus.tetra.gui.stats.getter.StatGetterEnchantmentLevel;
import se.mickelus.tetra.gui.stats.getter.StatGetterSum;
import se.mickelus.tetra.gui.stats.getter.StatGetterToolCompoundEfficiency;
import se.mickelus.tetra.gui.stats.getter.StatGetterToolEfficiency;
import se.mickelus.tetra.gui.stats.getter.StatGetterToolLevel;
import se.mickelus.tetra.items.modular.ItemModularHandheld;

@ParametersAreNonnullByDefault
public class TooltipGetterTool
implements ITooltipGetter {
    private final IStatGetter levelGetter;
    private final IStatGetter baseEfficiencyGetter;
    private final IStatGetter attackSpeedGetter;
    private final IStatGetter enchantmentGetter;
    private final IStatGetter totalEfficiencyGetter;
    private final String localizationKey;
    private final boolean includeSpeedModifier;

    public TooltipGetterTool(ToolAction tool, boolean includeSpeedModifier) {
        this.localizationKey = "tetra.stats." + tool.name() + ".tooltip";
        this.includeSpeedModifier = includeSpeedModifier;
        this.levelGetter = new StatGetterToolLevel(tool);
        this.baseEfficiencyGetter = new StatGetterToolEfficiency(tool);
        this.attackSpeedGetter = new StatGetterAttribute(Attributes.f_22283_);
        this.enchantmentGetter = new StatGetterEnchantmentLevel(Enchantments.f_44984_, 1.0);
        this.totalEfficiencyGetter = includeSpeedModifier ? new StatGetterToolCompoundEfficiency(this.baseEfficiencyGetter, this.attackSpeedGetter, this.enchantmentGetter) : new StatGetterSum(this.baseEfficiencyGetter, this.enchantmentGetter);
    }

    @Override
    public String getTooltipBase(Player player, ItemStack itemStack) {
        double enchantmentBonus = ItemModularHandheld.getEfficiencyEnchantmentBonus((int)this.enchantmentGetter.getValue(player, itemStack));
        double speedMultiplier = ItemModularHandheld.getAttackSpeedHarvestModifier(this.attackSpeedGetter.getValue(player, itemStack));
        Object speedString = ChatFormatting.DARK_GRAY + I18n.m_118938_((String)"tetra.not_available", (Object[])new Object[0]);
        if (this.includeSpeedModifier) {
            speedString = speedMultiplier < 1.0 ? ChatFormatting.RED.toString() : (speedMultiplier > 1.0 ? ChatFormatting.GREEN.toString() : ChatFormatting.YELLOW.toString());
            speedString = (String)speedString + String.format("%.2fx", speedMultiplier);
        }
        return I18n.m_118938_((String)this.localizationKey, (Object[])new Object[0]) + "\n \n" + I18n.m_118938_((String)"tetra.stats.tool.breakdown", (Object[])new Object[]{(int)this.levelGetter.getValue(player, itemStack), String.format("%.2f", this.totalEfficiencyGetter.getValue(player, itemStack)), String.format("%.2f", this.baseEfficiencyGetter.getValue(player, itemStack)), speedString, enchantmentBonus > 0.0 ? I18n.m_118938_((String)"tetra.stats.tool.enchantment_bonus", (Object[])new Object[]{String.format("%.0f", enchantmentBonus)}) : ""});
    }

    @Override
    public boolean hasExtendedTooltip(Player player, ItemStack itemStack) {
        return true;
    }

    @Override
    public String getTooltipExtension(Player player, ItemStack itemStack) {
        return I18n.m_118938_((String)"tetra.stats.tool.tooltip_extended", (Object[])new Object[0]);
    }
}

