/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.stats.getter;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.ItemModuleMajor;

@ParametersAreNonnullByDefault
public class StatGetterEnchantmentLevel
implements IStatGetter {
    private final Enchantment enchantment;
    private final String enchantmentKey;
    private final double multiplier;
    private final double base;

    public StatGetterEnchantmentLevel(Enchantment enchantment, double multiplier) {
        this(enchantment, multiplier, 0.0);
    }

    public StatGetterEnchantmentLevel(Enchantment enchantment, double multiplier, double base) {
        this.enchantment = enchantment;
        this.enchantmentKey = Registry.f_122825_.m_7981_((Object)enchantment).toString();
        this.multiplier = multiplier;
        this.base = base;
    }

    @Override
    public double getValue(Player player, ItemStack itemStack) {
        return CastOptional.cast((Object)itemStack.m_41720_(), IModularItem.class).map(item -> EnchantmentHelper.m_44843_((Enchantment)this.enchantment, (ItemStack)itemStack)).filter(level -> level > 0).map(level -> (double)level.intValue() * this.multiplier + this.base).orElse(0.0);
    }

    @Override
    public double getValue(Player player, ItemStack itemStack, String slot) {
        return CastOptional.cast((Object)itemStack.m_41720_(), IModularItem.class).flatMap(item -> CastOptional.cast((Object)item.getModuleFromSlot(itemStack, slot), ItemModuleMajor.class)).map(module -> module.getEnchantments(itemStack)).map(enchantments -> (Integer)enchantments.get(this.enchantment)).filter(level -> level > 0).map(level -> (double)level.intValue() * this.multiplier + this.base).orElse(0.0);
    }

    @Override
    public double getValue(Player player, ItemStack itemStack, String slot, String improvement) {
        if (improvement.startsWith("enchantment:") && this.enchantmentKey.equals(improvement.substring(12))) {
            return this.getValue(player, itemStack);
        }
        return 0.0;
    }
}

