/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import se.mickelus.mutil.gui.GuiAttachment;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiString;
import se.mickelus.mutil.gui.GuiStringSmall;
import se.mickelus.mutil.gui.animation.Applier;
import se.mickelus.mutil.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.Tooltips;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.stats.bar.GuiBar;
import se.mickelus.tetra.items.modular.IModularItem;

@ParametersAreNonnullByDefault
public class HoneProgressGui
extends GuiElement {
    protected GuiString labelString = new GuiStringSmall(0, 0, I18n.m_118938_((String)"item.tetra.modular.hone_progress.label", (Object[])new Object[0]));
    protected GuiString valueString;
    protected GuiBar bar;
    protected List<Component> tooltip;
    protected List<Component> extendedTooltip;

    public HoneProgressGui(int x, int y) {
        super(x, y, 45, 12);
        this.addChild((GuiElement)this.labelString);
        this.valueString = new GuiStringSmall(0, 0, "");
        this.valueString.setAttachment(GuiAttachment.topRight);
        this.addChild((GuiElement)this.valueString);
        this.bar = new GuiBar(0, 0, this.width, 0.0, 1.0);
        this.addChild(this.bar);
    }

    public void update(ItemStack itemStack, boolean isPlaceholder) {
        boolean shouldShow = !isPlaceholder && itemStack.m_41720_() instanceof IModularItem && (Boolean)ConfigHandler.moduleProgression.get() != false && ((IModularItem)itemStack.m_41720_()).canGainHoneProgress();
        this.setVisible(shouldShow);
        if (shouldShow) {
            IModularItem item = (IModularItem)itemStack.m_41720_();
            int limit = item.getHoningLimit(itemStack);
            int progress = limit - item.getHoningProgress(itemStack);
            float factor = Mth.m_14036_((float)(1.0f * (float)progress / (float)limit), (float)0.0f, (float)1.0f);
            float workableFactor = -item.getEffectLevel(itemStack, ItemEffect.workable);
            String factorString = String.format("%.0f%%", Float.valueOf(100.0f * factor));
            Object tooltipBase = I18n.m_118938_((String)"item.tetra.modular.hone_progress.description", (Object[])new Object[]{progress, limit, factorString, item.getHoneBase(), item.getHoningIntegrityPenalty(itemStack)});
            if (workableFactor < 0.0f) {
                tooltipBase = (String)tooltipBase + I18n.m_118938_((String)"item.tetra.modular.hone_progress.description_workable", (Object[])new Object[]{String.format("%.0f%%", Float.valueOf(workableFactor))});
            }
            this.tooltip = ImmutableList.of((Object)Component.m_237115_((String)tooltipBase), (Object)Component.m_237113_((String)""), (Object)Tooltips.expand);
            this.extendedTooltip = ImmutableList.of((Object)Component.m_237115_((String)tooltipBase), (Object)Component.m_237113_((String)""), (Object)Tooltips.expanded, (Object)Component.m_237113_((String)""), (Object)Component.m_237115_((String)"item.tetra.modular.hone_progress.description_extended").m_130940_(ChatFormatting.GRAY));
            this.valueString.setString(factorString);
            this.bar.setValue(factor, factor);
            if (factor < 1.0f) {
                this.labelString.setColor(0xFFFFFF);
                this.valueString.setColor(0xFFFFFF);
                this.bar.setColor(0xFFFFFF);
            } else {
                this.labelString.setColor(0xCECEFF);
                this.valueString.setColor(0xCECEFF);
                this.bar.setColor(0xCECEFF);
            }
        }
    }

    public void showAnimation() {
        if (this.isVisible()) {
            new KeyframeAnimation(100, (GuiElement)this).withDelay(600).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateX(-3.0f, 0.0f, true)}).start();
        }
    }

    public List<Component> getTooltipLines() {
        if (this.hasFocus()) {
            if (Screen.m_96638_()) {
                return this.extendedTooltip;
            }
            return this.tooltip;
        }
        return super.getTooltipLines();
    }
}

