/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.client.model;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.client.model.UnresolvedItemModel;
import se.mickelus.tetra.data.DataManager;

@ParametersAreNonnullByDefault
public class ModularModelLoader
implements IGeometryLoader<UnresolvedItemModel>,
ResourceManagerReloadListener {
    private static final Logger logger = LogManager.getLogger();
    private static List<UnresolvedItemModel> newModels = new LinkedList<UnresolvedItemModel>();
    private static List<UnresolvedItemModel> models = new LinkedList<UnresolvedItemModel>();

    public ModularModelLoader() {
        models.forEach(UnresolvedItemModel::clearCache);
    }

    public static void init() {
        DataManager.instance.moduleData.onReload(ModularModelLoader::clearCaches);
    }

    private static void shuffle() {
        if (!newModels.isEmpty()) {
            models = newModels;
            newModels = new LinkedList<UnresolvedItemModel>();
        }
    }

    public static void clearCaches() {
        logger.info("Clearing model cache for {} items, let's get bakin'", (Object)models.size());
        models.forEach(UnresolvedItemModel::clearCache);
        ModularModelLoader.shuffle();
    }

    public void m_6213_(ResourceManager resourceManager) {
        logger.info("Reloading item models, old: {}, new: {}", (Object)models.size(), (Object)newModels.size());
        ModularModelLoader.shuffle();
    }

    public UnresolvedItemModel read(JsonObject modelContents, JsonDeserializationContext deserializationContext) throws JsonParseException {
        ItemTransforms cameraTransforms = (ItemTransforms)deserializationContext.deserialize(modelContents.get("display"), ItemTransforms.class);
        if (modelContents.has("variants")) {
            Map transformVariants = (Map)deserializationContext.deserialize(modelContents.get("variants"), new TypeToken<Map<String, ItemTransforms>>(){}.getType());
            UnresolvedItemModel model = new UnresolvedItemModel(cameraTransforms, transformVariants);
            newModels.add(model);
            return model;
        }
        UnresolvedItemModel model = new UnresolvedItemModel(cameraTransforms);
        newModels.add(model);
        return model;
    }
}

