/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.action;

import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import se.mickelus.mutil.network.BlockPosPacket;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;

@ParametersAreNonnullByDefault
public class WorkbenchActionPacket
extends BlockPosPacket {
    private String actionKey;

    public WorkbenchActionPacket() {
    }

    public WorkbenchActionPacket(BlockPos pos, String actionKey) {
        super(pos);
        this.actionKey = actionKey;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        super.toBytes(buffer);
        try {
            WorkbenchActionPacket.writeString((String)this.actionKey, (FriendlyByteBuf)buffer);
        }
        catch (IOException exception) {
            System.err.println("An error occurred when writing action name to packet buffer");
        }
    }

    public void fromBytes(FriendlyByteBuf buffer) {
        super.fromBytes(buffer);
        try {
            this.actionKey = WorkbenchActionPacket.readString((FriendlyByteBuf)buffer);
        }
        catch (IOException exception) {
            System.err.println("An error occurred when reading action name from packet buffer");
        }
    }

    public void handle(Player player) {
        WorkbenchTile workbench = (WorkbenchTile)player.f_19853_.m_7702_(this.pos);
        if (workbench != null) {
            workbench.performAction(player, this.actionKey);
        }
    }
}

