/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.scroll;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import se.mickelus.mutil.util.TileEntityOptional;
import se.mickelus.tetra.blocks.ICraftingEffectProviderBlock;
import se.mickelus.tetra.blocks.ISchematicProviderBlock;
import se.mickelus.tetra.blocks.TetraBlock;
import se.mickelus.tetra.blocks.scroll.ScrollItem;
import se.mickelus.tetra.blocks.scroll.ScrollTile;
import se.mickelus.tetra.blocks.workbench.AbstractWorkbenchBlock;

@ParametersAreNonnullByDefault
public class ScrollBlock
extends TetraBlock
implements EntityBlock,
ISchematicProviderBlock,
ICraftingEffectProviderBlock {
    public static final Material material = new Material.Builder(MaterialColor.f_76401_).m_76353_().m_76359_();
    public static final SoundType sound = new SoundType(0.8f, 1.3f, SoundEvents.f_11713_, SoundEvents.f_11713_, SoundEvents.f_11713_, SoundEvents.f_11713_, SoundEvents.f_11713_);
    private final Arrangement arrangement;

    public ScrollBlock(String registryName, Arrangement arrangement) {
        super(BlockBehaviour.Properties.m_60939_((Material)material).m_60918_(sound));
        this.arrangement = arrangement;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST));
    }

    public Arrangement getArrangement() {
        return this.arrangement;
    }

    @Override
    public boolean canUnlockSchematics(Level world, BlockPos pos, BlockPos targetPos) {
        boolean isIntricate = TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, ScrollTile.class).map(ScrollTile::isIntricate).orElse(false);
        return !isIntricate || targetPos.m_7494_().equals((Object)pos);
    }

    @Override
    public ResourceLocation[] getSchematics(Level world, BlockPos pos, BlockState blockState) {
        return TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, ScrollTile.class).map(ScrollTile::getSchematics).orElseGet(() -> new ResourceLocation[0]);
    }

    @Override
    public boolean canUnlockCraftingEffects(Level world, BlockPos pos, BlockPos targetPos) {
        boolean isIntricate = TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, ScrollTile.class).map(ScrollTile::isIntricate).orElse(false);
        return !isIntricate || targetPos.m_7494_().equals((Object)pos);
    }

    @Override
    public ResourceLocation[] getCraftingEffects(Level world, BlockPos pos, BlockState blockState) {
        return TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, ScrollTile.class).map(ScrollTile::getCraftingEffects).orElseGet(() -> new ResourceLocation[0]);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockState offsetState;
        if (this.arrangement == Arrangement.open && (offsetState = world.m_8055_(pos.m_7495_())).m_60734_() instanceof AbstractWorkbenchBlock) {
            return offsetState.m_60664_(world, player, hand, new BlockHitResult(Vec3.f_82478_, Direction.UP, pos.m_7495_(), true));
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction facing = Direction.UP;
        if (this.getArrangement() == Arrangement.wall) {
            facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        }
        BlockPos offsetPos = pos.m_121945_(facing.m_122424_());
        BlockState offsetState = world.m_8055_(offsetPos);
        if (this.getArrangement() == Arrangement.open) {
            return offsetState.m_60734_() instanceof AbstractWorkbenchBlock;
        }
        return offsetState.m_60783_((BlockGetter)world, offsetPos, facing);
    }

    public BlockState m_7417_(BlockState blockState, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (!blockState.m_60710_((LevelReader)world, currentPos)) {
            if (!world.m_5776_() && world.m_6106_().m_5470_().m_46207_(GameRules.f_46136_) && world instanceof Level) {
                this.dropScrolls((Level)world, currentPos);
            }
            return Blocks.f_50016_.m_49966_();
        }
        return blockState;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(world, pos, state, player);
        if (!world.f_46443_ && !player.m_7500_() && world.m_46469_().m_46207_(GameRules.f_46136_)) {
            this.dropScrolls(world, pos);
        }
    }

    public void dropScrolls(Level world, BlockPos pos) {
        TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, ScrollTile.class).ifPresent(tile -> {
            for (CompoundTag nbt : tile.getItemTags()) {
                ItemStack itemStack = new ItemStack((ItemLike)ScrollItem.instance);
                itemStack.m_41700_("BlockEntityTag", (Tag)nbt);
                ItemEntity entity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemStack);
                entity.m_32060_();
                world.m_7967_((Entity)entity);
            }
        });
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new ScrollTile(blockPos, blockState);
    }

    public static enum Arrangement {
        wall,
        open,
        rolled;

    }
}

