/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.multischematic;

import com.mojang.math.Vector3f;
import java.util.Collection;
import java.util.stream.Stream;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;
import se.mickelus.mutil.util.RotationHelper;
import se.mickelus.tetra.ServerScheduler;
import se.mickelus.tetra.TetraToolActions;
import se.mickelus.tetra.blocks.multischematic.MultiblockSchematicScrollHandler;
import se.mickelus.tetra.blocks.multischematic.PrimaryMultiblockSchematicBlock;
import se.mickelus.tetra.blocks.multischematic.RuinedMultiblockSchematicBlock;
import se.mickelus.tetra.blocks.multischematic.RuinedMultiblockSchematicItem;
import se.mickelus.tetra.blocks.multischematic.StackedMultiblockSchematicItem;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IInteractiveBlock;
import se.mickelus.tetra.effect.EffectHelper;

public class MultiblockSchematicBlock
extends HorizontalDirectionalBlock
implements IInteractiveBlock {
    public static final DirectionProperty facingProp = BlockStateProperties.f_61374_;
    public final int x;
    public final int y;
    public final int height;
    public final int width;
    public final RegistryObject<RuinedMultiblockSchematicBlock> ruinedRef;
    protected String schematic;
    protected ResourceLocation pryTable;
    protected BlockInteraction[] pryAction = new BlockInteraction[]{new BlockInteraction(TetraToolActions.pry, 1, Direction.EAST, 6.0f, 10.0f, 7.0f, 10.0f, BlockStatePredicate.f_61281_, this::pryBlock)};

    public MultiblockSchematicBlock(BlockBehaviour.Properties properties, String schematic, RegistryObject<RuinedMultiblockSchematicBlock> ruinedRef, @Nullable ResourceLocation pryTable, int x, int y, int height, int width) {
        super(properties);
        this.schematic = schematic;
        this.ruinedRef = ruinedRef;
        this.pryTable = pryTable;
        this.x = x;
        this.y = y;
        this.height = height;
        this.width = width;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)facingProp, (Comparable)Direction.EAST));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{facingProp});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)facingProp, (Comparable)context.m_8125_().m_122424_());
    }

    protected Stream<Part> getSchematicParts(BlockState blockState, LevelAccessor level, BlockPos blockPos) {
        Direction dir = (Direction)blockState.m_61143_((Property)facingProp);
        AABB baseBox = new AABB(0.0, 0.0, 0.0, (double)(this.width - 1), (double)(this.height - 1), 0.0);
        return BlockPos.m_121921_((AABB)baseBox).map(pos -> {
            BlockPos worldPos = RotationHelper.rotateDirection((BlockPos)pos.m_7918_(-this.x, -this.y, 0), (Direction)dir).m_121955_((Vec3i)blockPos);
            return new Part(pos.m_7949_(), worldPos, level.m_8055_(worldPos));
        });
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState oldBlock, boolean p_60570_) {
        super.m_6807_(blockState, level, blockPos, oldBlock, p_60570_);
        this.notifyPrimary((LevelAccessor)level, blockPos, blockState);
    }

    public void m_6786_(LevelAccessor level, BlockPos blockPos, BlockState blockState) {
        super.m_6786_(level, blockPos, blockState);
        if (!level.m_5776_()) {
            this.notifyPrimary(level, blockPos, blockState);
        }
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity entity, ItemStack itemStack) {
        super.m_6402_(level, blockPos, blockState, entity, itemStack);
        if (level.m_5776_()) {
            this.spawnParticles(blockState, (ClientLevel)level, blockPos);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.pryTable != null) {
            return BlockInteraction.attemptInteraction(world, state, pos, player, hand, hit);
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    @Override
    public BlockInteraction[] getPotentialInteractions(Level world, BlockPos pos, BlockState blockState, Direction face, Collection<ToolAction> tools) {
        if (this.pryTable != null && face.m_122424_().equals((Object)blockState.m_61143_((Property)facingProp))) {
            return this.pryAction;
        }
        return new BlockInteraction[0];
    }

    protected boolean pryBlock(Level world, BlockPos pos, BlockState blockState, Player player, InteractionHand hand, Direction facing) {
        boolean didBreak = EffectHelper.breakBlock(world, player, player.m_21120_(hand), pos, blockState, false);
        if (didBreak && world instanceof ServerLevel) {
            BlockInteraction.getLoot(this.pryTable, player, hand, (ServerLevel)world, blockState).forEach(lootStack -> MultiblockSchematicBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)lootStack));
        }
        return true;
    }

    protected void notifyPrimary(LevelAccessor level, BlockPos blockPos, BlockState blockState) {
        this.getSchematicParts(blockState, level, blockPos).filter(part -> part.blockState.m_60734_() instanceof PrimaryMultiblockSchematicBlock).forEach(part -> ((PrimaryMultiblockSchematicBlock)part.blockState.m_60734_()).updateComplete(part.blockState(), level, part.worldPos(), blockPos));
    }

    protected void spawnParticles(BlockState blockState, ClientLevel level, BlockPos blockPos) {
        Vec3 face = Vec3.m_82528_((Vec3i)((Direction)blockState.m_61143_((Property)facingProp)).m_122436_());
        Vec3 dir = Vec3.m_82528_((Vec3i)((Direction)blockState.m_61143_((Property)facingProp)).m_122427_().m_122436_());
        this.getSchematicParts(blockState, (LevelAccessor)level, blockPos).forEach(part -> ServerScheduler.schedule(blockPos.m_123333_((Vec3i)part.worldPos) * 2, () -> this.spawnParticleBlock(level, blockState, part.basePos(), part.blockState(), part.worldPos(), face, dir)));
    }

    /*
     * Unable to fully structure code
     */
    protected void spawnParticleBlock(ClientLevel level, BlockState originState, BlockPos basePos, BlockState blockState, BlockPos pos, Vec3 face, Vec3 dir) {
        facePos = Vec3.m_82512_((Vec3i)pos).m_82549_(face.m_82490_(0.52));
        var11_9 = blockState.m_60734_();
        if (!(var11_9 instanceof MultiblockSchematicBlock)) ** GOTO lbl-1000
        block = (MultiblockSchematicBlock)var11_9;
        if (block.x == basePos.m_123341_() && block.y == basePos.m_123342_()) {
            particle = new DustParticleOptions(new Vector3f(0.1f, 0.9f, 0.5f), 1.0f);
        } else lbl-1000:
        // 2 sources

        {
            particle = new DustParticleOptions(new Vector3f(0.9f, 0.3f, 0.3f), 1.0f);
        }
        this.spawnParticle(level, particle, facePos);
    }

    protected void spawnParticle(ClientLevel level, DustParticleOptions particle, Vec3 pos) {
        level.m_7106_((ParticleOptions)particle, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
    }

    record Part(BlockPos basePos, BlockPos worldPos, BlockState blockState) {
    }

    public static class Builder {
        public static final String format = "%s_%d_%d";
        public static final String ruinedFormat = "%s_ruined_%d_%d";
        public static final String pryTablePrefix = "actions/forged_schematic/";
        private String identifier;
        private int height;
        private int width;
        private BlockBehaviour.Properties properties;
        private BlockBehaviour.Properties ruinedProperties;

        public Builder(String identifier, int width, int height, BlockBehaviour.Properties properties) {
            this.identifier = identifier;
            this.width = width;
            this.height = height;
            this.properties = properties;
            this.ruinedProperties = properties;
        }

        public Builder withRuinedProperties(BlockBehaviour.Properties properties) {
            this.ruinedProperties = properties;
            return this;
        }

        public void build(DeferredRegister<Block> blocks, DeferredRegister<Item> items) {
            if (FMLEnvironment.dist.isClient()) {
                MultiblockSchematicScrollHandler.setupSchematic(this.identifier, this.width * this.height);
            }
            for (int i = 0; i < this.width; ++i) {
                for (int j = 0; j < this.height; ++j) {
                    int x = i;
                    int y = j;
                    String ruinedId = String.format(ruinedFormat, this.identifier, x, y);
                    ResourceLocation brokenPryTable = new ResourceLocation("tetra", pryTablePrefix + ruinedId);
                    RegistryObject ruinedRef = blocks.register(ruinedId, () -> new RuinedMultiblockSchematicBlock(this.ruinedProperties, brokenPryTable));
                    String id = String.format(format, this.identifier, x, y);
                    ResourceLocation pryTable = new ResourceLocation("tetra", pryTablePrefix + id);
                    RegistryObject ref = x == this.width / 2 && y == this.height / 2 ? blocks.register(id, () -> new PrimaryMultiblockSchematicBlock(this.properties, this.identifier, (RegistryObject<RuinedMultiblockSchematicBlock>)ruinedRef, pryTable, x, y, this.height, this.width)) : blocks.register(id, () -> new MultiblockSchematicBlock(this.properties, this.identifier, (RegistryObject<RuinedMultiblockSchematicBlock>)ruinedRef, pryTable, x, y, this.height, this.width));
                    items.register(id, () -> {
                        StackedMultiblockSchematicItem item = new StackedMultiblockSchematicItem((MultiblockSchematicBlock)ref.get(), (Block)ruinedRef.get());
                        if (FMLEnvironment.dist.isClient()) {
                            MultiblockSchematicScrollHandler.addSchematic(this.identifier, y * this.width + x, item);
                        }
                        return item;
                    });
                    items.register(ruinedId, () -> new RuinedMultiblockSchematicItem((Block)ruinedRef.get(), (MultiblockSchematicBlock)ref.get()));
                }
            }
        }
    }
}

