/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.holo;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.RegistryObject;
import se.mickelus.tetra.ServerScheduler;
import se.mickelus.tetra.TetraSounds;
import se.mickelus.tetra.blocks.holo.ScanHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.impl.holo.ModularHolosphereItem;

public class HolosphereBlockEntity
extends BlockEntity {
    public static final int maxRange = 8;
    public static RegistryObject<BlockEntityType<HolosphereBlockEntity>> type;
    private List<ScanResult> scanResults;
    private long scanModeTimestamp = 0L;
    private CompoundTag itemTag;
    private LazyOptional<Boolean> canScan = LazyOptional.of(() -> this.itemTag).lazyMap(tag -> {
        ItemStack itemStack = new ItemStack((ItemLike)ModularHolosphereItem.instance);
        itemStack.m_41751_(tag);
        return Optional.ofNullable(ModularHolosphereItem.instance.getEffectData(itemStack)).map(effects -> effects.getLevel(ItemEffect.percussionScanner) > 0).orElse(false);
    });

    public HolosphereBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)type.get(), pos, blockState);
        this.scanResults = new ArrayList<ScanResult>();
    }

    public AABB getRenderBoundingBox() {
        return Shapes.m_83144_().m_83215_().m_82377_(1.0, 0.5, 1.0).m_82338_(this.f_58858_);
    }

    public List<ScanResult> getScanResults() {
        return this.scanResults;
    }

    public boolean canScan() {
        return (Boolean)this.canScan.orElse((Object)false);
    }

    public long getScanModeTimestamp() {
        return this.scanModeTimestamp;
    }

    public boolean inScanMode() {
        return this.scanModeTimestamp > 0L;
    }

    public void toggleScanMode(boolean enable) {
        long diff = Math.abs(Math.abs(this.scanModeTimestamp) - this.f_58857_.m_46467_());
        long time = diff < 5L ? this.f_58857_.m_46467_() - diff : this.f_58857_.m_46467_();
        this.scanModeTimestamp = enable ? time : -time;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    private String[] getScannableStructures() {
        return new String[]{"#tetra:forged_ruins"};
    }

    private long getTimestamp(long gametime, int x, int y) {
        return (long)((double)gametime + Mth.m_184645_((double)x, (double)y) * 1.5 + Math.random() * 5.0);
    }

    public void use(int hammerLevel, float hammerEfficiency, float angle) {
        ServerLevel serverLevel = (ServerLevel)this.m_58904_();
        int count = 4 + (int)hammerEfficiency / 4;
        double cone = (double)(20 + hammerLevel * 6) * Math.PI / 180.0;
        int ox = SectionPos.m_123171_((int)this.m_58899_().m_123341_());
        int oz = SectionPos.m_123171_((int)this.m_58899_().m_123343_());
        int preResultSize = this.scanResults.size();
        AtomicInteger stagger = new AtomicInteger();
        ChunkPos.m_45599_((ChunkPos)new ChunkPos(-32, -32), (ChunkPos)new ChunkPos(32, 32)).filter(pos -> Math.abs(Mth.m_14136_((double)pos.f_45578_, (double)pos.f_45579_) - (double)angle) < cone).sorted(Comparator.comparingInt(pos -> pos.f_45578_ * pos.f_45578_ + pos.f_45579_ * pos.f_45579_)).map(pos -> new ChunkPos(pos.f_45578_ + ox, pos.f_45579_ + oz)).filter(pos -> Math.abs(pos.f_45578_ - ox) + Math.abs(pos.f_45579_ - oz) < 20).filter(pos -> this.scanResults.stream().noneMatch(result -> result.chunkX == pos.f_45578_ && result.chunkZ == pos.f_45579_)).limit(count).forEach(pos -> {
            long timestamp = this.getTimestamp(serverLevel.m_46467_(), pos.f_45578_ - ox, pos.f_45579_ - oz) + (long)stagger.getAndIncrement() * 3L;
            int height = serverLevel.m_46819_(pos.f_45578_, pos.f_45579_, ChunkStatus.f_62325_).m_5885_(Heightmap.Types.WORLD_SURFACE_WG, pos.f_45578_, pos.f_45579_);
            BlockPos centerPos = pos.m_151394_(height);
            float temperature = ((Biome)this.f_58857_.m_204166_(centerPos).m_203334_()).m_47505_(centerPos);
            List<String> structures = Arrays.stream(this.getScannableStructures()).filter(id -> ScanHelper.hasStructure(id, serverLevel, pos)).toList();
            this.scanResults.add(new ScanResult(pos.f_45578_, pos.f_45579_, height, temperature, structures, timestamp));
            ServerScheduler.schedule((int)(timestamp - serverLevel.m_46467_()), () -> serverLevel.m_5594_(null, this.m_58899_(), TetraSounds.scanMiss, SoundSource.PLAYERS, 0.01f, 1.0f + (float)Math.random() * 0.0f));
            if (!structures.isEmpty()) {
                ServerScheduler.schedule((int)(timestamp - serverLevel.m_46467_() + 20L), () -> serverLevel.m_5594_(null, this.m_58899_(), TetraSounds.scanHit, SoundSource.PLAYERS, 0.1f, 1.0f));
            }
        });
        if (preResultSize != this.scanResults.size()) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public ItemStack getItemStack() {
        ItemStack itemStack = new ItemStack((ItemLike)ModularHolosphereItem.instance);
        itemStack.m_41751_(this.getItemTag());
        return itemStack;
    }

    public CompoundTag getItemTag() {
        return this.itemTag;
    }

    public void setItemTag(CompoundTag tag) {
        this.itemTag = tag;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.itemTag = compound.m_128469_("item");
        this.scanModeTimestamp = compound.m_128454_("timestamp");
        this.scanResults = compound.m_128437_("scan", 10).stream().map(nbt -> ScanResult.codec.decode((DynamicOps)NbtOps.f_128958_, nbt)).map(DataResult::result).filter(Optional::isPresent).map(Optional::get).map(Pair::getFirst).collect(Collectors.toCollection(ArrayList::new));
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("item", (Tag)this.itemTag);
        compound.m_128356_("timestamp", this.scanModeTimestamp);
        ListTag list = this.scanResults.stream().map(scroll -> ScanResult.codec.encodeStart((DynamicOps)NbtOps.f_128958_, scroll)).map(DataResult::result).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toCollection(ListTag::new));
        compound.m_128365_("scan", (Tag)list);
    }

    record ScanResult(int chunkX, int chunkZ, int height, float temperature, List<String> structures, long timestamp) {
        static final Codec<ScanResult> codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("chunkX").forGetter(i -> i.chunkX), (App)Codec.INT.fieldOf("chunkZ").forGetter(i -> i.chunkZ), (App)Codec.INT.fieldOf("height").forGetter(i -> i.height), (App)Codec.FLOAT.fieldOf("temperature").forGetter(i -> Float.valueOf(i.temperature)), (App)Codec.STRING.listOf().fieldOf("structures").forGetter(i -> i.structures), (App)Codec.LONG.fieldOf("timestamp").forGetter(i -> i.timestamp)).apply((Applicative)instance, ScanResult::new));
    }
}

