/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.hammer;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.mutil.util.TileEntityOptional;
import se.mickelus.tetra.TetraRegistries;
import se.mickelus.tetra.TetraToolActions;
import se.mickelus.tetra.advancements.BlockUseCriterion;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseBlock;
import se.mickelus.tetra.blocks.forged.hammer.HammerEffect;
import se.mickelus.tetra.blocks.forged.hammer.HammerHeadBlockEntity;
import se.mickelus.tetra.blocks.salvage.IInteractiveBlock;
import se.mickelus.tetra.blocks.workbench.AbstractWorkbenchBlock;
import se.mickelus.tetra.items.cell.ThermalCellItem;
import se.mickelus.tetra.util.TierHelper;

@ParametersAreNonnullByDefault
public class HammerBaseBlockEntity
extends BlockEntity {
    private static final String moduleAKey = "modA";
    private static final String moduleBKey = "modB";
    private static final String slotsKey = "slots";
    private static final String indexKey = "slot";
    private static final String redstoneKey = "rs";
    public static RegistryObject<BlockEntityType<HammerBaseBlockEntity>> type;
    private HammerEffect moduleA;
    private HammerEffect moduleB;
    private ItemStack[] slots = new ItemStack[2];
    private int redstonePower = 0;

    public HammerBaseBlockEntity(BlockPos p_155268_, BlockState p_155269_) {
        super((BlockEntityType)type.get(), p_155268_, p_155269_);
    }

    public static void writeModules(CompoundTag compound, HammerEffect moduleA, HammerEffect moduleB) {
        if (moduleA != null) {
            compound.m_128365_(moduleAKey, (Tag)ByteTag.m_128266_((byte)((byte)moduleA.ordinal())));
        }
        if (moduleB != null) {
            compound.m_128365_(moduleBKey, (Tag)ByteTag.m_128266_((byte)((byte)moduleB.ordinal())));
        }
    }

    public static void writeCells(CompoundTag compound, ItemStack ... cells) {
        ListTag nbttaglist = new ListTag();
        for (int i = 0; i < cells.length; ++i) {
            if (cells[i] == null) continue;
            CompoundTag nbttagcompound = new CompoundTag();
            nbttagcompound.m_128344_(indexKey, (byte)i);
            cells[i].m_41739_(nbttagcompound);
            nbttaglist.add((Object)nbttagcompound);
        }
        compound.m_128365_(slotsKey, (Tag)nbttaglist);
    }

    public boolean setModule(boolean isA, Item item) {
        HammerEffect newModule = HammerEffect.fromItem(item);
        if (newModule != null) {
            if (isA) {
                if (this.moduleA == null) {
                    this.moduleA = newModule;
                    this.sync();
                    return true;
                }
            } else if (this.moduleB == null) {
                this.moduleB = newModule;
                this.sync();
                return true;
            }
        }
        return false;
    }

    public Item removeModule(boolean isA) {
        if (isA) {
            if (this.moduleA != null) {
                Item item = this.moduleA.getItem();
                this.moduleA = null;
                this.sync();
                return item;
            }
        } else if (this.moduleB != null) {
            Item item = this.moduleB.getItem();
            this.moduleB = null;
            this.sync();
            return item;
        }
        return null;
    }

    public boolean hasEffect(HammerEffect effect) {
        return effect == this.moduleA || effect == this.moduleB;
    }

    public HammerEffect getEffect(boolean isA) {
        return isA ? this.moduleA : this.moduleB;
    }

    public int getEffectLevel(HammerEffect effect) {
        int level = 0;
        if (effect == this.moduleA) {
            ++level;
        }
        if (effect == this.moduleB) {
            ++level;
        }
        return level;
    }

    public int getHammerLevel() {
        switch (this.getEffectLevel(HammerEffect.power)) {
            case 2: {
                return TierHelper.getIndex(TetraRegistries.forgeHammerTier) + 1;
            }
            case 1: {
                return TierHelper.getIndex((Tier)Tiers.NETHERITE) + 1;
            }
        }
        return TierHelper.getIndex((Tier)Tiers.DIAMOND) + 1;
    }

    public boolean isFunctional() {
        return this.isFueled() && this.getEffect(true) != null && this.getEffect(false) != null;
    }

    public boolean isFueled() {
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.getCellFuel(i) > 0) continue;
            return false;
        }
        return true;
    }

    public void consumeFuel() {
        if (!this.f_58857_.f_46443_) {
            int fuelUsage = this.fuelUsage();
            for (int i = 0; i < this.slots.length; ++i) {
                this.consumeFuel(i, fuelUsage);
            }
            this.applyConsumeEffect();
            this.sync();
        }
    }

    public void consumeFuel(int index, int amount) {
        if (index >= 0 && index < this.slots.length && this.slots[index] != null && this.slots[index].m_41720_() instanceof ThermalCellItem) {
            ThermalCellItem item = (ThermalCellItem)this.slots[index].m_41720_();
            ThermalCellItem.drainCharge(this.slots[index], amount);
        }
    }

    public float getJamChance() {
        return 0.3f - 0.15f * (float)this.getEffectLevel(HammerEffect.reliable);
    }

    public void updateRedstonePower() {
        if (this.f_58857_ != null) {
            int updatedPower = 0;
            for (Direction direction : Direction.values()) {
                updatedPower += this.f_58857_.m_46681_(this.f_58858_.m_121945_(direction), direction);
            }
            if (updatedPower != this.redstonePower) {
                this.redstonePower = updatedPower;
                this.sync();
            }
        }
    }

    private int tickrate() {
        return this.redstonePower != 0 ? (int)Math.max(600.0f / (float)this.redstonePower, 10.0f) : 20;
    }

    private void applyConsumeEffect() {
        Direction facing = (Direction)this.m_58904_().m_8055_(this.m_58899_()).m_61143_((Property)HammerBaseBlock.facingProp);
        Vec3 pos = Vec3.m_82512_((Vec3i)this.m_58899_());
        Vec3 oppositePos = pos.m_82549_(Vec3.m_82528_((Vec3i)facing.m_122424_().m_122436_()).m_82490_(0.55));
        pos = pos.m_82549_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(0.55));
        if (this.hasEffect(HammerEffect.power)) {
            this.spawnParticle((ParticleOptions)ParticleTypes.f_123808_, Vec3.m_82528_((Vec3i)this.m_58899_()).m_82520_(0.5, -0.9, 0.5), 15, 0.1f);
        }
        if (this.hasEffect(HammerEffect.power)) {
            this.spawnParticle((ParticleOptions)ParticleTypes.f_123790_, Vec3.m_82528_((Vec3i)this.m_58899_()).m_82520_(0.5, -0.9, 0.5), 15, 0.1f);
            int count = this.f_58857_.f_46441_.m_188503_(2 + this.getEffectLevel(HammerEffect.power) * 4);
            if (count > 2) {
                this.spawnParticle((ParticleOptions)ParticleTypes.f_123756_, pos, 2, 0.06f);
                this.spawnParticle((ParticleOptions)ParticleTypes.f_123755_, pos, 2, 0.0f);
                this.spawnParticle((ParticleOptions)ParticleTypes.f_123756_, oppositePos, 2, 0.06f);
                this.spawnParticle((ParticleOptions)ParticleTypes.f_123755_, oppositePos, 2, 0.0f);
                LinkedList<BlockPos> flammableBlocks = new LinkedList<BlockPos>();
                for (int x = -3; x < 3; ++x) {
                    for (int y = -3; y < 2; ++y) {
                        for (int z = -3; z < 3; ++z) {
                            BlockPos firePos = this.m_58899_().m_7918_(x, y, z);
                            if (!this.f_58857_.m_46859_(firePos)) continue;
                            flammableBlocks.add(firePos);
                        }
                    }
                }
                Collections.shuffle(flammableBlocks);
                flammableBlocks.stream().limit(count).forEach(blockPos -> this.f_58857_.m_7731_(blockPos, Blocks.f_50083_.m_49966_(), 11));
            }
        }
        if (this.f_58857_.f_46441_.m_188501_() < this.getJamChance()) {
            TileEntityOptional.from((BlockGetter)this.f_58857_, (BlockPos)this.m_58899_().m_7495_(), HammerHeadBlockEntity.class).ifPresent(head -> {
                head.setJammed(true);
                this.f_58857_.m_45976_(ServerPlayer.class, new AABB(this.m_58899_()).m_82377_(10.0, 5.0, 10.0)).forEach(player -> BlockUseCriterion.trigger(player, head.m_58900_(), ItemStack.f_41583_, (Map<String, String>)ImmutableMap.builder().put((Object)"jammed", (Object)"true").build()));
            });
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11998_, SoundSource.BLOCKS, 0.8f, 0.5f);
        }
    }

    private int fuelUsage() {
        int usage = 5;
        usage += this.getEffectLevel(HammerEffect.power) * 4;
        usage = (int)((double)usage * (1.0 - (double)this.getEffectLevel(HammerEffect.efficient) * 0.4));
        return Math.max(usage, 1);
    }

    public boolean hasCellInSlot(int index) {
        return index >= 0 && index < this.slots.length && this.slots[index] != null;
    }

    public int getCellFuel(int index) {
        if (index >= 0 && index < this.slots.length && this.slots[index] != null && this.slots[index].m_41720_() instanceof ThermalCellItem) {
            ThermalCellItem item = (ThermalCellItem)this.slots[index].m_41720_();
            return ThermalCellItem.getCharge(this.slots[index]);
        }
        return -1;
    }

    public ItemStack removeCellFromSlot(int index) {
        if (index >= 0 && index < this.slots.length && this.slots[index] != null) {
            ItemStack itemStack = this.slots[index];
            this.slots[index] = null;
            this.sync();
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getStackInSlot(int index) {
        if (index >= 0 && index < this.slots.length && this.slots[index] != null) {
            return this.slots[index];
        }
        return ItemStack.f_41583_;
    }

    public boolean putCellInSlot(ItemStack itemStack, int index) {
        if (itemStack.m_41720_() instanceof ThermalCellItem && index >= 0 && index < this.slots.length && this.slots[index] == null) {
            this.slots[index] = itemStack;
            this.sync();
            return true;
        }
        return false;
    }

    private void spawnParticle(ParticleOptions particle, Vec3 pos, int count, float speed) {
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_8767_(particle, pos.f_82479_, pos.f_82480_, pos.f_82481_, count, 0.0, 0.0, 0.0, (double)speed);
        }
    }

    public Direction getFacing() {
        return (Direction)this.m_58900_().m_61143_((Property)HammerBaseBlock.facingProp);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public void m_142466_(CompoundTag compound) {
        byte data;
        byte data2;
        super.m_142466_(compound);
        this.slots = new ItemStack[2];
        if (compound.m_128441_(slotsKey)) {
            ListTag tagList = compound.m_128437_(slotsKey, 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag itemCompound = tagList.m_128728_(i);
                int slot = itemCompound.m_128445_(indexKey) & 0xFF;
                if (slot >= this.slots.length) continue;
                this.slots[slot] = ItemStack.m_41712_((CompoundTag)itemCompound);
            }
        }
        this.moduleA = null;
        if (compound.m_128441_(moduleAKey) && (data2 = compound.m_128445_(moduleAKey)) < HammerEffect.values().length) {
            this.moduleA = HammerEffect.values()[data2];
        }
        this.moduleB = null;
        if (compound.m_128441_(moduleBKey) && (data = compound.m_128445_(moduleBKey)) < HammerEffect.values().length) {
            this.moduleB = HammerEffect.values()[data];
        }
        this.redstonePower = compound.m_128451_(redstoneKey);
    }

    private void sync() {
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.m_6596_();
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        HammerBaseBlockEntity.writeCells(compound, this.slots);
        HammerBaseBlockEntity.writeModules(compound, this.moduleA, this.moduleB);
        compound.m_128405_(redstoneKey, this.redstonePower);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (this.redstonePower > 0 && level.m_46467_() % (long)this.tickrate() == 0L && level.m_46753_(pos) && this.isFunctional()) {
            BlockPos targetPos = pos.m_6625_(2);
            BlockState targetState = level.m_8055_(targetPos);
            HammerHeadBlockEntity head = TileEntityOptional.from((BlockGetter)level, (BlockPos)pos.m_7495_(), HammerHeadBlockEntity.class).orElse(null);
            if (head == null || head.isJammed()) {
                return;
            }
            CastOptional.cast((Object)targetState.m_60734_(), IInteractiveBlock.class).map(block -> block.getPotentialInteractions(level, targetPos, targetState, Direction.UP, Collections.singletonList(TetraToolActions.hammer))).stream().flatMap(Arrays::stream).filter(interaction -> TetraToolActions.hammer.equals(interaction.requiredTool)).filter(interaction -> this.getHammerLevel() >= interaction.requiredLevel).findFirst().ifPresent(interaction -> {
                interaction.applyOutcome(level, targetPos, targetState, null, null, Direction.UP);
                if (!(targetState.m_60734_() instanceof AbstractWorkbenchBlock)) {
                    if (!level.f_46443_) {
                        this.consumeFuel();
                    } else {
                        head.activate();
                        level.m_5594_(null, pos, SoundEvents.f_11668_, SoundSource.BLOCKS, 0.2f, (float)(0.5 + Math.random() * 0.2));
                    }
                } else {
                    head.activate();
                }
            });
        }
    }
}

