/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.misc.globe.GlobeData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.Level;

public class GlobeManager {
    private static final Map<String, TextureInstance> TEXTURE_CACHE = Maps.newHashMap();
    private static final HashMap<ResourceLocation, List<Integer>> DIMENSION_COLOR_MAP = new HashMap();
    private static final List<Integer> SEPIA_COLORS = new ArrayList<Integer>();

    public static void refreshTextures() {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            GlobeManager.getTextureInstance((Level)world, false).updateTexture((Level)world);
        }
    }

    public static RenderType getRenderType(Level world, boolean sepia) {
        return GlobeManager.getTextureInstance((Level)world, (boolean)sepia).renderType;
    }

    private static TextureInstance getTextureInstance(Level world, boolean sepia) {
        return TEXTURE_CACHE.computeIfAbsent(GlobeManager.getTextureId(world, sepia), i -> new TextureInstance(world, sepia));
    }

    private static String getTextureId(Level level, boolean sepia) {
        Object id = level.m_46472_().m_135782_().m_135815_();
        if (sepia) {
            id = (String)id + "_sepia";
        }
        return id;
    }

    public static void refreshColorsAndTextures(ResourceManager manager) {
        DIMENSION_COLOR_MAP.clear();
        int targetColors = 13;
        for (ResourceLocation res : manager.m_214159_("textures/entity/globes/palettes", r -> r.m_135815_().endsWith(".png")).keySet()) {
            List l = SpriteUtils.parsePaletteStrip((ResourceManager)manager, (ResourceLocation)res, (int)targetColors);
            String name = res.m_135815_();
            if ((name = name.substring(name.lastIndexOf("/") + 1).replace(".png", "")).equals("sepia")) {
                SEPIA_COLORS.clear();
                SEPIA_COLORS.addAll(l);
                continue;
            }
            DIMENSION_COLOR_MAP.put(new ResourceLocation(name.replace(".", ":")), l);
        }
        if (DIMENSION_COLOR_MAP.isEmpty()) {
            Supplementaries.LOGGER.error("Could not find any globe palette in textures/entity/globes/palettes");
        }
        GlobeManager.refreshTextures();
    }

    private static class TextureInstance
    implements AutoCloseable {
        private final ResourceLocation textureLocation;
        private final DynamicTexture texture;
        private final RenderType renderType;
        private final ResourceLocation dimensionId;
        private final boolean sepia;

        private TextureInstance(Level world, boolean sepia) {
            this.sepia = sepia;
            this.dimensionId = world.m_46472_().m_135782_();
            this.texture = new DynamicTexture(32, 16, false);
            this.updateTexture(world);
            this.textureLocation = Minecraft.m_91087_().m_91097_().m_118490_("globe/" + this.dimensionId.toString().replace(":", "_"), this.texture);
            this.renderType = RenderType.m_110446_((ResourceLocation)this.textureLocation);
        }

        private void updateTexture(Level world) {
            GlobeData data = GlobeData.get(world);
            if (data == null) {
                return;
            }
            byte[][] pixels = data.globePixels;
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 32; ++j) {
                    this.texture.m_117991_().m_84988_(j, i, -13061505);
                }
            }
            for (int y = 0; y < pixels.length; ++y) {
                for (int x = 0; x < pixels[y].length; ++x) {
                    this.texture.m_117991_().m_84988_(y, x, TextureInstance.getRGBA(pixels[y][x], this.dimensionId, this.sepia));
                }
            }
            this.texture.m_117985_();
        }

        @Override
        public void close() {
            this.texture.close();
            Minecraft.m_91087_().m_91097_().m_118513_(this.textureLocation);
        }

        private static int getRGBA(byte b, ResourceLocation dimension, boolean sepia) {
            if (sepia) {
                return SEPIA_COLORS.get(b);
            }
            List<Integer> l = DIMENSION_COLOR_MAP.getOrDefault(dimension, DIMENSION_COLOR_MAP.get(new ResourceLocation("overworld")));
            if (l != null) {
                return l.get(b);
            }
            return 1;
        }
    }
}

