/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.codexadrian.spirit.Spirit;
import me.codexadrian.spirit.SpiritConfig;
import me.codexadrian.spirit.data.Tier;
import me.codexadrian.spirit.entity.EntityRarity;
import me.codexadrian.spirit.platform.fabric.Services;
import me.codexadrian.spirit.utils.ClientUtils;
import me.codexadrian.spirit.utils.SoulUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoulCrystalItem
extends Item {
    public SoulCrystalItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        Component entityOrNone = (Component)Optional.ofNullable(SoulUtils.getSoulCrystalType(itemStack)).flatMap(EntityType::m_20632_).map(entityType -> Component.m_237110_((String)"item.spirit.soul_crystal.entity_component", (Object[])new Object[]{SoulUtils.getSoulsInCrystal(itemStack), entityType.m_20676_()}).m_130940_(EntityRarity.getRarity(entityType).color)).orElse(Component.m_237115_((String)"item.spirit.soul_crystal.none"));
        list.add((Component)Component.m_237110_((String)"item.spirit.soul_crystal.tooltip", (Object[])new Object[]{entityOrNone}).m_130940_(ChatFormatting.GRAY));
        if (SoulUtils.getSoulsInCrystal(itemStack) > 0) {
            ClientUtils.shiftTooltip(list, SoulCrystalItem.shiftToolTipComponents(itemStack, level), List.of());
        } else {
            list.add((Component)Component.m_237115_((String)"item.spirit.soul_crystal.info_empty").m_130940_(ChatFormatting.GRAY));
        }
    }

    private static List<Component> shiftToolTipComponents(@NotNull ItemStack itemStack, @Nullable Level level) {
        Tier nextTier;
        ArrayList<Component> list = new ArrayList<Component>();
        if (level == null) {
            return list;
        }
        Tier tier = SoulUtils.getTier(itemStack, level);
        MutableComponent display = Component.m_237115_((String)(tier == null ? SpiritConfig.getInitialTierName() : tier.displayName())).m_130940_(ChatFormatting.GRAY);
        list.add((Component)Component.m_237110_((String)"misc.spirit.tier", (Object[])new Object[]{display}).m_130940_(ChatFormatting.GRAY));
        if (tier == null && (SoulUtils.canCrystalBeUsedInCage(itemStack) || Services.PLATFORM.isModLoaded("vitalize") && SoulUtils.isAllowed(itemStack, Spirit.REVITALIZER_TAG))) {
            list.add((Component)Component.m_237115_((String)(Services.PLATFORM.isModLoaded("vitalize") ? "misc.spirit.not_viable_vitalize" : "misc.spirit.not_viable")).m_130940_(ChatFormatting.RED));
        }
        if ((nextTier = SoulUtils.getNextTier(itemStack, level)) != null) {
            list.add((Component)Component.m_237110_((String)"misc.spirit.next_tier", (Object[])new Object[]{nextTier.requiredSouls() - SoulUtils.getSoulsInCrystal(itemStack), Component.m_237115_((String)nextTier.displayName())}).m_130940_(ChatFormatting.GRAY));
        }
        if (SoulUtils.canCrystalBeUsedInCage(itemStack)) {
            list.add((Component)Component.m_237115_((String)"misc.spirit.soul_cage_compatible").m_130940_(ChatFormatting.GREEN));
        } else {
            list.add((Component)Component.m_237115_((String)"misc.spirit.soul_cage_incompatible").m_130940_(ChatFormatting.RED));
        }
        if (Services.PLATFORM.isModLoaded("vitalize")) {
            if (SoulUtils.isAllowed(itemStack, Spirit.REVITALIZER_TAG)) {
                list.add((Component)Component.m_237115_((String)"misc.vitalize.machine_compatible").m_130940_(ChatFormatting.GREEN));
            } else {
                list.add((Component)Component.m_237115_((String)"misc.vitalize.machine_incompatible").m_130940_(ChatFormatting.RED));
            }
        }
        return list;
    }

    public static double getPercentage(ItemStack itemStack, Level level) {
        Tier tier = SoulUtils.getNextTier(itemStack, level);
        if (tier == null && (tier = SoulUtils.getTier(itemStack, level)) == null) {
            return 0.0;
        }
        double percentage = (double)SoulUtils.getSoulsInCrystal(itemStack) / (double)tier.requiredSouls();
        return Math.min(percentage, 1.0);
    }

    public int m_142159_(@NotNull ItemStack itemStack) {
        return -16711685;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_142522_(@NotNull ItemStack stack) {
        return ClientUtils.isItemInHand(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int m_142158_(@NotNull ItemStack itemStack) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            return (int)(SoulCrystalItem.getPercentage(itemStack, (Level)level) * 13.0);
        }
        return 0;
    }
}

