/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.codexadrian.spirit.data.MobTrait;
import me.codexadrian.spirit.data.MobTraitSerializer;
import me.codexadrian.spirit.data.traits.DamageTrait;
import me.codexadrian.spirit.data.traits.ExplosionTrait;
import me.codexadrian.spirit.data.traits.FireTrait;
import me.codexadrian.spirit.data.traits.KnockbackTrait;
import me.codexadrian.spirit.data.traits.PotionTrait;
import net.minecraft.resources.ResourceLocation;

public class MobTraitRegistry {
    public static final Codec<MobTraitSerializer<?>> TRAIT_CODEC = ResourceLocation.f_135803_.comapFlatMap(MobTraitRegistry::decode, MobTraitSerializer::id);
    public static final Codec<MobTrait<?>> CODEC = TRAIT_CODEC.dispatch(MobTrait::serializer, MobTraitSerializer::codec);
    private static final Map<ResourceLocation, MobTraitSerializer<?>> SERIALIZERS = new HashMap();

    private static DataResult<? extends MobTraitSerializer<?>> decode(ResourceLocation id) {
        return Optional.ofNullable(SERIALIZERS.get(id)).map(DataResult::success).orElse(DataResult.error((String)"No trait type found."));
    }

    public static void add(MobTraitSerializer<?> serializer) {
        SERIALIZERS.put(serializer.id(), serializer);
    }

    static {
        MobTraitRegistry.add(ExplosionTrait.SERIALIZER);
        MobTraitRegistry.add(PotionTrait.SERIALIZER);
        MobTraitRegistry.add(FireTrait.SERIALIZER);
        MobTraitRegistry.add(DamageTrait.SERIALIZER);
        MobTraitRegistry.add(KnockbackTrait.SERIALIZER);
    }
}

