/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.utils;

import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import sc_libs.org.jetbrains.annotations.Nullable;

public class Util {
    public static <T> boolean iteratePage(List<T> list, int page, int pageSize, BiConsumer<T, Integer> consumer) {
        int index = Util.getIndex(page, pageSize);
        int toIndex = Math.min(index + pageSize, list.size());
        if (toIndex <= index) {
            return false;
        }
        for (T value : list.subList(index, toIndex)) {
            consumer.accept(value, ++index);
        }
        return true;
    }

    public static int getIndex(int page, int pageSize) {
        return pageSize * (page - 1);
    }

    public static int getPage(int index, int pageSize) {
        return (index + pageSize - 1) / pageSize;
    }

    public static <K, V extends Comparable<V>> List<Map.Entry<K, V>> sortByValue(Map<K, V> map) {
        ObjectArrayList entries = new ObjectArrayList(map.entrySet());
        entries.sort((c1, c2) -> ((Comparable)c2.getValue()).compareTo((Comparable)c1.getValue()));
        return entries;
    }

    public static CompletableFuture<Suggestions> suggestAll(SuggestionsBuilder builder, String ... suggestions) {
        for (String suggestion : suggestions) {
            builder.suggest(suggestion);
        }
        return builder.buildFuture();
    }

    public static boolean hasTasks(GoalSelector selector) {
        return Util.hasTasks(selector, null);
    }

    public static boolean hasTasks(GoalSelector selector, @Nullable Predicate<Goal> predicate) {
        for (WrappedGoal wrapped : selector.m_148105_()) {
            if (!wrapped.m_7620_() || predicate != null && !predicate.test(wrapped.m_26015_())) continue;
            return true;
        }
        return false;
    }
}

