/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import me.wesley1808.servercore.common.config.tables.CommandConfig;
import me.wesley1808.servercore.common.dynamic.DynamicManager;
import me.wesley1808.servercore.common.services.Formatter;
import me.wesley1808.servercore.common.services.Permission;
import me.wesley1808.servercore.common.utils.Statistics;
import me.wesley1808.servercore.common.utils.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import sc_libs.org.jetbrains.annotations.Nullable;

public class StatisticsCommand {
    private static final String[] SUB_COMMANDS = new String[]{"entities", "block-entities"};

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder statistics = (LiteralArgumentBuilder)Commands.m_82127_((String)"statistics").requires(Permission.require("command.statistics", 2));
        statistics.executes(ctx -> StatisticsCommand.displayOverview((CommandSourceStack)ctx.getSource()));
        int i = 0;
        while (i < SUB_COMMANDS.length) {
            int index = i++;
            statistics.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)SUB_COMMANDS[index]).executes(ctx -> StatisticsCommand.display((CommandContext<CommandSourceStack>)ctx, index, 1))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StatisticsCommand.display((CommandContext<CommandSourceStack>)ctx, index, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"byType").executes(ctx -> StatisticsCommand.display((CommandContext<CommandSourceStack>)ctx, index, false, 1))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StatisticsCommand.display((CommandContext<CommandSourceStack>)ctx, index, false, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> StatisticsCommand.display((CommandContext<CommandSourceStack>)ctx, index, 1, EntityArgument.m_91474_((CommandContext)ctx, (String)"player")))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StatisticsCommand.display((CommandContext<CommandSourceStack>)ctx, index, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"), EntityArgument.m_91474_((CommandContext)ctx, (String)"player"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"byPlayer").executes(ctx -> StatisticsCommand.display((CommandContext<CommandSourceStack>)ctx, index, true, 1))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StatisticsCommand.display((CommandContext<CommandSourceStack>)ctx, index, true, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))));
        }
        dispatcher.register(statistics);
    }

    private static int display(CommandContext<CommandSourceStack> context, int index, int page) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        if (player != null) {
            return StatisticsCommand.display(context, index, false, page, player);
        }
        return StatisticsCommand.display(context, index, false, page);
    }

    private static int display(CommandContext<CommandSourceStack> context, int index, boolean byPlayer, int page) {
        return StatisticsCommand.display(context, index, byPlayer, page, null);
    }

    private static int display(CommandContext<CommandSourceStack> context, int index, int page, @Nullable ServerPlayer player) {
        return StatisticsCommand.display(context, index, false, page, player);
    }

    private static int display(CommandContext<CommandSourceStack> context, int index, boolean byPlayer, int page, @Nullable ServerPlayer player) {
        return switch (index) {
            case 0 -> StatisticsCommand.displayEntities(context, byPlayer, page, player);
            case 1 -> StatisticsCommand.displayBlockEntities(context, byPlayer, page, player);
            default -> throw new IllegalStateException("Unexpected value: " + index);
        };
    }

    private static int displayOverview(CommandSourceStack source) {
        double mspt = DynamicManager.getInstance(source.m_81377_()).getAverageTickTime();
        double tps = mspt != 0.0 ? Math.min(1000.0 / mspt, 20.0) : 20.0;
        Statistics statistics = Statistics.getInstance(source.m_81377_());
        Component component = Formatter.parse(Formatter.line(CommandConfig.STATS_TITLE.get(), 40, source.m_230897_()) + "\n" + CommandConfig.STATS_CONTENT.get().replace("${tps}", String.format("%.2f", tps)).replace("${mspt}", String.format("%.2f", mspt)).replace("${chunk_count}", String.valueOf(statistics.getChunkCount(true))).replace("${entity_count}", String.valueOf(statistics.getAllEntities().size())).replace("${block_entity_count}", String.valueOf(statistics.getAllBlockEntities().size())));
        source.m_81354_(component, false);
        return 1;
    }

    private static int displayEntities(CommandContext<CommandSourceStack> context, boolean byPlayer, int page, @Nullable ServerPlayer player) {
        MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
        Statistics statistics = Statistics.getInstance(server);
        Map<String, Integer> map = byPlayer ? statistics.getEntitiesByPlayer(server.m_6846_().m_11314_()) : statistics.getEntitiesByType(player == null ? statistics.getAllEntities() : statistics.getEntitiesNear(player));
        StatisticsCommand.displayFeedback(context, map, false, byPlayer, page, player);
        return 1;
    }

    private static int displayBlockEntities(CommandContext<CommandSourceStack> context, boolean byPlayer, int page, @Nullable ServerPlayer player) {
        MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
        Statistics statistics = Statistics.getInstance(server);
        Map<String, Integer> map = byPlayer ? statistics.getBlockEntitiesByPlayer(server.m_6846_().m_11314_()) : statistics.getBlockEntitiesByType(player == null ? statistics.getAllBlockEntities() : statistics.getBlockEntitiesNear(player));
        StatisticsCommand.displayFeedback(context, map, true, byPlayer, page, player);
        return 1;
    }

    private static void displayFeedback(CommandContext<CommandSourceStack> context, Map<String, Integer> map, boolean isBlockEntity, boolean byPlayer, int page, @Nullable ServerPlayer player) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        StringBuilder builder = new StringBuilder(StatisticsCommand.createHeader(isBlockEntity, byPlayer, source.m_230897_(), player));
        boolean success = Util.iteratePage(Util.sortByValue(map), page, 8, (entry, index) -> builder.append(StatisticsCommand.createEntry(entry, index, isBlockEntity, byPlayer)));
        if (success) {
            builder.append("\n").append(StatisticsCommand.createFooter(page, Util.getPage(map.size(), 8), isBlockEntity, context));
            source.m_81354_(Formatter.parse(builder.toString()), false);
        } else if (page == 1) {
            source.m_81352_((Component)Component.m_237113_((String)(isBlockEntity ? "No block entities were found!" : "No entities were found!")));
        } else {
            source.m_81352_((Component)Component.m_237113_((String)"Page doesn't exist!"));
        }
    }

    private static String createEntry(Map.Entry<String, Integer> entry, int index, boolean isBlockEntity, boolean byPlayer) {
        Object string = "\n" + CommandConfig.STATS_PAGE_CONTENT.get().replace("${name}", entry.getKey()).replace("${index}", String.valueOf(index)).replace("${count}", String.valueOf(entry.getValue()));
        if (byPlayer) {
            string = Formatter.command(String.format("statistics %s byType %s", isBlockEntity ? "block-entities" : "entities", entry.getKey()), (String)string);
        }
        return string;
    }

    private static String createHeader(boolean isBlockEntity, boolean byPlayer, boolean isPlayer, ServerPlayer player) {
        String title = player == null ? CommandConfig.STATS_PAGE_TITLE.get().replace("${type}", byPlayer ? "Player" : "Type") : CommandConfig.STATS_PAGE_TITLE_PLAYER.get().replace("${player}", player.m_6302_());
        return Formatter.line(title.replace("${title}", isBlockEntity ? "Block Entities" : "Entities"), 40, isPlayer);
    }

    private static String createFooter(int page, int pageCount, boolean isBlockEntity, CommandContext<CommandSourceStack> context) {
        String title = CommandConfig.STATS_PAGE_FOOTER.get().replace("${page}", String.valueOf(page)).replace("${page_count}", String.valueOf(pageCount));
        Object command = context.getInput().replaceAll("\\b\\d+\\b", "%page_nr%");
        if (!((String)command).contains("%page_nr%")) {
            command = (String)command + " %page_nr%";
        }
        return Formatter.line(Formatter.page(title, (String)command, page), isBlockEntity ? 40 : 38, ((CommandSourceStack)context.getSource()).m_230897_());
    }
}

