/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.util;

import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.multiplayer.resolver.ResolvedServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerNameResolver;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.util.ServerQuery;

public final class PingUtil {
    public static CompletableFuture<ServerQuery.PingResponse> pingServer(String ip, int port) {
        try {
            ServerAddress serverAddress = new ServerAddress(ip, port);
            Optional<InetSocketAddress> optional = ServerNameResolver.f_171881_.m_171890_(serverAddress).map(ResolvedServerAddress::m_142641_);
            if (optional.isEmpty()) {
                return CompletableFuture.completedFuture(new ServerQuery.PingResponse());
            }
            InetSocketAddress address = optional.get();
            return ServerQuery.query(address);
        }
        catch (Throwable t) {
            RocketClientMod.getLogger().error("Failed to ping server {}:{} ({})", new Object[]{ip, port, t.getMessage()});
            return CompletableFuture.completedFuture(new ServerQuery.PingResponse());
        }
    }
}

