/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.util;

import com.google.common.hash.Hashing;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import dev.ftb.mods.ftblibrary.icon.Icon;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;

public final class GuiUtils {
    public static final ResourceLocation MISSING_ICON = new ResourceLocation("textures/misc/unknown_server.png");
    public static final Icon MISSING_IMAGE_ICON = Icon.getIcon((ResourceLocation)MISSING_ICON);
    private static final String[] FRAMES = new String[]{"O o o", "o O o", "o o O", "o O o"};
    private static final long INTERVAL_MS = 300L;

    public static String getLoadingDots(long currentMs) {
        int frameId = (int)(currentMs / 300L % (long)FRAMES.length);
        return FRAMES[frameId];
    }

    public static boolean shouldProcess(String requiredVariable, VariableStorage variableStorage) {
        if (requiredVariable == null || requiredVariable.isBlank()) {
            return true;
        }
        String[] parts = requiredVariable.split("&");
        if (parts.length == 0) {
            return false;
        }
        for (String part : parts) {
            String partTrimmed = part.trim();
            if (GuiUtils.shouldProcessPart(partTrimmed, variableStorage)) continue;
            return false;
        }
        return true;
    }

    private static boolean shouldProcessPart(String requiredVariable, VariableStorage variableStorage) {
        String str;
        Object value;
        boolean inverted = requiredVariable.startsWith("!");
        if (inverted) {
            requiredVariable = requiredVariable.substring(1);
        }
        if ((value = variableStorage.retrieve(requiredVariable)) instanceof Boolean) {
            Boolean hideElement = (Boolean)value;
            if (inverted) {
                hideElement = hideElement == false;
            }
            return hideElement;
        }
        if (value instanceof String && ((str = (String)value).equalsIgnoreCase("true") || str.equalsIgnoreCase("false"))) {
            boolean hideElement;
            boolean bl = hideElement = !Boolean.parseBoolean(str);
            if (inverted) {
                hideElement = !hideElement;
            }
            return !hideElement;
        }
        if (inverted) {
            return value == null;
        }
        return value != null;
    }

    public static void fillHorizontalGradient(PoseStack graphics, RenderType type, int x1, int y1, int x2, int y2, int z, int colorFrom, int colorTo) {
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        float f = (float)FastColor.ARGB32.m_13655_((int)colorFrom) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13665_((int)colorFrom) / 255.0f;
        float h = (float)FastColor.ARGB32.m_13667_((int)colorFrom) / 255.0f;
        float i = (float)FastColor.ARGB32.m_13669_((int)colorFrom) / 255.0f;
        float j = (float)FastColor.ARGB32.m_13655_((int)colorTo) / 255.0f;
        float k = (float)FastColor.ARGB32.m_13665_((int)colorTo) / 255.0f;
        float l = (float)FastColor.ARGB32.m_13667_((int)colorTo) / 255.0f;
        float m = (float)FastColor.ARGB32.m_13669_((int)colorTo) / 255.0f;
        Matrix4f matrix4f = graphics.m_85850_().m_85861_();
        float deltaR = (k - g) / (float)(x2 - x1);
        float deltaG = (l - h) / (float)(x2 - x1);
        float deltaB = (m - i) / (float)(x2 - x1);
        float deltaA = (j - f) / (float)(x2 - x1);
        for (int x = x1; x < x2; ++x) {
            float red = g + deltaR * (float)(x - x1);
            float green = h + deltaG * (float)(x - x1);
            float blue = i + deltaB * (float)(x - x1);
            float alpha = f + deltaA * (float)(x - x1);
            builder.m_85982_(matrix4f, (float)x, (float)y1, (float)z).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix4f, (float)x, (float)y2, (float)z).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix4f, (float)(x + 1), (float)y2, (float)z).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix4f, (float)(x + 1), (float)y1, (float)z).m_85950_(red, green, blue, alpha).m_5752_();
        }
        tesselator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static boolean isImageCached(String id) {
        return Minecraft.m_91087_().m_91097_().m_174786_(new ResourceLocation("remote_image", Hashing.sha1().hashUnencodedChars((CharSequence)id).toString()), null) != null;
    }

    public static ResourceLocation getOrLoadImage(URI uri) {
        return GuiUtils.getOrLoadImage(uri, null);
    }

    public static ResourceLocation getOrLoadImage(URI uri, @Nullable String id) {
        ResourceLocation location;
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        if (textureManager.m_174786_(location = new ResourceLocation("remote_image", Hashing.sha1().hashUnencodedChars((CharSequence)(id != null ? id : uri.toString())).toString()), null) != null) {
            return location;
        }
        try {
            InputStream stream = uri.toURL().openStream();
            NativeImage nativeImage = NativeImage.m_85058_((InputStream)stream);
            DynamicTexture texture = new DynamicTexture(nativeImage);
            textureManager.m_118495_(location, (AbstractTexture)texture);
            return location;
        }
        catch (IOException e) {
            RocketClientMod.getLogger().error("Failed to load image from URI: {}", (Object)uri, (Object)e);
            return MISSING_ICON;
        }
    }
}

