/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.loader;

import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ErrorScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.loader.ListEntryLoader;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.type.AbstractListLayoutTemplate;
import net.rocketplatform.game.client.mod.ui.variable.VariableProcessor;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;

public class SingleplayerWorldEntryLoader
extends ListEntryLoader {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat();

    public SingleplayerWorldEntryLoader(String type, AbstractListLayoutTemplate.ListEntry entryTemplate) {
        super(type, entryTemplate);
    }

    @Override
    public CompletableFuture<List<ListEntryLoader.ListEntryTemplate>> loadEntries(@Nullable VariableStorage storage) {
        AbstractListLayoutTemplate.ListEntry entryTemplate = this.getEntryTemplate();
        if (storage == null) {
            RocketClientMod.getLogger().warn("No storage provided for singleplayer world list entry loader, so no entries will be loaded.");
            return CompletableFuture.completedFuture(List.of());
        }
        return SingleplayerWorldEntryLoader.loadLevels().thenApply(levels -> {
            if (levels.isEmpty()) {
                return List.of();
            }
            ArrayList<ListEntryLoader.ListEntryTemplate> entries = new ArrayList<ListEntryLoader.ListEntryTemplate>();
            for (LevelSummary level : levels) {
                Path levelPath = Minecraft.m_91087_().m_91392_().m_78257_().resolve(level.m_78358_());
                VariableStorage worldStorage = new VariableStorage();
                worldStorage.store("worldPath", levelPath.toString());
                worldStorage.store("worldId", level.m_78358_());
                worldStorage.store("worldName", level.m_78361_());
                worldStorage.store("worldInfo", level.m_78376_().getString());
                worldStorage.store("worldIcon", level.m_230875_().toUri());
                worldStorage.store("worldLastPlayed", DATE_FORMAT.format(new Date(level.m_78366_())));
                worldStorage.store("worldGameMode", level.m_78367_().m_46405_());
                List<ElementTemplate<?>> elements = SingleplayerWorldEntryLoader.processElements(entryTemplate, worldStorage);
                AbstractListLayoutTemplate.ListEntry entry = new AbstractListLayoutTemplate.ListEntry(VariableProcessor.process(entryTemplate.getId(), worldStorage), elements, entryTemplate.requiredDoubleClickVariable(), entryTemplate.getCallback(), entryTemplate.selectedCallback());
                entries.add(new ListEntryLoader.ListEntryTemplate(entry, worldStorage));
            }
            return entries;
        });
    }

    private static CompletableFuture<List<LevelSummary>> loadLevels() {
        LevelStorageSource.LevelCandidates candidates;
        try {
            candidates = Minecraft.m_91087_().m_91392_().m_230833_();
        }
        catch (LevelStorageException e) {
            RocketClientMod.getLogger().error("Couldn't load level list", (Throwable)e);
            SingleplayerWorldEntryLoader.handleLevelLoadFailure(e.m_230806_());
            return CompletableFuture.completedFuture(List.of());
        }
        if (candidates.m_230843_()) {
            return CompletableFuture.completedFuture(List.of());
        }
        return Minecraft.m_91087_().m_91392_().m_230813_(candidates).exceptionally(throwable -> List.of());
    }

    private static void handleLevelLoadFailure(Component exceptionMessage) {
        Minecraft.m_91087_().m_91152_((Screen)new ErrorScreen((Component)Component.m_237115_((String)"selectWorld.unable_to_load"), exceptionMessage));
    }
}

