/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.network;

import java.util.function.Supplier;
import mcjty.rftoolsutility.modules.teleporter.client.GuiAdvancedPorter;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PacketTargetsReady {
    private final int target;
    private final int[] targets;
    private final String[] names;

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.target);
        buf.writeInt(this.targets.length);
        for (int i = 0; i < this.targets.length; ++i) {
            buf.writeInt(this.targets[i]);
            buf.m_130070_(this.names[i]);
        }
    }

    public PacketTargetsReady(FriendlyByteBuf buf) {
        this.target = buf.readInt();
        int size = buf.readInt();
        this.targets = new int[size];
        this.names = new String[size];
        for (int i = 0; i < size; ++i) {
            this.targets[i] = buf.readInt();
            this.names[i] = buf.m_130136_(Short.MAX_VALUE);
        }
    }

    public PacketTargetsReady(int target, int[] targets, String[] names) {
        this.target = target;
        this.targets = targets;
        this.names = names;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> GuiAdvancedPorter.setInfo(this.target, this.targets, this.names));
        ctx.setPacketHandled(true);
    }
}

