/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.storage;

import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class StorageEntry {
    private NonNullList<ItemStack> stacks;
    private final UUID uuid;
    private int version;
    private final long creationTime;
    private long updateTime;
    private String createdBy;

    public StorageEntry(CompoundTag nbt) {
        int size = nbt.m_128451_("slots");
        this.stacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        ListTag tagList = nbt.m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags));
        }
        this.uuid = nbt.m_128403_("UUID") ? nbt.m_128342_("UUID") : null;
        this.version = nbt.m_128451_("version");
        this.creationTime = nbt.m_128454_("crTime");
        this.updateTime = nbt.m_128454_("upTime");
        this.createdBy = nbt.m_128461_("createdBy");
    }

    public StorageEntry(int size, UUID uuid, String createdBy) {
        this.stacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        this.uuid = uuid;
        this.version = 1;
        this.creationTime = this.updateTime = System.currentTimeMillis();
        this.createdBy = createdBy == null ? "" : createdBy;
    }

    public int getVersion() {
        return this.version;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void updateVersion() {
        ++this.version;
        this.updateTime = System.currentTimeMillis();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public NonNullList<ItemStack> getStacks() {
        return this.stacks;
    }

    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("slots", this.stacks.size());
        nbt.m_128405_("version", this.version);
        nbt.m_128356_("crTime", this.creationTime);
        nbt.m_128356_("upTime", this.updateTime);
        nbt.m_128359_("createdBy", this.createdBy);
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            ((ItemStack)this.stacks.get(i)).m_41739_(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        nbt.m_128365_("Items", (Tag)nbtTagList);
        nbt.m_128362_("UUID", this.uuid);
        return nbt;
    }

    public void resize(int size, String createdBy) {
        NonNullList<ItemStack> oldList = this.stacks;
        this.stacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        for (int i = 0; i < Math.min(oldList.size(), size); ++i) {
            this.stacks.set(i, (Object)((ItemStack)oldList.get(i)));
        }
        this.updateTime = System.currentTimeMillis();
        if (createdBy != null && !createdBy.isEmpty()) {
            this.createdBy = createdBy;
        }
    }
}

