/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.compat.xnet;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.AbstractConnectorSettings;
import mcjty.rftoolsstorage.compat.xnet.StorageChannelSettings;
import mcjty.rftoolsstorage.modules.scanner.tools.InventoryAccessSettings;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class StorageConnectorSettings
extends AbstractConnectorSettings {
    public static final String TAG_MODE = "mode";
    public static final String TAG_BIGUI = "bigui";
    public static final String TAG_BIAUTO = "biauto";
    public static final String TAG_BISCREEN = "biscreen";
    public static final String TAG_BOGUI = "bogui";
    public static final String TAG_BOAUTO = "boauto";
    public static final String TAG_BOSCREEN = "boscreen";
    public static final String TAG_FILTER = "flt";
    public static final String TAG_BLACKLIST = "blacklist";
    public static final String TAG_NBT = "nbt";
    public static final String TAG_META = "meta";
    private Mode mode = Mode.INVENTORY;
    private InventoryAccessSettings accessSettings = new InventoryAccessSettings();

    public StorageConnectorSettings(@Nonnull Direction side) {
        super(side);
    }

    public Mode getMode() {
        return this.mode;
    }

    public InventoryAccessSettings getAccessSettings() {
        return this.accessSettings;
    }

    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.mode = Mode.values()[tag.m_128445_(TAG_MODE)];
        this.accessSettings.setBlockInputGui(tag.m_128471_(TAG_BIGUI));
        this.accessSettings.setBlockInputAuto(tag.m_128471_(TAG_BIAUTO));
        this.accessSettings.setBlockInputScreen(tag.m_128471_(TAG_BISCREEN));
        this.accessSettings.setBlockOutputGui(tag.m_128471_(TAG_BOGUI));
        this.accessSettings.setBlockOutputAuto(tag.m_128471_(TAG_BOAUTO));
        this.accessSettings.setBlockOutputScreen(tag.m_128471_(TAG_BOSCREEN));
        for (int i = 0; i < 18; ++i) {
            if (tag.m_128441_("filter" + i)) {
                CompoundTag itemTag = tag.m_128469_("filter" + i);
                this.accessSettings.getFilters().set(i, (Object)ItemStack.m_41712_((CompoundTag)itemTag));
                continue;
            }
            this.accessSettings.getFilters().set(i, (Object)ItemStack.f_41583_);
        }
        this.accessSettings.setMetaMode(tag.m_128471_("metaMode"));
        this.accessSettings.setNbtMode(tag.m_128471_("nbtMode"));
        this.accessSettings.setBlacklist(tag.m_128471_(TAG_BLACKLIST));
    }

    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.m_128344_(TAG_MODE, (byte)this.mode.ordinal());
        tag.m_128379_(TAG_BIGUI, this.accessSettings.isBlockInputGui());
        tag.m_128379_(TAG_BIAUTO, this.accessSettings.isBlockInputAuto());
        tag.m_128379_(TAG_BISCREEN, this.accessSettings.isBlockInputScreen());
        tag.m_128379_(TAG_BOGUI, this.accessSettings.isBlockOutputGui());
        tag.m_128379_(TAG_BOAUTO, this.accessSettings.isBlockOutputAuto());
        tag.m_128379_(TAG_BOSCREEN, this.accessSettings.isBlockOutputScreen());
        for (int i = 0; i < 18; ++i) {
            if (((ItemStack)this.accessSettings.getFilters().get(i)).m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            ((ItemStack)this.accessSettings.getFilters().get(i)).m_41739_(itemTag);
            tag.m_128365_("filter" + i, (Tag)itemTag);
        }
        tag.m_128379_("metaMode", this.accessSettings.isMetaMode());
        tag.m_128379_("nbtMode", this.accessSettings.isNbtMode());
        tag.m_128379_(TAG_BLACKLIST, this.accessSettings.isBlacklist());
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        switch (this.mode) {
            case INVENTORY: {
                boolean inputBlocked = this.accessSettings.inputBlocked();
                boolean outputBlocked = this.accessSettings.outputBlocked();
                if (inputBlocked && outputBlocked) {
                    return new IndicatorIcon(StorageChannelSettings.iconGuiElements, 13, 75, 13, 10);
                }
                if (inputBlocked) {
                    return new IndicatorIcon(StorageChannelSettings.iconGuiElements, 13, 48, 13, 10);
                }
                if (outputBlocked) {
                    return new IndicatorIcon(StorageChannelSettings.iconGuiElements, 0, 48, 13, 10);
                }
                return new IndicatorIcon(StorageChannelSettings.iconGuiElements, 13, 57, 13, 10);
            }
            case STORAGE: {
                return new IndicatorIcon(StorageChannelSettings.iconGuiElements, 13, 66, 13, 10);
            }
        }
        return null;
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public boolean isEnabled(String tag) {
        if (tag.equals("facing")) {
            return this.advanced;
        }
        return true;
    }

    public void createGui(IEditorGui gui) {
        this.advanced = gui.isAdvanced();
        this.sideGui(gui);
        gui.shift(30).choices(TAG_MODE, "Set to 'inventory' or 'storage'", (Enum)this.mode, (Enum[])Mode.values());
        if (this.mode == Mode.INVENTORY) {
            gui.nl().label("Input ").shift(12).label("UI").toggle(TAG_BIGUI, "Block input from scanner UI", this.accessSettings.isBlockInputGui()).label("Auto").toggle(TAG_BIAUTO, "Block input from automation", this.accessSettings.isBlockInputAuto()).label("Scr").toggle(TAG_BISCREEN, "Block input from screens", this.accessSettings.isBlockInputScreen());
            gui.nl().label("Output").shift(10).label("UI").toggle(TAG_BOGUI, "Block extraction from scanner UI", this.accessSettings.isBlockOutputGui()).label("Auto").toggle(TAG_BOAUTO, "Block extraction from automation", this.accessSettings.isBlockOutputAuto()).label("Scr").toggle(TAG_BOSCREEN, "Block extraction from screens", this.accessSettings.isBlockOutputScreen());
            gui.nl().toggleText(TAG_BLACKLIST, "Enable blacklist mode", "BL", this.accessSettings.isBlacklist()).shift(2).toggleText(TAG_META, "Metadata matching", "Meta", this.accessSettings.isMetaMode()).shift(2).toggleText(TAG_NBT, "NBT matching", "NBT", this.accessSettings.isNbtMode()).nl();
            for (int i = 0; i < 18; ++i) {
                gui.ghostSlot(TAG_FILTER + i, (ItemStack)this.accessSettings.getFilters().get(i));
            }
        }
    }

    private static boolean toBool(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    public void update(Map<String, Object> data) {
        super.update(data);
        this.mode = Mode.valueOf(((String)data.get(TAG_MODE)).toUpperCase());
        this.accessSettings.setBlockInputGui(StorageConnectorSettings.toBool(data.get(TAG_BIGUI)));
        this.accessSettings.setBlockInputAuto(StorageConnectorSettings.toBool(data.get(TAG_BIAUTO)));
        this.accessSettings.setBlockInputScreen(StorageConnectorSettings.toBool(data.get(TAG_BISCREEN)));
        this.accessSettings.setBlockOutputGui(StorageConnectorSettings.toBool(data.get(TAG_BOGUI)));
        this.accessSettings.setBlockOutputAuto(StorageConnectorSettings.toBool(data.get(TAG_BOAUTO)));
        this.accessSettings.setBlockOutputScreen(StorageConnectorSettings.toBool(data.get(TAG_BOSCREEN)));
        for (int i = 0; i < 18; ++i) {
            this.accessSettings.getFilters().set(i, (Object)((ItemStack)data.get(TAG_FILTER + i)));
        }
        this.accessSettings.setMetaMode(StorageConnectorSettings.toBool(data.get(TAG_META)));
        this.accessSettings.setNbtMode(StorageConnectorSettings.toBool(data.get(TAG_NBT)));
        this.accessSettings.setBlacklist(StorageConnectorSettings.toBool(data.get(TAG_BLACKLIST)));
    }

    public static enum Mode {
        INVENTORY,
        STORAGE;

    }
}

