/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.items;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.ModuleTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsbase.tools.GenericModuleItem;
import mcjty.rftoolsbuilder.modules.mover.MoverConfiguration;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverControllerTileEntity;
import mcjty.rftoolsbuilder.modules.mover.items.VehicleControlClientScreenModule;
import mcjty.rftoolsbuilder.modules.mover.items.VehicleControlScreenModule;
import mcjty.rftoolsbuilder.setup.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class VehicleControlModuleItem
extends GenericModuleItem
implements INBTPreservingIngredient {
    protected int getUses(ItemStack stack) {
        return (Integer)MoverConfiguration.VEHICLE_CONTROL_RFPERTICK.get();
    }

    protected boolean hasGoldMessage(ItemStack stack) {
        return !ModuleTools.hasModuleTarget((ItemStack)stack);
    }

    protected String getInfoString(ItemStack stack) {
        return ModuleTools.getTargetString((ItemStack)stack);
    }

    public VehicleControlModuleItem() {
        super(Registration.createStandardProperties().m_41487_(1));
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        Level world = context.m_43725_();
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof MoverControllerTileEntity) {
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            String name = "<invalid>";
            if (block != null && !world.m_8055_(pos).m_60795_()) {
                name = Tools.getReadableName((Level)world, (BlockPos)pos);
            }
            ModuleTools.setPositionInModule((ItemStack)stack, (ResourceKey)world.m_46472_(), (BlockPos)pos, (String)name);
            if (world.f_46443_) {
                Logging.message((Player)player, (String)("Vehicle control module is set to block '" + name + "'"));
            }
        } else {
            ModuleTools.clearPositionInModule((ItemStack)stack);
            if (world.f_46443_) {
                Logging.message((Player)player, (String)"Vehicle control module is cleared");
            }
        }
        return InteractionResult.SUCCESS;
    }

    public Class<VehicleControlScreenModule> getServerScreenModule() {
        return VehicleControlScreenModule.class;
    }

    public Class<VehicleControlClientScreenModule> getClientScreenModule() {
        return VehicleControlClientScreenModule.class;
    }

    public String getModuleName() {
        return "Veh";
    }

    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.label("Label:").text("text", new String[]{"Label text"}).color("color", new String[]{"Label color"}).nl().label("Button:").text("button", new String[]{"Button text"}).color("buttonColor", new String[]{"Button color"}).nl().label("Mover:").text("mover", new String[]{"Name of the mover"}).nl().label("Vehicle:").text("vehicle", new String[]{"Name of the vehicle"}).nl().choices("align", "Label alignment", new String[]{"Left", "Center", "Right"}).nl();
    }

    public Collection<String> getTagsToPreserve() {
        return Collections.emptyList();
    }
}

