/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import mcjty.lib.client.RenderHelper;
import mcjty.rftoolsbuilder.modules.mover.MoverModule;
import mcjty.rftoolsbuilder.modules.mover.blocks.InvisibleMoverBlock;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverControlBlock;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverStatusBlock;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverTileEntity;
import mcjty.rftoolsbuilder.modules.mover.items.VehicleCard;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class MoverRenderer {
    private static final Map<BlockPos, Runnable> DELAYED_PRE_RENDERS = new HashMap<BlockPos, Runnable>();
    private static final Map<BlockPos, BiFunction<Level, BlockPos, Boolean>> PRERENDER_VALIDATIONS = new HashMap<BlockPos, BiFunction<Level, BlockPos, Boolean>>();
    public static final ResourceLocation BLACK = new ResourceLocation("rftoolsbuilder", "block/effects/black");
    public static final int LINES_SUPPORTED = 7;

    public static float getPartialTicks() {
        return Minecraft.m_91087_().m_91296_();
    }

    public static void actualRender(MoverTileEntity mover, @NotNull PoseStack matrixStack, Vec3 cameraPos, ItemStack card, Vec3 current, Vec3 offset, RenderType renderType) {
        matrixStack.m_85836_();
        Level level = mover.m_58904_();
        matrixStack.m_85837_(current.f_82479_ - cameraPos.f_82479_ - offset.f_82479_, current.f_82480_ - cameraPos.f_82480_ - offset.f_82480_, current.f_82481_ - cameraPos.f_82481_ - offset.f_82481_);
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        Map<BlockState, List<BlockPos>> blocks = VehicleCard.getBlocks(card, mover.getOffset());
        ((InvisibleMoverBlock)((Object)MoverModule.INVISIBLE_MOVER_BLOCK.get())).removeData(mover.m_58899_());
        AtomicInteger totalPagers = new AtomicInteger();
        boolean[] pagers = new boolean[]{false, false, false, false};
        blocks.forEach((state, positions) -> {
            MoverControlBlock moverControl;
            Block patt3354$temp = state.m_60734_();
            if (patt3354$temp instanceof MoverControlBlock && !pagers[(moverControl = (MoverControlBlock)patt3354$temp).getPage()]) {
                pagers[moverControl.getPage()] = true;
                totalPagers.incrementAndGet();
            }
        });
        mover.setHighlightedMover("");
        blocks.forEach((state, positions) -> {
            positions.forEach(pos -> {
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                BlockPos realPos = new BlockPos((int)current.f_82479_, (int)current.f_82480_, (int)current.f_82481_).m_7918_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                int lightColor = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)realPos);
                blockRenderer.renderSingleBlock(state, matrixStack, (MultiBufferSource)buffer, lightColor, OverlayTexture.f_118083_, ModelData.EMPTY, renderType);
                matrixStack.m_85849_();
            });
            if (state.m_60734_() instanceof MoverControlBlock || state.m_60734_() instanceof MoverStatusBlock) {
                positions.forEach(pos -> {
                    matrixStack.m_85836_();
                    matrixStack.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                    BlockPos realPos = new BlockPos((int)current.f_82479_, (int)current.f_82480_, (int)current.f_82481_).m_7918_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                    ((InvisibleMoverBlock)((Object)((Object)((Object)MoverModule.INVISIBLE_MOVER_BLOCK.get())))).registerData(mover.m_58899_(), realPos, (Direction)state.m_61143_((Property)MoverControlBlock.HORIZ_FACING), (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_));
                    int lightColor = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)realPos);
                    MoverRenderer.setupTransform(matrixStack, state);
                    Block patt5100$temp = state.m_60734_();
                    if (patt5100$temp instanceof MoverControlBlock) {
                        MoverControlBlock moverControl = (MoverControlBlock)patt5100$temp;
                        MoverRenderer.renderMoverControl(matrixStack, (MultiBufferSource)buffer, mover, lightColor, Objects.equals(realPos, mover.getCursorBlock()), MoverRenderer.getCorrectedPage(moverControl.getPage(), pagers), totalPagers.get());
                    } else {
                        MoverRenderer.renderMoverStatus(matrixStack, (MultiBufferSource)buffer, mover, lightColor);
                    }
                    matrixStack.m_85849_();
                });
            }
        });
        matrixStack.m_85849_();
    }

    private static int getCorrectedPage(int page, boolean[] pagers) {
        for (int i = 0; i < pagers.length; ++i) {
            if (!pagers[i]) continue;
            if (page == 0) {
                return i;
            }
            --page;
        }
        return 0;
    }

    private static void renderMoverStatus(@NotNull PoseStack matrixStack, @NotNull MultiBufferSource buffer, MoverTileEntity mover, int lightColor) {
        MoverRenderer.renderScreenBoard(matrixStack, buffer, 1.0f, lightColor);
        MoverRenderer.renderStatus(matrixStack, buffer, Minecraft.m_91087_().f_91062_, lightColor, mover);
    }

    private static void renderMoverControl(@NotNull PoseStack matrixStack, @NotNull MultiBufferSource buffer, MoverTileEntity mover, int lightColor, boolean doCursor, int page, int totalPagers) {
        MoverRenderer.renderScreenBoard(matrixStack, buffer, 1.0f, lightColor);
        MoverRenderer.renderMovers(matrixStack, buffer, Minecraft.m_91087_().f_91062_, lightColor, mover, doCursor, page, totalPagers);
    }

    private static void setupTransform(@NotNull PoseStack matrixStack, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        Direction horizontalFacing = (Direction)state.m_61143_((Property)MoverControlBlock.HORIZ_FACING);
        float yRotation = switch (horizontalFacing) {
            case Direction.NORTH -> -180.0f;
            case Direction.WEST -> -90.0f;
            case Direction.EAST -> 90.0f;
            default -> 0.0f;
        };
        float xRotation = switch (facing) {
            case Direction.DOWN -> 90.0f;
            case Direction.UP -> -90.0f;
            default -> 0.0f;
        };
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        RenderHelper.rotateYP((PoseStack)matrixStack, (float)yRotation);
        RenderHelper.rotateXP((PoseStack)matrixStack, (float)xRotation);
        matrixStack.m_85837_(0.0, 0.0, -0.4375);
    }

    private static void renderScreenBoard(PoseStack matrixStack, @Nullable MultiBufferSource buffer, float renderOffset, int packedLight) {
        matrixStack.m_85836_();
        matrixStack.m_85841_(1.0f, -1.0f, -1.0f);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(BLACK);
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110451_());
        RenderHelper.renderQuadGui((PoseStack)matrixStack, (TextureAtlasSprite)sprite, (int)packedLight, (VertexConsumer)builder, (float)(-renderOffset + 0.05f), (float)0.5f);
        matrixStack.m_85849_();
    }

    private static void renderMovers(PoseStack matrixStack, MultiBufferSource buffer, Font fontrenderer, int lightmapValue, MoverTileEntity mover, boolean doCursor, int page, int totalPagers) {
        boolean bright = true;
        int textcolor = 0x999999;
        int currentcolor = 65280;
        float factor = 2.0f;
        int currenty = 9;
        float f = 0.005f;
        matrixStack.m_85836_();
        matrixStack.m_85837_(-0.5, 0.5, 0.97);
        matrixStack.m_85841_(f * factor, -1.0f * f * factor, f);
        int light = bright ? 0xF000F0 : lightmapValue;
        String currentPlatform = mover.getCurrentPlatform();
        if (!mover.isMoverValid()) {
            RenderHelper.renderText((Font)fontrenderer, (String)"Not Connected!", (int)10, (int)currenty, (int)-65536, (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)light);
            RenderHelper.renderText((Font)fontrenderer, (String)"Press 'Scan'", (int)10, (int)(currenty + 20), (int)-1, (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)light);
            RenderHelper.renderText((Font)fontrenderer, (String)"at controller", (int)10, (int)(currenty + 30), (int)-1, (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)light);
        } else if (!mover.hasEnoughPower()) {
            RenderHelper.renderText((Font)fontrenderer, (String)"No Power!", (int)10, (int)currenty, (int)-65536, (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)light);
        } else {
            boolean showNavigator;
            double cursorX = mover.getCursorX();
            double cursorY = mover.getCursorY();
            List<String> platforms = mover.getPlatformsFromServer();
            int l = 0;
            int linesSupported = 7;
            boolean bl = showNavigator = page >= totalPagers - 1;
            if (!showNavigator) {
                linesSupported += 2;
            }
            int totalSupportedMovers = (linesSupported + 2) * (totalPagers - 1) + linesSupported;
            int start = mover.getCurrentPage() * totalSupportedMovers;
            if (page > 0) {
                start += (linesSupported + 2) * page;
                currenty = 0;
            }
            for (int i = start; i < platforms.size(); ++i) {
                int color;
                String line = platforms.get(i);
                int n = color = line.equals(currentPlatform) ? currentcolor : textcolor;
                if (doCursor) {
                    MoverRenderer.renderCursor(matrixStack, buffer, mover, currenty, light, cursorY, currenty, currenty + 10, 5, 95, line);
                }
                RenderHelper.renderText((Font)fontrenderer, (String)line, (int)10, (int)currenty, (int)(0xFF000000 | color), (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)light);
                currenty += 10;
                if (++l >= linesSupported) break;
            }
            if (platforms.size() > totalSupportedMovers && showNavigator) {
                currenty = 82;
                if (doCursor && (double)currenty / 100.0 <= cursorY && cursorY <= (double)(currenty + 10) / 100.0) {
                    MoverRenderer.renderCursor(matrixStack, buffer, mover, currenty, light, cursorX, 68, 78, 68, 78, "___<___");
                    MoverRenderer.renderCursor(matrixStack, buffer, mover, currenty, light, cursorX, 78, 88, 78, 88, "");
                    MoverRenderer.renderCursor(matrixStack, buffer, mover, currenty, light, cursorX, 88, 98, 88, 98, "___>___");
                }
                RenderHelper.renderText((Font)fontrenderer, (String)"<", (int)70, (int)currenty, (int)-16763939, (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)light);
                RenderHelper.renderText((Font)fontrenderer, (String)("" + (mover.getCurrentPage() + 1)), (int)80, (int)currenty, (int)-16763939, (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)light);
                RenderHelper.renderText((Font)fontrenderer, (String)">", (int)90, (int)currenty, (int)-16763939, (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)light);
            }
        }
        matrixStack.m_85849_();
    }

    private static void renderCursor(PoseStack matrixStack, MultiBufferSource buffer, MoverTileEntity mover, int currenty, int light, double cursor, int cursor1, int cursor2, int x1, int x2, String s) {
        if ((double)cursor1 / 100.0 <= cursor && cursor <= (double)cursor2 / 100.0) {
            matrixStack.m_85837_(0.0, 0.0, -0.01);
            RenderHelper.drawHorizontalGradientRect((PoseStack)matrixStack, (MultiBufferSource)buffer, (int)x1, (int)(currenty - 1), (int)x2, (int)(currenty + 9), (int)-13421773, (int)-13421773, (int)light);
            matrixStack.m_85837_(0.0, 0.0, 0.01);
            mover.setHighlightedMover(s);
        }
    }

    private static void renderStatus(PoseStack matrixStack, MultiBufferSource buffer, Font fontrenderer, int lightmapValue, MoverTileEntity mover) {
        boolean bright = true;
        int textcolor = -6710887;
        int currentcolor = 65280;
        float factor = 2.0f;
        int currenty = 9;
        float f = 0.005f;
        matrixStack.m_85836_();
        matrixStack.m_85837_(-0.5, 0.5, 0.97);
        matrixStack.m_85841_(f * factor, -1.0f * f * factor, f);
        boolean l = false;
        int light = bright ? 0xF000F0 : lightmapValue;
        String currentPlatform = mover.getCurrentPlatform();
        if (!mover.isMoverValid()) {
            RenderHelper.renderText((Font)fontrenderer, (String)"Not Connected!", (int)10, (int)currenty, (int)-65536, (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)light);
            RenderHelper.renderText((Font)fontrenderer, (String)"Press 'Scan'", (int)10, (int)(currenty + 20), (int)-1, (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)light);
            RenderHelper.renderText((Font)fontrenderer, (String)"at controller", (int)10, (int)(currenty + 30), (int)-1, (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)light);
        } else {
            RenderHelper.renderText((Font)fontrenderer, (String)"At:", (int)10, (int)currenty, (int)textcolor, (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)light);
            RenderHelper.renderText((Font)fontrenderer, (String)currentPlatform, (int)30, (int)currenty, (int)currentcolor, (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)light);
            currenty += 10;
            String destinationName = VehicleCard.getDesiredDestinationName(mover.getCard());
            if (destinationName != null && !destinationName.isEmpty()) {
                RenderHelper.renderText((Font)fontrenderer, (String)"To:", (int)10, (int)currenty, (int)textcolor, (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)light);
                RenderHelper.renderText((Font)fontrenderer, (String)destinationName, (int)30, (int)currenty, (int)currentcolor, (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)light);
            }
        }
        matrixStack.m_85849_();
    }

    public static void addPreRender(BlockPos pos, Runnable renderer, BiFunction<Level, BlockPos, Boolean> validator) {
        DELAYED_PRE_RENDERS.put(pos, renderer);
        PRERENDER_VALIDATIONS.put(pos, validator);
    }

    public static void preRender() {
        HashSet todelete = new HashSet();
        DELAYED_PRE_RENDERS.forEach((pos, consumer) -> {
            if (PRERENDER_VALIDATIONS.getOrDefault(pos, (level, blockPos) -> false).apply((Level)Minecraft.m_91087_().f_91073_, (BlockPos)pos).booleanValue()) {
                consumer.run();
            } else {
                todelete.add(pos);
            }
        });
        for (BlockPos pos2 : todelete) {
            DELAYED_PRE_RENDERS.remove(pos2);
            PRERENDER_VALIDATIONS.remove(pos2);
        }
    }

    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        MoverRenderer.preRender();
    }
}

