/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.informationscreen.blocks;

import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.infoscreen.CapabilityInformationScreenInfo;
import mcjty.rftoolsbase.api.infoscreen.IInformationScreenInfo;
import mcjty.rftoolsbase.modules.informationscreen.InformationScreenModule;
import mcjty.rftoolsbase.modules.informationscreen.blocks.DefaultPowerInformationScreenInfo;
import mcjty.rftoolsbase.modules.informationscreen.blocks.InformationScreenBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;

public class InformationScreenTileEntity
extends TickingTileEntity {
    private int mode = 0;
    private int cnt = 0;
    private long lastHudTime = 0L;
    private TypedMap clientData;

    public InformationScreenTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)InformationScreenModule.TYPE_INFORMATION_SCREEN.get(), pos, state);
    }

    public Direction getBlockOrientation() {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (state.m_60734_() instanceof InformationScreenBlock) {
            return OrientationTools.getOrientationHoriz((BlockState)state);
        }
        return null;
    }

    public void tickServer() {
        --this.cnt;
        if (this.cnt <= 0) {
            this.cnt = 10;
            BlockPos offset = this.m_58899_().m_121945_(this.getBlockOrientation().m_122424_());
            BlockEntity te = this.f_58857_.m_7702_(offset);
            if (te != null) {
                te.getCapability(CapabilityInformationScreenInfo.INFORMATION_SCREEN_INFO_CAPABILITY).ifPresent(IInformationScreenInfo::tick);
            }
        }
    }

    public void toggleMode() {
        this.getInfo().ifPresent(h -> {
            int[] modes = h.getSupportedModes();
            int found = -1;
            for (int i = 0; i < modes.length; ++i) {
                if (modes[i] != this.mode) continue;
                found = i;
                break;
            }
            if (found != -1) {
                this.mode = modes[++found % modes.length];
                this.markDirtyClient();
            }
        });
    }

    public int getMode() {
        return this.mode;
    }

    protected void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.mode = info.m_128445_("mode");
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag infoTag = this.getOrCreateInfo(tagCompound);
        infoTag.m_128344_("mode", (byte)this.mode);
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        CompoundTag infoTag = this.getOrCreateInfo(tagCompound);
        infoTag.m_128344_("mode", (byte)this.mode);
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        CompoundTag info = tagCompound.m_128469_("Info");
        this.mode = info.m_128445_("mode");
    }

    public void setClientData(TypedMap power) {
        this.clientData = power;
    }

    public TypedMap getClientData() {
        return this.clientData;
    }

    public long getLastUpdateTime() {
        return this.lastHudTime;
    }

    public void setLastUpdateTime(long t) {
        this.lastHudTime = t;
    }

    public LazyOptional<IInformationScreenInfo> getInfo() {
        BlockPos offset = this.m_58899_().m_121945_(this.getBlockOrientation().m_122424_());
        BlockEntity te = this.f_58857_.m_7702_(offset);
        if (te != null) {
            LazyOptional capability = te.getCapability(CapabilityInformationScreenInfo.INFORMATION_SCREEN_INFO_CAPABILITY);
            if (capability.isPresent()) {
                return capability.cast();
            }
            if (EnergyTools.isEnergyTE((BlockEntity)te, (Direction)this.getBlockOrientation())) {
                return LazyOptional.of(() -> new DefaultPowerInformationScreenInfo(te));
            }
        }
        return LazyOptional.empty();
    }
}

