/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.blockentity.grid.portable;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.RSBlockEntities;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.api.network.grid.ICraftingGridListener;
import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.api.network.grid.IGridTab;
import com.refinedmods.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.refinedmods.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.api.storage.StorageType;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCache;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCacheListener;
import com.refinedmods.refinedstorage.api.storage.cache.InvalidateCause;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskProvider;
import com.refinedmods.refinedstorage.api.storage.tracker.IStorageTracker;
import com.refinedmods.refinedstorage.api.util.IFilter;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.grid.handler.PortableFluidGridHandler;
import com.refinedmods.refinedstorage.apiimpl.network.grid.handler.PortableItemGridHandler;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.PortableFluidStorageCache;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.PortableItemStorageCache;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.listener.PortableFluidGridStorageCacheListener;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.listener.PortableItemGridStorageCacheListener;
import com.refinedmods.refinedstorage.apiimpl.storage.disk.PortableFluidStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.storage.disk.PortableItemStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.storage.tracker.FluidStorageTracker;
import com.refinedmods.refinedstorage.apiimpl.storage.tracker.ItemStorageTracker;
import com.refinedmods.refinedstorage.block.PortableGridBlock;
import com.refinedmods.refinedstorage.blockentity.BaseBlockEntity;
import com.refinedmods.refinedstorage.blockentity.config.IRedstoneConfigurable;
import com.refinedmods.refinedstorage.blockentity.config.RedstoneMode;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationManager;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationParameter;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationSpec;
import com.refinedmods.refinedstorage.blockentity.grid.GridBlockEntity;
import com.refinedmods.refinedstorage.blockentity.grid.portable.IPortableGrid;
import com.refinedmods.refinedstorage.blockentity.grid.portable.PortableGridDiskState;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.FilterItemHandler;
import com.refinedmods.refinedstorage.inventory.item.validator.StorageDiskItemValidator;
import com.refinedmods.refinedstorage.inventory.listener.BlockEntityInventoryListener;
import com.refinedmods.refinedstorage.item.WirelessGridItem;
import com.refinedmods.refinedstorage.item.blockitem.PortableGridBlockItem;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.grid.GridScreen;
import com.refinedmods.refinedstorage.util.LevelUtils;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PortableGridBlockEntity
extends BaseBlockEntity
implements IGrid,
IPortableGrid,
IRedstoneConfigurable,
IStorageDiskContainerContext {
    private static final String NBT_ITEM_STORAGE_TRACKER_ID = "ItemStorageTrackerId";
    private static final String NBT_FLUID_STORAGE_TRACKER_ID = "FluidStorageTrackerId";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_ENERGY = "Energy";
    private static final String NBT_ENCHANTMENTS = "Enchantments";
    public static final BlockEntitySynchronizationParameter<Integer, PortableGridBlockEntity> REDSTONE_MODE = RedstoneMode.createParameter();
    private static final BlockEntitySynchronizationParameter<Integer, PortableGridBlockEntity> SORTING_DIRECTION = new BlockEntitySynchronizationParameter<Integer, PortableGridBlockEntity>(EntityDataSerializers.f_135028_, 0, PortableGridBlockEntity::getSortingDirection, (t, v) -> {
        if (IGrid.isValidSortingDirection(v)) {
            t.setSortingDirection((int)v);
            t.m_6596_();
        }
    }, (initial, p) -> GridBlockEntity.trySortGrid(initial));
    private static final BlockEntitySynchronizationParameter<Integer, PortableGridBlockEntity> SORTING_TYPE = new BlockEntitySynchronizationParameter<Integer, PortableGridBlockEntity>(EntityDataSerializers.f_135028_, 0, PortableGridBlockEntity::getSortingType, (t, v) -> {
        if (IGrid.isValidSortingType(v)) {
            t.setSortingType((int)v);
            t.m_6596_();
        }
    }, (initial, p) -> GridBlockEntity.trySortGrid(initial));
    private static final BlockEntitySynchronizationParameter<Integer, PortableGridBlockEntity> SEARCH_BOX_MODE = new BlockEntitySynchronizationParameter<Integer, PortableGridBlockEntity>(EntityDataSerializers.f_135028_, 0, PortableGridBlockEntity::getSearchBoxMode, (t, v) -> {
        if (IGrid.isValidSearchBoxMode(v)) {
            t.setSearchBoxMode((int)v);
            t.m_6596_();
        }
    }, (initial, p) -> BaseScreen.executeLater(GridScreen.class, grid -> grid.getSearchField().setMode((int)p)));
    private static final BlockEntitySynchronizationParameter<Integer, PortableGridBlockEntity> SIZE = new BlockEntitySynchronizationParameter<Integer, PortableGridBlockEntity>(EntityDataSerializers.f_135028_, 0, PortableGridBlockEntity::getSize, (t, v) -> {
        if (IGrid.isValidSize(v)) {
            t.setSize((int)v);
            t.m_6596_();
        }
    }, (initial, p) -> BaseScreen.executeLater(GridScreen.class, BaseScreen::m_7856_));
    private static final BlockEntitySynchronizationParameter<Integer, PortableGridBlockEntity> TAB_SELECTED = new BlockEntitySynchronizationParameter<Integer, PortableGridBlockEntity>(EntityDataSerializers.f_135028_, 0, PortableGridBlockEntity::getTabSelected, (t, v) -> {
        t.setTabSelected(v.intValue() == t.getTabSelected() ? -1 : v);
        t.m_6596_();
    }, (initial, p) -> BaseScreen.executeLater(GridScreen.class, grid -> grid.getView().sort()));
    private static final BlockEntitySynchronizationParameter<Integer, PortableGridBlockEntity> TAB_PAGE = new BlockEntitySynchronizationParameter<Integer, PortableGridBlockEntity>(EntityDataSerializers.f_135028_, 0, PortableGridBlockEntity::getTabPage, (t, v) -> {
        if (v >= 0 && v <= t.getTotalTabPages()) {
            t.setTabPage((int)v);
            t.m_6596_();
        }
    });
    public static BlockEntitySynchronizationSpec SPEC = BlockEntitySynchronizationSpec.builder().addWatchedParameter(REDSTONE_MODE).addWatchedParameter(SORTING_DIRECTION).addWatchedParameter(SORTING_TYPE).addWatchedParameter(SEARCH_BOX_MODE).addWatchedParameter(SIZE).addWatchedParameter(TAB_SELECTED).addWatchedParameter(TAB_PAGE).build();
    private final PortableGridBlockItem.Type type;
    private final List<IFilter> filters = new ArrayList<IFilter>();
    private final List<IGridTab> tabs = new ArrayList<IGridTab>();
    private final FilterItemHandler filter = (FilterItemHandler)new FilterItemHandler(this.filters, this.tabs).addListener(new BlockEntityInventoryListener(this));
    private final PortableItemGridHandler itemHandler = new PortableItemGridHandler(this, this);
    private final PortableFluidGridHandler fluidHandler = new PortableFluidGridHandler(this);
    private EnergyStorage energyStorage = this.createEnergyStorage(0);
    private final LazyOptional<EnergyStorage> energyStorageCap = LazyOptional.of(() -> this.energyStorage);
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    private int sortingType;
    private int sortingDirection;
    private int searchBoxMode;
    private int tabSelected;
    private int tabPage;
    private int size;
    private GridType clientGridType;
    @Nullable
    private IStorageDisk storage;
    @Nullable
    private IStorageCache cache;
    private PortableGridDiskState diskState = PortableGridDiskState.NONE;
    private boolean active;
    private ItemStorageTracker itemStorageTracker;
    private UUID itemStorageTrackerId;
    private FluidStorageTracker fluidStorageTracker;
    private UUID fluidStorageTrackerId;
    private ListTag enchants = null;
    private boolean loadNextTick;
    private final BaseItemHandler disk = new BaseItemHandler(1).addValidator(new StorageDiskItemValidator()).addListener(new BlockEntityInventoryListener(this)).addListener((handler, slot, reading) -> {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.loadStorage();
            if (!reading) {
                this.updateState();
                LevelUtils.updateBlock(this.f_58857_, this.f_58858_);
            }
        }
    });

    public PortableGridBlockEntity(PortableGridBlockItem.Type type, BlockPos pos, BlockState state) {
        super(type == PortableGridBlockItem.Type.CREATIVE ? (BlockEntityType)RSBlockEntities.CREATIVE_PORTABLE_GRID.get() : (BlockEntityType)RSBlockEntities.PORTABLE_GRID.get(), pos, state, SPEC);
        this.type = type;
    }

    public static void serverTick(PortableGridBlockEntity blockEntity) {
        if (blockEntity.loadNextTick) {
            blockEntity.active = blockEntity.isGridActive();
            blockEntity.diskState = blockEntity.getDiskState();
            blockEntity.loadNextTick = false;
        }
    }

    private void loadStorage() {
        ItemStack diskStack = this.getDiskInventory().getStackInSlot(0);
        if (diskStack.m_41619_()) {
            this.storage = null;
            this.cache = null;
        } else {
            IStorageDisk diskInSlot = API.instance().getStorageDiskManager((ServerLevel)this.f_58857_).getByStack(this.getDiskInventory().getStackInSlot(0));
            if (diskInSlot != null) {
                StorageType diskType = ((IStorageDiskProvider)this.getDiskInventory().getStackInSlot(0).m_41720_()).getType();
                if (diskType == StorageType.ITEM) {
                    this.storage = new PortableItemStorageDisk(diskInSlot, this);
                    this.cache = new PortableItemStorageCache(this);
                } else if (diskType == StorageType.FLUID) {
                    this.storage = new PortableFluidStorageDisk(diskInSlot, this);
                    this.cache = new PortableFluidStorageCache(this);
                }
                this.storage.setSettings(this::updateState, this);
            } else {
                this.storage = null;
                this.cache = null;
            }
        }
        if (this.cache != null) {
            this.cache.invalidate(InvalidateCause.DISK_INVENTORY_CHANGED);
        }
    }

    public void onLoad() {
        super.onLoad();
        this.loadStorage();
        this.loadNextTick = true;
    }

    public void applyDataFromItemToBlockEntity(ItemStack stack) {
        this.sortingType = WirelessGridItem.getSortingType(stack);
        this.sortingDirection = WirelessGridItem.getSortingDirection(stack);
        this.searchBoxMode = WirelessGridItem.getSearchBoxMode(stack);
        this.tabSelected = WirelessGridItem.getTabSelected(stack);
        this.tabPage = WirelessGridItem.getTabPage(stack);
        this.size = WirelessGridItem.getSize(stack);
        this.energyStorage = this.createEnergyStorage(stack.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0));
        if (stack.m_41782_()) {
            for (int i = 0; i < 4; ++i) {
                StackUtils.readItems(this.filter, i, stack.m_41783_());
            }
            StackUtils.readItems(this.disk, 4, stack.m_41783_());
            this.redstoneMode = RedstoneMode.read(stack.m_41783_());
            if (stack.m_41783_().m_128441_(NBT_ITEM_STORAGE_TRACKER_ID)) {
                this.itemStorageTrackerId = stack.m_41783_().m_128342_(NBT_ITEM_STORAGE_TRACKER_ID);
            }
            if (stack.m_41783_().m_128441_(NBT_FLUID_STORAGE_TRACKER_ID)) {
                this.fluidStorageTrackerId = stack.m_41783_().m_128342_(NBT_FLUID_STORAGE_TRACKER_ID);
            }
            if (stack.m_41783_().m_128441_(NBT_ENCHANTMENTS)) {
                this.enchants = stack.m_41783_().m_128437_(NBT_ENCHANTMENTS, 10);
            }
        }
        this.m_6596_();
    }

    public void applyDataFromBlockEntityToItem(ItemStack stack) {
        stack.m_41751_(new CompoundTag());
        stack.m_41783_().m_128405_("SortingDirection", this.sortingDirection);
        stack.m_41783_().m_128405_("SortingType", this.sortingType);
        stack.m_41783_().m_128405_("SearchBoxMode", this.searchBoxMode);
        stack.m_41783_().m_128405_("Size", this.size);
        stack.m_41783_().m_128405_("TabSelected", this.tabSelected);
        stack.m_41783_().m_128405_("TabPage", this.tabPage);
        if (this.itemStorageTrackerId != null) {
            stack.m_41783_().m_128362_(NBT_ITEM_STORAGE_TRACKER_ID, this.itemStorageTrackerId);
        }
        if (this.fluidStorageTrackerId != null) {
            stack.m_41783_().m_128362_(NBT_FLUID_STORAGE_TRACKER_ID, this.fluidStorageTrackerId);
        }
        if (this.enchants != null) {
            stack.m_41783_().m_128365_(NBT_ENCHANTMENTS, (Tag)this.enchants);
        }
        stack.getCapability(ForgeCapabilities.ENERGY, null).ifPresent(itemEnergy -> itemEnergy.receiveEnergy(this.energyStorage.getEnergyStored(), false));
        for (int i = 0; i < 4; ++i) {
            StackUtils.writeItems((IItemHandler)this.filter, i, stack.m_41783_());
        }
        StackUtils.writeItems((IItemHandler)this.disk, 4, stack.m_41783_());
        this.redstoneMode.write(stack.m_41783_());
    }

    private EnergyStorage createEnergyStorage(int energyStored) {
        return new EnergyStorage(RS.SERVER_CONFIG.getPortableGrid().getCapacity(), RS.SERVER_CONFIG.getPortableGrid().getCapacity(), RS.SERVER_CONFIG.getPortableGrid().getCapacity(), energyStored);
    }

    @Override
    public GridType getGridType() {
        return this.clientGridType != null ? this.clientGridType : this.getServerGridType();
    }

    private GridType getServerGridType() {
        return this.getDiskInventory().getStackInSlot(0).m_41619_() || ((IStorageDiskProvider)this.getDiskInventory().getStackInSlot(0).m_41720_()).getType() == StorageType.ITEM ? GridType.NORMAL : GridType.FLUID;
    }

    @Override
    @Nullable
    public IStorageCache getStorageCache() {
        return this.storage != null ? this.cache : null;
    }

    @Override
    public IStorageCacheListener createListener(ServerPlayer player) {
        return this.getServerGridType() == GridType.FLUID ? new PortableFluidGridStorageCacheListener(this, player) : new PortableItemGridStorageCacheListener(this, player);
    }

    @Override
    @Nullable
    public IItemGridHandler getItemHandler() {
        return this.itemHandler;
    }

    @Override
    @Nullable
    public IFluidGridHandler getFluidHandler() {
        return this.fluidHandler;
    }

    @Override
    public void addCraftingListener(ICraftingGridListener listener) {
    }

    @Override
    public void removeCraftingListener(ICraftingGridListener listener) {
    }

    @Override
    public Component getTitle() {
        return Component.m_237115_((String)"gui.refinedstorage.portable_grid");
    }

    @Override
    public int getViewType() {
        return -1;
    }

    @Override
    public int getSortingType() {
        return this.f_58857_.f_46443_ ? SORTING_TYPE.getValue() : this.sortingType;
    }

    public void setSortingType(int sortingType) {
        this.sortingType = sortingType;
    }

    @Override
    public int getSortingDirection() {
        return this.f_58857_.f_46443_ ? SORTING_DIRECTION.getValue() : this.sortingDirection;
    }

    public void setSortingDirection(int sortingDirection) {
        this.sortingDirection = sortingDirection;
    }

    @Override
    public int getSearchBoxMode() {
        return this.f_58857_.f_46443_ ? SEARCH_BOX_MODE.getValue() : this.searchBoxMode;
    }

    public void setSearchBoxMode(int searchBoxMode) {
        this.searchBoxMode = searchBoxMode;
    }

    @Override
    public int getTabSelected() {
        return this.f_58857_.f_46443_ ? TAB_SELECTED.getValue() : this.tabSelected;
    }

    public void setTabSelected(int tabSelected) {
        this.tabSelected = tabSelected;
    }

    @Override
    public int getTabPage() {
        return this.f_58857_.f_46443_ ? TAB_PAGE.getValue() : Math.min(this.tabPage, this.getTotalTabPages());
    }

    public void setTabPage(int page) {
        this.tabPage = page;
    }

    @Override
    public int getTotalTabPages() {
        return (int)Math.floor((float)Math.max(0, this.tabs.size() - 1) / 5.0f);
    }

    @Override
    public int getSize() {
        return this.f_58857_.f_46443_ ? SIZE.getValue() : this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public void onViewTypeChanged(int type) {
    }

    @Override
    public void onSortingTypeChanged(int type) {
        BlockEntitySynchronizationManager.setParameter(SORTING_TYPE, type);
    }

    @Override
    public void onSortingDirectionChanged(int direction) {
        BlockEntitySynchronizationManager.setParameter(SORTING_DIRECTION, direction);
    }

    @Override
    public void onSearchBoxModeChanged(int searchBoxMode) {
        BlockEntitySynchronizationManager.setParameter(SEARCH_BOX_MODE, searchBoxMode);
    }

    @Override
    public void onSizeChanged(int size) {
        BlockEntitySynchronizationManager.setParameter(SIZE, size);
    }

    @Override
    public void onTabSelectionChanged(int tab) {
        BlockEntitySynchronizationManager.setParameter(TAB_SELECTED, tab);
    }

    @Override
    public void onTabPageChanged(int page) {
        if (page >= 0 && page <= this.getTotalTabPages()) {
            BlockEntitySynchronizationManager.setParameter(TAB_PAGE, page);
        }
    }

    @Override
    public List<IFilter> getFilters() {
        return this.filters;
    }

    @Override
    public List<IGridTab> getTabs() {
        return this.tabs;
    }

    @Override
    public IItemHandlerModifiable getFilter() {
        return this.filter;
    }

    @Override
    public IStorageTracker<ItemStack> getItemStorageTracker() {
        if (this.itemStorageTracker == null) {
            if (this.itemStorageTrackerId == null) {
                this.itemStorageTrackerId = UUID.randomUUID();
            }
            this.itemStorageTracker = (ItemStorageTracker)API.instance().getStorageTrackerManager(ServerLifecycleHooks.getCurrentServer().m_129783_()).getOrCreate(this.itemStorageTrackerId, StorageType.ITEM);
        }
        return this.itemStorageTracker;
    }

    @Override
    public IStorageTracker<FluidStack> getFluidStorageTracker() {
        if (this.fluidStorageTracker == null) {
            if (this.fluidStorageTrackerId == null) {
                this.fluidStorageTrackerId = UUID.randomUUID();
            }
            this.fluidStorageTracker = (FluidStorageTracker)API.instance().getStorageTrackerManager(ServerLifecycleHooks.getCurrentServer().m_129783_()).getOrCreate(this.fluidStorageTrackerId, StorageType.FLUID);
        }
        return this.fluidStorageTracker;
    }

    @Override
    public CraftingContainer getCraftingMatrix() {
        return null;
    }

    @Override
    public ResultContainer getCraftingResult() {
        return null;
    }

    @Override
    public void onCraftingMatrixChanged() {
    }

    @Override
    public void onCrafted(Player player, @Nullable IStackList<ItemStack> availableItems, @Nullable IStackList<ItemStack> usedItems) {
    }

    @Override
    public void onClear(Player player) {
    }

    @Override
    public void onCraftedShift(Player player) {
    }

    @Override
    public void onRecipeTransfer(Player player, ItemStack[][] recipe) {
    }

    @Override
    public void onClosed(Player player) {
    }

    private boolean hasDisk() {
        return !this.disk.getStackInSlot(0).m_41619_();
    }

    @Override
    public boolean isGridActive() {
        if (this.f_58857_.f_46443_) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            if (state.m_60734_() instanceof PortableGridBlock) {
                return (Boolean)state.m_61143_((Property)PortableGridBlock.ACTIVE);
            }
            return false;
        }
        if (RS.SERVER_CONFIG.getPortableGrid().getUseEnergy() && this.type != PortableGridBlockItem.Type.CREATIVE && this.energyStorage.getEnergyStored() <= RS.SERVER_CONFIG.getPortableGrid().getOpenUsage()) {
            return false;
        }
        if (!this.hasDisk()) {
            return false;
        }
        return this.redstoneMode.isEnabled(this.f_58857_.m_46753_(this.f_58858_));
    }

    @Override
    public int getSlotId() {
        return -1;
    }

    @Override
    @Nullable
    public IStorageCache getCache() {
        return this.cache;
    }

    @Override
    @Nullable
    public IStorageDisk getStorage() {
        return this.storage;
    }

    @Override
    public void drainEnergy(int energy) {
        if (RS.SERVER_CONFIG.getPortableGrid().getUseEnergy() && this.type != PortableGridBlockItem.Type.CREATIVE && this.redstoneMode.isEnabled(this.f_58857_.m_46753_(this.f_58858_))) {
            this.energyStorage.extractEnergy(energy, false);
            this.updateState();
        }
    }

    @Override
    public int getEnergy() {
        if (RS.SERVER_CONFIG.getPortableGrid().getUseEnergy() && this.type != PortableGridBlockItem.Type.CREATIVE) {
            return this.energyStorage.getEnergyStored();
        }
        return RS.SERVER_CONFIG.getPortableGrid().getCapacity();
    }

    @Override
    public PortableGridDiskState getDiskState() {
        int capacity;
        if (!this.hasDisk()) {
            return PortableGridDiskState.NONE;
        }
        if (!this.isGridActive()) {
            return PortableGridDiskState.DISCONNECTED;
        }
        int stored = this.storage != null ? this.storage.getStored() : 0;
        int n = capacity = this.storage != null ? this.storage.getCapacity() : 0;
        if (stored == capacity) {
            return PortableGridDiskState.FULL;
        }
        if ((int)((float)stored / (float)capacity * 100.0f) >= 75) {
            return PortableGridDiskState.NEAR_CAPACITY;
        }
        return PortableGridDiskState.NORMAL;
    }

    public void updateState() {
        boolean isActive;
        PortableGridDiskState newDiskState = this.getDiskState();
        if (this.diskState != newDiskState) {
            this.diskState = newDiskState;
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_(PortableGridBlock.DISK_STATE, (Comparable)((Object)this.diskState)));
        }
        if (this.active != (isActive = this.isGridActive())) {
            this.active = isActive;
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)PortableGridBlock.ACTIVE, (Comparable)Boolean.valueOf(this.active)));
        }
    }

    @Override
    public BaseItemHandler getDiskInventory() {
        return this.disk;
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("SortingDirection", this.sortingDirection);
        tag.m_128405_("SortingType", this.sortingType);
        tag.m_128405_("SearchBoxMode", this.searchBoxMode);
        tag.m_128405_("Size", this.size);
        tag.m_128405_("TabSelected", this.tabSelected);
        tag.m_128405_("TabPage", this.tabPage);
        StackUtils.writeItems((IItemHandler)this.disk, 0, tag);
        StackUtils.writeItems((IItemHandler)this.filter, 1, tag);
        tag.m_128405_(NBT_ENERGY, this.energyStorage.getEnergyStored());
        this.redstoneMode.write(tag);
        if (this.itemStorageTrackerId != null) {
            tag.m_128362_(NBT_ITEM_STORAGE_TRACKER_ID, this.itemStorageTrackerId);
        }
        if (this.fluidStorageTrackerId != null) {
            tag.m_128362_(NBT_FLUID_STORAGE_TRACKER_ID, this.fluidStorageTrackerId);
        }
        if (this.enchants != null) {
            tag.m_128365_(NBT_ENCHANTMENTS, (Tag)this.enchants);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("SortingDirection")) {
            this.sortingDirection = tag.m_128451_("SortingDirection");
        }
        if (tag.m_128441_("SortingType")) {
            this.sortingType = tag.m_128451_("SortingType");
        }
        if (tag.m_128441_("SearchBoxMode")) {
            this.searchBoxMode = tag.m_128451_("SearchBoxMode");
        }
        if (tag.m_128441_("Size")) {
            this.size = tag.m_128451_("Size");
        }
        if (tag.m_128441_("TabSelected")) {
            this.tabSelected = tag.m_128451_("TabSelected");
        }
        if (tag.m_128441_("TabPage")) {
            this.tabPage = tag.m_128451_("TabPage");
        }
        StackUtils.readItems(this.disk, 0, tag);
        StackUtils.readItems(this.filter, 1, tag);
        if (tag.m_128441_(NBT_ENERGY)) {
            this.energyStorage = this.createEnergyStorage(tag.m_128451_(NBT_ENERGY));
        }
        this.redstoneMode = RedstoneMode.read(tag);
        if (tag.m_128441_(NBT_ITEM_STORAGE_TRACKER_ID)) {
            this.itemStorageTrackerId = tag.m_128342_(NBT_ITEM_STORAGE_TRACKER_ID);
        }
        if (tag.m_128441_(NBT_FLUID_STORAGE_TRACKER_ID)) {
            this.fluidStorageTrackerId = tag.m_128342_(NBT_FLUID_STORAGE_TRACKER_ID);
        }
        if (tag.m_128441_(NBT_ENCHANTMENTS)) {
            this.enchants = tag.m_128437_(NBT_ENCHANTMENTS, 10);
        }
    }

    @Override
    public CompoundTag writeUpdate(CompoundTag tag) {
        tag.m_128405_(NBT_TYPE, this.getServerGridType().ordinal());
        return super.writeUpdate(tag);
    }

    @Override
    public void readUpdate(CompoundTag tag) {
        super.readUpdate(tag);
        this.clientGridType = GridType.values()[tag.m_128451_(NBT_TYPE)];
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyStorageCap.cast();
        }
        return super.getCapability(cap, direction);
    }

    public void onOpened() {
        this.drainEnergy(RS.SERVER_CONFIG.getPortableGrid().getOpenUsage());
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
        this.redstoneMode = mode;
        this.m_6596_();
    }

    @Override
    public AccessType getAccessType() {
        return AccessType.INSERT_EXTRACT;
    }
}

