/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.blockentity.grid;

import com.refinedmods.refinedstorage.RSBlockEntities;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.apiimpl.network.node.GridNetworkNode;
import com.refinedmods.refinedstorage.blockentity.NetworkNodeBlockEntity;
import com.refinedmods.refinedstorage.blockentity.config.IType;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationParameter;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationSpec;
import com.refinedmods.refinedstorage.blockentity.data.RSSerializers;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.grid.GridScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class GridBlockEntity
extends NetworkNodeBlockEntity<GridNetworkNode> {
    public static final BlockEntitySynchronizationParameter<Boolean, GridBlockEntity> EXACT_PATTERN = new BlockEntitySynchronizationParameter<Boolean, GridBlockEntity>(EntityDataSerializers.f_135035_, true, t -> ((GridNetworkNode)t.getNode()).isExactPattern(), (t, v) -> {
        ((GridNetworkNode)t.getNode()).setExactPattern((boolean)v);
        ((GridNetworkNode)t.getNode()).markDirty();
    }, (initial, p) -> BaseScreen.executeLater(GridScreen.class, grid -> grid.updateExactPattern((boolean)p)));
    public static final BlockEntitySynchronizationParameter<Integer, GridBlockEntity> PROCESSING_TYPE = IType.createParameter((initial, p) -> BaseScreen.executeLater(GridScreen.class, BaseScreen::m_7856_));
    public static final BlockEntitySynchronizationParameter<Integer, GridBlockEntity> VIEW_TYPE = new BlockEntitySynchronizationParameter<Integer, GridBlockEntity>(EntityDataSerializers.f_135028_, 0, t -> ((GridNetworkNode)t.getNode()).getViewType(), (t, v) -> {
        if (IGrid.isValidViewType(v)) {
            ((GridNetworkNode)t.getNode()).setViewType((int)v);
            ((GridNetworkNode)t.getNode()).markDirty();
        }
    }, (initial, p) -> GridBlockEntity.trySortGrid(initial));
    public static final BlockEntitySynchronizationParameter<List<Set<ResourceLocation>>, GridBlockEntity> ALLOWED_ITEM_TAGS = new BlockEntitySynchronizationParameter<List, GridBlockEntity>(RSSerializers.LIST_OF_SET_SERIALIZER, new ArrayList(), t -> ((GridNetworkNode)t.getNode()).getAllowedTagList().getAllowedItemTags(), (t, v) -> ((GridNetworkNode)t.getNode()).getAllowedTagList().setAllowedItemTags((List<Set<ResourceLocation>>)v));
    public static final BlockEntitySynchronizationParameter<List<Set<ResourceLocation>>, GridBlockEntity> ALLOWED_FLUID_TAGS = new BlockEntitySynchronizationParameter<List, GridBlockEntity>(RSSerializers.LIST_OF_SET_SERIALIZER, new ArrayList(), t -> ((GridNetworkNode)t.getNode()).getAllowedTagList().getAllowedFluidTags(), (t, v) -> ((GridNetworkNode)t.getNode()).getAllowedTagList().setAllowedFluidTags((List<Set<ResourceLocation>>)v));
    public static final BlockEntitySynchronizationParameter<Integer, GridBlockEntity> SORTING_DIRECTION = new BlockEntitySynchronizationParameter<Integer, GridBlockEntity>(EntityDataSerializers.f_135028_, 0, t -> ((GridNetworkNode)t.getNode()).getSortingDirection(), (t, v) -> {
        if (IGrid.isValidSortingDirection(v)) {
            ((GridNetworkNode)t.getNode()).setSortingDirection((int)v);
            ((GridNetworkNode)t.getNode()).markDirty();
        }
    }, (initial, p) -> GridBlockEntity.trySortGrid(initial));
    public static final BlockEntitySynchronizationParameter<Integer, GridBlockEntity> SORTING_TYPE = new BlockEntitySynchronizationParameter<Integer, GridBlockEntity>(EntityDataSerializers.f_135028_, 0, t -> ((GridNetworkNode)t.getNode()).getSortingType(), (t, v) -> {
        if (IGrid.isValidSortingType(v)) {
            ((GridNetworkNode)t.getNode()).setSortingType((int)v);
            ((GridNetworkNode)t.getNode()).markDirty();
        }
    }, (initial, p) -> GridBlockEntity.trySortGrid(initial));
    public static final BlockEntitySynchronizationParameter<Integer, GridBlockEntity> TAB_SELECTED = new BlockEntitySynchronizationParameter<Integer, GridBlockEntity>(EntityDataSerializers.f_135028_, 0, t -> ((GridNetworkNode)t.getNode()).getTabSelected(), (t, v) -> {
        ((GridNetworkNode)t.getNode()).setTabSelected(v.intValue() == ((GridNetworkNode)t.getNode()).getTabSelected() ? -1 : v);
        ((GridNetworkNode)t.getNode()).markDirty();
    }, (initial, p) -> BaseScreen.executeLater(GridScreen.class, grid -> grid.getView().sort()));
    public static final BlockEntitySynchronizationParameter<Integer, GridBlockEntity> TAB_PAGE = new BlockEntitySynchronizationParameter<Integer, GridBlockEntity>(EntityDataSerializers.f_135028_, 0, t -> ((GridNetworkNode)t.getNode()).getTabPage(), (t, v) -> {
        if (v >= 0 && v <= ((GridNetworkNode)t.getNode()).getTotalTabPages()) {
            ((GridNetworkNode)t.getNode()).setTabPage((int)v);
            ((GridNetworkNode)t.getNode()).markDirty();
        }
    });
    public static final BlockEntitySynchronizationParameter<Boolean, GridBlockEntity> PROCESSING_PATTERN = new BlockEntitySynchronizationParameter<Boolean, GridBlockEntity>(EntityDataSerializers.f_135035_, false, t -> ((GridNetworkNode)t.getNode()).isProcessingPattern(), (t, v) -> {
        ((GridNetworkNode)t.getNode()).setProcessingPattern((boolean)v);
        ((GridNetworkNode)t.getNode()).clearMatrix();
        ((GridNetworkNode)t.getNode()).markDirty();
    }, (initial, p) -> BaseScreen.executeLater(GridScreen.class, BaseScreen::m_7856_));
    public static final BlockEntitySynchronizationParameter<Integer, GridBlockEntity> SIZE = new BlockEntitySynchronizationParameter<Integer, GridBlockEntity>(EntityDataSerializers.f_135028_, 0, t -> ((GridNetworkNode)t.getNode()).getSize(), (t, v) -> {
        if (IGrid.isValidSize(v)) {
            ((GridNetworkNode)t.getNode()).setSize((int)v);
            ((GridNetworkNode)t.getNode()).markDirty();
        }
    }, (initial, p) -> BaseScreen.executeLater(GridScreen.class, grid -> grid.m_6574_(grid.getMinecraft(), grid.f_96543_, grid.f_96544_)));
    public static final BlockEntitySynchronizationParameter<Integer, GridBlockEntity> SEARCH_BOX_MODE = new BlockEntitySynchronizationParameter<Integer, GridBlockEntity>(EntityDataSerializers.f_135028_, 0, t -> ((GridNetworkNode)t.getNode()).getSearchBoxMode(), (t, v) -> {
        if (IGrid.isValidSearchBoxMode(v)) {
            ((GridNetworkNode)t.getNode()).setSearchBoxMode((int)v);
            ((GridNetworkNode)t.getNode()).markDirty();
        }
    }, (initial, p) -> BaseScreen.executeLater(GridScreen.class, grid -> grid.getSearchField().setMode((int)p)));
    public static BlockEntitySynchronizationSpec SPEC = BlockEntitySynchronizationSpec.builder().addWatchedParameter(REDSTONE_MODE).addWatchedParameter(VIEW_TYPE).addWatchedParameter(SORTING_DIRECTION).addWatchedParameter(SORTING_TYPE).addWatchedParameter(SEARCH_BOX_MODE).addWatchedParameter(SIZE).addWatchedParameter(TAB_SELECTED).addWatchedParameter(TAB_PAGE).addWatchedParameter(EXACT_PATTERN).addWatchedParameter(PROCESSING_PATTERN).addWatchedParameter(PROCESSING_TYPE).addParameter(ALLOWED_ITEM_TAGS).addParameter(ALLOWED_FLUID_TAGS).build();
    private final GridType type;
    private final LazyOptional<IItemHandler> diskCapability = LazyOptional.of(() -> ((GridNetworkNode)this.getNode()).getPatterns());

    public static BlockEntityType<GridBlockEntity> getType(GridType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case GridType.NORMAL -> (BlockEntityType)RSBlockEntities.GRID.get();
            case GridType.CRAFTING -> (BlockEntityType)RSBlockEntities.CRAFTING_GRID.get();
            case GridType.PATTERN -> (BlockEntityType)RSBlockEntities.PATTERN_GRID.get();
            case GridType.FLUID -> (BlockEntityType)RSBlockEntities.FLUID_GRID.get();
        };
    }

    public static void trySortGrid(boolean initial) {
        if (!initial) {
            BaseScreen.executeLater(GridScreen.class, grid -> grid.getView().sort());
        }
    }

    public GridBlockEntity(GridType type, BlockPos pos, BlockState state) {
        super(GridBlockEntity.getType(type), pos, state, SPEC, GridNetworkNode.class);
        this.type = type;
    }

    @Override
    @Nonnull
    public GridNetworkNode createNode(Level level, BlockPos pos) {
        return new GridNetworkNode(level, pos, this.type);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && this.type == GridType.PATTERN) {
            return this.diskCapability.cast();
        }
        return super.getCapability(cap, direction);
    }
}

