/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.blockentity;

import com.refinedmods.refinedstorage.RSBlockEntities;
import com.refinedmods.refinedstorage.apiimpl.network.node.DiskState;
import com.refinedmods.refinedstorage.apiimpl.network.node.diskmanipulator.DiskManipulatorNetworkNode;
import com.refinedmods.refinedstorage.blockentity.NetworkNodeBlockEntity;
import com.refinedmods.refinedstorage.blockentity.config.IComparable;
import com.refinedmods.refinedstorage.blockentity.config.IType;
import com.refinedmods.refinedstorage.blockentity.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationParameter;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationSpec;
import com.refinedmods.refinedstorage.util.LevelUtils;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class DiskManipulatorBlockEntity
extends NetworkNodeBlockEntity<DiskManipulatorNetworkNode> {
    public static final BlockEntitySynchronizationParameter<Integer, DiskManipulatorBlockEntity> COMPARE = IComparable.createParameter();
    public static final BlockEntitySynchronizationParameter<Integer, DiskManipulatorBlockEntity> WHITELIST_BLACKLIST = IWhitelistBlacklist.createParameter();
    public static final BlockEntitySynchronizationParameter<Integer, DiskManipulatorBlockEntity> TYPE = IType.createParameter();
    public static final BlockEntitySynchronizationParameter<Integer, DiskManipulatorBlockEntity> IO_MODE = new BlockEntitySynchronizationParameter<Integer, DiskManipulatorBlockEntity>(EntityDataSerializers.f_135028_, 0, t -> ((DiskManipulatorNetworkNode)t.getNode()).getIoMode(), (t, v) -> {
        ((DiskManipulatorNetworkNode)t.getNode()).setIoMode((int)v);
        ((DiskManipulatorNetworkNode)t.getNode()).markDirty();
    });
    public static final ModelProperty<DiskState[]> DISK_STATE_PROPERTY = new ModelProperty();
    public static BlockEntitySynchronizationSpec SPEC = BlockEntitySynchronizationSpec.builder().addWatchedParameter(REDSTONE_MODE).addWatchedParameter(COMPARE).addWatchedParameter(WHITELIST_BLACKLIST).addWatchedParameter(TYPE).addWatchedParameter(IO_MODE).build();
    private static final String NBT_DISK_STATE = "DiskStates";
    private final LazyOptional<IItemHandler> diskCapability = LazyOptional.of(() -> ((DiskManipulatorNetworkNode)this.getNode()).getDisks());
    private final DiskState[] diskState = new DiskState[6];

    public DiskManipulatorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RSBlockEntities.DISK_MANIPULATOR.get(), pos, state, SPEC, DiskManipulatorNetworkNode.class);
        Arrays.fill((Object[])this.diskState, (Object)DiskState.NONE);
    }

    @Override
    public CompoundTag writeUpdate(CompoundTag tag) {
        super.writeUpdate(tag);
        ListTag list = new ListTag();
        for (DiskState state : ((DiskManipulatorNetworkNode)this.getNode()).getDiskState()) {
            list.add((Object)IntTag.m_128679_((int)state.ordinal()));
        }
        tag.m_128365_(NBT_DISK_STATE, (Tag)list);
        return tag;
    }

    @Override
    public void readUpdate(CompoundTag tag) {
        super.readUpdate(tag);
        ListTag list = tag.m_128437_(NBT_DISK_STATE, 3);
        for (int i = 0; i < list.size(); ++i) {
            this.diskState[i] = DiskState.values()[list.m_128763_(i)];
        }
        this.requestModelDataUpdate();
        LevelUtils.updateBlock(this.f_58857_, this.f_58858_);
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(DISK_STATE_PROPERTY, (Object)this.diskState).build();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.diskCapability.cast();
        }
        return super.getCapability(cap, direction);
    }

    @Override
    @Nonnull
    public DiskManipulatorNetworkNode createNode(Level level, BlockPos pos) {
        return new DiskManipulatorNetworkNode(level, pos);
    }
}

