/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.apiimpl.network.node.ConnectivityStateChangeCause;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.block.DetectorBlock;
import com.refinedmods.refinedstorage.blockentity.DetectorBlockEntity;
import com.refinedmods.refinedstorage.blockentity.config.IComparable;
import com.refinedmods.refinedstorage.blockentity.config.IType;
import com.refinedmods.refinedstorage.blockentity.config.RedstoneMode;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.util.StackUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class DetectorNetworkNode
extends NetworkNode
implements IComparable,
IType {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "detector");
    public static final int MODE_UNDER = 0;
    public static final int MODE_EQUAL = 1;
    public static final int MODE_ABOVE = 2;
    private static final int SPEED = 5;
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_AMOUNT = "Amount";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private final BaseItemHandler itemFilters = new BaseItemHandler(1).addListener(new NetworkNodeInventoryListener(this));
    private final FluidInventory fluidFilters = new FluidInventory(1).addListener(new NetworkNodeFluidInventoryListener(this));
    private int compare = 1;
    private int type = 0;
    private int mode = 1;
    private int amount = 0;
    private boolean powered = false;
    private boolean wasPowered;

    public DetectorNetworkNode(Level level, BlockPos pos) {
        super(level, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getDetector().getUsage();
    }

    @Override
    public void update() {
        super.update();
        if (this.powered != this.wasPowered && this.level.m_46749_(this.pos)) {
            this.wasPowered = this.powered;
            this.level.m_46597_(this.pos, (BlockState)this.level.m_8055_(this.pos).m_61124_((Property)DetectorBlock.POWERED, (Comparable)Boolean.valueOf(this.powered)));
            this.level.m_46672_(this.pos, this.level.m_8055_(this.pos).m_60734_());
        }
        if (this.canUpdate() && this.ticks % 5 == 0) {
            if (this.type == 0) {
                ItemStack stack;
                ItemStack slot = this.itemFilters.getStackInSlot(0);
                this.powered = !slot.m_41619_() ? this.isPowered((stack = this.network.getItemStorageCache().getList().get(slot, this.compare)) == null ? null : Integer.valueOf(stack.m_41613_())) : this.isPowered(this.network.getItemStorageCache().getList().getStacks().stream().map(e -> ((ItemStack)e.getStack()).m_41613_()).mapToInt(Number::intValue).sum());
            } else if (this.type == 1) {
                FluidStack stack;
                FluidStack slot = this.fluidFilters.getFluid(0);
                this.powered = !slot.isEmpty() ? this.isPowered((stack = this.network.getFluidStorageCache().getList().get(slot, this.compare)) == null ? null : Integer.valueOf(stack.getAmount())) : this.isPowered(this.network.getFluidStorageCache().getList().getStacks().stream().map(e -> ((FluidStack)e.getStack()).getAmount()).mapToInt(Number::intValue).sum());
            }
        }
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void onConnectedStateChange(INetwork network, boolean state, ConnectivityStateChangeCause cause) {
        super.onConnectedStateChange(network, state, cause);
        if (!state) {
            this.powered = false;
        }
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    private boolean isPowered(@Nullable Integer size) {
        if (size != null) {
            switch (this.mode) {
                case 0: {
                    return size < this.amount;
                }
                case 1: {
                    return size == this.amount;
                }
                case 2: {
                    return size > this.amount;
                }
            }
            return false;
        }
        if (this.mode == 0 && this.amount != 0) {
            return true;
        }
        return this.mode == 1 && this.amount == 0;
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    @Override
    public CompoundTag writeConfiguration(CompoundTag tag) {
        super.writeConfiguration(tag);
        tag.m_128405_(NBT_COMPARE, this.compare);
        tag.m_128405_(NBT_MODE, this.mode);
        tag.m_128405_(NBT_AMOUNT, this.amount);
        tag.m_128405_(NBT_TYPE, this.type);
        StackUtils.writeItems((IItemHandler)this.itemFilters, 0, tag);
        tag.m_128365_(NBT_FLUID_FILTERS, (Tag)this.fluidFilters.writeToNbt());
        return tag;
    }

    @Override
    public void readConfiguration(CompoundTag tag) {
        super.readConfiguration(tag);
        if (tag.m_128441_(NBT_COMPARE)) {
            this.compare = tag.m_128451_(NBT_COMPARE);
        }
        if (tag.m_128441_(NBT_MODE)) {
            this.mode = tag.m_128451_(NBT_MODE);
        }
        if (tag.m_128441_(NBT_AMOUNT)) {
            this.amount = tag.m_128451_(NBT_AMOUNT);
        }
        if (tag.m_128441_(NBT_TYPE)) {
            this.type = tag.m_128451_(NBT_TYPE);
        }
        StackUtils.readItems(this.itemFilters, 0, tag);
        if (tag.m_128441_(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.m_128469_(NBT_FLUID_FILTERS));
        }
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
    }

    @Override
    public int getType() {
        return this.level.f_46443_ ? DetectorBlockEntity.TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    @Override
    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    @Override
    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }
}

