/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.grid.handler;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.autocrafting.task.CalculationResultType;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICalculationResult;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.preview.ErrorCraftingPreviewElement;
import com.refinedmods.refinedstorage.network.grid.GridCraftingPreviewResponseMessage;
import com.refinedmods.refinedstorage.network.grid.GridCraftingStartResponseMessage;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Pair;

public class FluidGridHandler
implements IFluidGridHandler {
    private final INetwork network;

    public FluidGridHandler(INetwork network) {
        this.network = network;
    }

    @Override
    public void onExtract(ServerPlayer player, UUID id, boolean shift) {
        FluidStack stack = this.network.getFluidStorageCache().getList().get(id);
        if (stack == null || stack.getAmount() < 1000 || !this.network.getSecurityManager().hasPermission(Permission.EXTRACT, (Player)player) || !this.network.canRun()) {
            return;
        }
        NetworkUtils.extractBucketFromPlayerInventoryOrNetwork((Player)player, this.network, bucket -> bucket.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).ifPresent(fluidHandler -> {
            this.network.getFluidStorageTracker().changed((Player)player, stack.copy());
            FluidStack extracted = this.network.extractFluid(stack, 1000, Action.PERFORM);
            fluidHandler.fill(extracted, IFluidHandler.FluidAction.EXECUTE);
            if (shift) {
                if (!player.m_150109_().m_36054_(fluidHandler.getContainer().m_41777_())) {
                    Containers.m_18992_((Level)player.m_20193_(), (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)fluidHandler.getContainer());
                }
            } else {
                player.f_36096_.m_142503_(fluidHandler.getContainer());
            }
            this.network.getNetworkItemManager().drainEnergy((Player)player, RS.SERVER_CONFIG.getWirelessFluidGrid().getExtractUsage());
        }));
    }

    @Override
    @Nonnull
    public ItemStack onInsert(ServerPlayer player, ItemStack container) {
        if (!this.network.getSecurityManager().hasPermission(Permission.INSERT, (Player)player) || !this.network.canRun()) {
            return container;
        }
        Pair<ItemStack, FluidStack> result = StackUtils.getFluid(container, true);
        if (!((FluidStack)result.getValue()).isEmpty() && this.network.insertFluid((FluidStack)result.getValue(), ((FluidStack)result.getValue()).getAmount(), Action.SIMULATE).isEmpty()) {
            this.network.getFluidStorageTracker().changed((Player)player, ((FluidStack)result.getValue()).copy());
            result = StackUtils.getFluid(container, false);
            this.network.insertFluid((FluidStack)result.getValue(), ((FluidStack)result.getValue()).getAmount(), Action.PERFORM);
            this.network.getNetworkItemManager().drainEnergy((Player)player, RS.SERVER_CONFIG.getWirelessFluidGrid().getInsertUsage());
            return (ItemStack)result.getLeft();
        }
        return container;
    }

    @Override
    public void onInsertHeldContainer(ServerPlayer player) {
        player.f_36096_.m_142503_(this.onInsert(player, player.f_36096_.m_142621_()));
    }

    @Override
    public void onCraftingPreviewRequested(ServerPlayer player, UUID id, int quantity, boolean noPreview) {
        if (!this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (Player)player)) {
            return;
        }
        FluidStack stack = this.network.getFluidStorageCache().getCraftablesList().get(id);
        if (stack != null) {
            ICalculationResult result = this.network.getCraftingManager().create(stack, quantity);
            if (result == null) {
                return;
            }
            if (!result.isOk() && result.getType() != CalculationResultType.MISSING) {
                RS.NETWORK_HANDLER.sendTo(player, new GridCraftingPreviewResponseMessage(Collections.singletonList(new ErrorCraftingPreviewElement(result.getType(), result.getRecursedPattern() == null ? ItemStack.f_41583_ : result.getRecursedPattern().getStack())), id, quantity, true));
            } else if (result.isOk() && noPreview) {
                this.network.getCraftingManager().start(result.getTask());
                RS.NETWORK_HANDLER.sendTo(player, new GridCraftingStartResponseMessage());
            } else {
                RS.NETWORK_HANDLER.sendTo(player, new GridCraftingPreviewResponseMessage(result.getPreviewElements(), id, quantity, true));
            }
        }
    }

    @Override
    public void onCraftingRequested(ServerPlayer player, UUID id, int quantity) {
        ICalculationResult result;
        if (quantity <= 0 || !this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (Player)player)) {
            return;
        }
        FluidStack stack = this.network.getFluidStorageCache().getCraftablesList().get(id);
        if (stack != null && (result = this.network.getCraftingManager().create(stack, quantity)).isOk()) {
            this.network.getCraftingManager().start(result.getTask());
        }
    }
}

