/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network;

import com.google.common.collect.Sets;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.INetworkNodeGraph;
import com.refinedmods.refinedstorage.api.network.INetworkNodeGraphEntry;
import com.refinedmods.refinedstorage.api.network.INetworkNodeGraphListener;
import com.refinedmods.refinedstorage.api.network.INetworkNodeVisitor;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.network.NetworkNodeGraphEntry;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class NetworkNodeGraph
implements INetworkNodeGraph {
    private final INetwork network;
    private final List<INetworkNodeGraphListener> listeners = new LinkedList<INetworkNodeGraphListener>();
    private final Set<Consumer<INetwork>> actions = new HashSet<Consumer<INetwork>>();
    private Set<INetworkNodeGraphEntry> entries = Sets.newConcurrentHashSet();
    private boolean invalidating = false;

    public NetworkNodeGraph(INetwork network) {
        this.network = network;
    }

    @Override
    public void invalidate(Action action, Level level, BlockPos origin) {
        Visitor currentVisitor;
        this.invalidating = true;
        Operator operator = new Operator(action);
        INetworkNode originNode = NetworkUtils.getNodeFromBlockEntity(level.m_7702_(origin));
        if (originNode instanceof INetworkNodeVisitor) {
            ((INetworkNodeVisitor)((Object)originNode)).visit(operator);
        }
        while ((currentVisitor = operator.toCheck.poll()) != null) {
            currentVisitor.visit(operator);
        }
        this.entries = operator.foundNodes;
        if (action == Action.PERFORM) {
            for (INetworkNodeGraphEntry entry : operator.newEntries) {
                entry.getNode().onConnected(this.network);
            }
            for (INetworkNodeGraphEntry entry : operator.previousEntries) {
                entry.getNode().onDisconnected(this.network);
            }
            this.actions.forEach(h -> h.accept(this.network));
            this.actions.clear();
            if (!operator.newEntries.isEmpty() || !operator.previousEntries.isEmpty()) {
                this.listeners.forEach(INetworkNodeGraphListener::onChanged);
            }
        }
        this.invalidating = false;
    }

    @Override
    public void runActionWhenPossible(Consumer<INetwork> handler) {
        if (this.invalidating) {
            this.actions.add(handler);
        } else {
            handler.accept(this.network);
        }
    }

    @Override
    public Collection<INetworkNodeGraphEntry> all() {
        return this.entries;
    }

    @Override
    public void addListener(INetworkNodeGraphListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void disconnectAll() {
        this.entries.forEach(entry -> entry.getNode().onDisconnected(this.network));
        this.entries.clear();
        this.listeners.forEach(INetworkNodeGraphListener::onChanged);
    }

    protected Level getLevel() {
        return this.network.getLevel();
    }

    private class Operator
    implements INetworkNodeVisitor.Operator {
        private final Set<INetworkNodeGraphEntry> foundNodes = Sets.newConcurrentHashSet();
        private final Set<INetworkNodeGraphEntry> newEntries = Sets.newConcurrentHashSet();
        private final Set<INetworkNodeGraphEntry> previousEntries;
        private final Queue<Visitor> toCheck;
        private final Action action;

        public Operator(Action action) {
            this.previousEntries = Sets.newConcurrentHashSet(NetworkNodeGraph.this.entries);
            this.toCheck = new ArrayDeque<Visitor>();
            this.action = action;
        }

        @Override
        public void apply(Level level, BlockPos pos, @Nullable Direction side) {
            BlockEntity blockEntity = level.m_7702_(pos);
            INetworkNode otherNode = NetworkUtils.getNodeFromBlockEntity(blockEntity);
            if (otherNode != null) {
                NetworkNodeGraphEntry otherNodeItem = new NetworkNodeGraphEntry(otherNode);
                if (otherNode.getNetwork() != null && !otherNode.getNetwork().equals(NetworkNodeGraph.this.network)) {
                    if (this.action == Action.PERFORM) {
                        this.dropConflictingBlock(level, pos);
                    }
                    return;
                }
                if (this.foundNodes.add(otherNodeItem)) {
                    if (!NetworkNodeGraph.this.entries.contains(otherNodeItem)) {
                        this.newEntries.add(otherNodeItem);
                    }
                    this.previousEntries.remove(otherNodeItem);
                    this.toCheck.add(new Visitor(otherNode, level, pos, side, blockEntity));
                }
            }
        }

        private void dropConflictingBlock(Level level, BlockPos pos) {
            if (!NetworkNodeGraph.this.network.getPosition().equals((Object)pos)) {
                Block.m_49892_((BlockState)level.m_8055_(pos), (LevelAccessor)level, (BlockPos)pos, (BlockEntity)level.m_7702_(pos));
                level.m_7471_(pos, false);
            }
        }

        @Override
        public Action getAction() {
            return this.action;
        }
    }

    private static class Visitor
    implements INetworkNodeVisitor {
        private final INetworkNode node;
        private final Level level;
        private final BlockPos pos;
        private final Direction side;
        private final BlockEntity blockEntity;

        Visitor(INetworkNode node, Level level, BlockPos pos, Direction side, BlockEntity blockEntity) {
            this.node = node;
            this.level = level;
            this.pos = pos;
            this.side = side;
            this.blockEntity = blockEntity;
        }

        @Override
        public void visit(INetworkNodeVisitor.Operator operator) {
            if (this.node instanceof INetworkNodeVisitor) {
                ((INetworkNodeVisitor)((Object)this.node)).visit(operator);
            } else {
                for (Direction checkSide : Direction.values()) {
                    BlockPos relativePos;
                    INetworkNode nodeOnSide;
                    if (checkSide == this.side || (nodeOnSide = NetworkUtils.getNodeFromBlockEntity(this.blockEntity)) != this.node || !this.level.m_46749_(relativePos = this.pos.m_121945_(checkSide))) continue;
                    operator.apply(this.level, relativePos, checkSide.m_122424_());
                }
            }
        }
    }
}

