/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.model;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class RechiseledBakedModel
implements IDynamicBakedModel {
    private final Map<Direction, List<Tuple<BakedQuad, Boolean>>> quads;
    private final boolean ambientOcclusion;
    private final boolean gui3d;
    private final boolean blockLighting;
    private final boolean customRenderer;
    private final TextureAtlasSprite particles;
    private final ItemOverrides itemOverrides;
    private final ItemTransforms transforms;
    private final ChunkRenderTypeSet blockRenderTypes;
    private final List<RenderType> itemRenderTypes;
    private final List<RenderType> fabulousItemRenderTypes;

    public RechiseledBakedModel(Map<Direction, List<Tuple<BakedQuad, Boolean>>> quads, boolean ambientOcclusion, boolean gui3d, boolean blockLighting, boolean customRenderer, TextureAtlasSprite particles, ItemOverrides itemOverrides, ItemTransforms transforms, RenderTypeGroup renderTypes) {
        this.quads = quads;
        this.ambientOcclusion = ambientOcclusion;
        this.gui3d = gui3d;
        this.blockLighting = blockLighting;
        this.customRenderer = customRenderer;
        this.particles = particles;
        this.itemOverrides = itemOverrides;
        this.transforms = transforms;
        this.blockRenderTypes = !renderTypes.isEmpty() ? ChunkRenderTypeSet.of((RenderType[])new RenderType[]{renderTypes.block()}) : null;
        this.itemRenderTypes = !renderTypes.isEmpty() ? Collections.singletonList(renderTypes.entity()) : null;
        this.fabulousItemRenderTypes = !renderTypes.isEmpty() ? Collections.singletonList(renderTypes.entityFabulous()) : null;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, RenderType renderType) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        List unconnectedQuads = this.quads.getOrDefault(side, Collections.emptyList());
        for (Tuple entry : unconnectedQuads) {
            BakedQuad quad = (BakedQuad)entry.m_14418_();
            if (((Boolean)entry.m_14419_()).booleanValue()) {
                int[] vertexData = quad.m_111303_();
                vertexData = Arrays.copyOf(vertexData, vertexData.length);
                int[] uv = this.getUV(quad.m_111306_(), extraData);
                RechiseledBakedModel.adjustVertexDataUV(vertexData, uv[0], uv[1], quad.m_173410_(), DefaultVertexFormat.f_85811_);
                quads.add(new BakedQuad(vertexData, quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), quad.m_111307_()));
                continue;
            }
            quads.add(quad);
        }
        return quads;
    }

    protected int[] getUV(Direction side, ModelData modelData) {
        return new int[]{0, 0};
    }

    private static int[] adjustVertexDataUV(int[] vertexData, int newU, int newV, TextureAtlasSprite sprite, VertexFormat vertexFormat) {
        int vertexSize = vertexFormat.m_86017_();
        int vertices = vertexData.length / vertexSize;
        int uvOffset = RechiseledBakedModel.findUVOffset(vertexFormat) / 4;
        for (int i = 0; i < vertices; ++i) {
            int offset = i * vertexSize + uvOffset;
            float width = sprite.m_118410_() - sprite.m_118409_();
            float u = ((float)newU + (Float.intBitsToFloat(vertexData[offset]) - sprite.m_118409_()) / width) * 2.0f;
            vertexData[offset] = Float.floatToRawIntBits(sprite.m_118367_((double)u));
            float height = sprite.m_118412_() - sprite.m_118411_();
            float v = ((float)newV + (Float.intBitsToFloat(vertexData[offset + 1]) - sprite.m_118411_()) / height) * 2.0f;
            vertexData[offset + 1] = Float.floatToRawIntBits(sprite.m_118393_((double)v));
        }
        return vertexData;
    }

    private static int findUVOffset(VertexFormat vertexFormat) {
        int index;
        VertexFormatElement element = null;
        for (index = 0; index < vertexFormat.m_86023_().size(); ++index) {
            VertexFormatElement el = (VertexFormatElement)vertexFormat.m_86023_().get(index);
            if (el.m_86048_() != VertexFormatElement.Usage.UV) continue;
            element = el;
            break;
        }
        if (index == vertexFormat.m_86023_().size() || element == null) {
            throw new RuntimeException("Expected vertex format to have a UV attribute");
        }
        if (element.m_86041_() != VertexFormatElement.Type.FLOAT) {
            throw new RuntimeException("Expected UV attribute to have data type FLOAT");
        }
        if (element.m_86050_() < 4) {
            throw new RuntimeException("Expected UV attribute to have at least 4 dimensions");
        }
        return vertexFormat.getOffset(index);
    }

    @Nonnull
    public ModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData tileData) {
        return super.getModelData(world, pos, state, tileData);
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        if (this.blockRenderTypes != null) {
            return this.blockRenderTypes;
        }
        return super.getRenderTypes(state, rand, data);
    }

    public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
        if (!fabulous) {
            if (this.itemRenderTypes != null) {
                return this.itemRenderTypes;
            }
        } else if (this.fabulousItemRenderTypes != null) {
            return this.fabulousItemRenderTypes;
        }
        return super.getRenderTypes(itemStack, fabulous);
    }

    public boolean m_7541_() {
        return this.ambientOcclusion;
    }

    public boolean m_7539_() {
        return this.gui3d;
    }

    public boolean m_7547_() {
        return this.blockLighting;
    }

    public boolean m_7521_() {
        return this.customRenderer;
    }

    public TextureAtlasSprite m_6160_() {
        return this.particles;
    }

    public ItemOverrides m_7343_() {
        return this.itemOverrides;
    }

    public ItemTransforms m_7442_() {
        return this.transforms;
    }
}

