/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.tasks;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import questsadditions.tasks.TasksRegistry;
import questsadditions.tasks.TimeMatch;

public class TimeTask
extends Task {
    long elapsedTime = 60L;
    TimeMatch gameTime = TimeMatch.AUTO;

    public TimeTask(Quest quest) {
        super(quest);
    }

    public TaskType getType() {
        return TasksRegistry.TIME;
    }

    public long getMaxProgress() {
        return Long.MAX_VALUE;
    }

    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128356_("elapsedTime", this.elapsedTime);
        if (this.gameTime != TimeMatch.AUTO) {
            nbt.m_128359_("gameTime", this.gameTime.name);
        }
    }

    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.elapsedTime = nbt.m_128454_("elapsedTime");
        this.gameTime = (TimeMatch)((Object)TimeMatch.NAME_MAP.get(nbt.m_128461_("gameTime")));
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130103_(this.elapsedTime);
        TimeMatch.NAME_MAP.write(buffer, (Object)this.gameTime);
    }

    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.elapsedTime = buffer.m_130258_();
        this.gameTime = (TimeMatch)((Object)TimeMatch.NAME_MAP.read(buffer));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addLong("elapsedTime", this.elapsedTime, v -> {
            this.elapsedTime = v;
        }, 60L, 1L, Long.MAX_VALUE);
        config.addEnum("gameTime", (Object)this.gameTime, v -> {
            this.gameTime = v;
        }, TimeMatch.NAME_MAP, (Object)TimeMatch.AUTO);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getButtonText() {
        return (MutableComponent)CommonComponents.f_237098_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addMouseOverText(TooltipList list, TeamData teamData) {
        list.reset();
        list.add(this.getTitle());
        if (!teamData.isCompleted((QuestObject)this) && teamData.getProgress((Task)this) != 0L) {
            list.blankLine();
            list.add((Component)this.timeRemaining(teamData).m_130940_(ChatFormatting.YELLOW));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private MutableComponent timeRemaining(TeamData teamData) {
        int current_time = (int)(teamData.getProgress((Task)this) + 20L - (this.useGameTime(!Minecraft.m_91087_().m_91091_()) ? Minecraft.m_91087_().f_91073_.m_46467_() : System.currentTimeMillis() / 50L));
        return Component.m_237110_((String)"ftbquests.task.time_remaining", (Object[])new Object[]{StringUtil.m_14404_((int)current_time)});
    }

    private boolean useGameTime(boolean isServer) {
        return this.gameTime == TimeMatch.AUTO ? isServer : this.gameTime == TimeMatch.GAME;
    }

    public int autoSubmitOnPlayerTick() {
        return 10;
    }

    public void submitTask(TeamData teamData, ServerPlayer player, ItemStack craftedItem) {
        if (!teamData.isCompleted((QuestObject)this)) {
            long current_time;
            long l = current_time = this.useGameTime(player.m_20194_().m_6982_()) ? player.m_9236_().m_46467_() : System.currentTimeMillis() / 50L;
            if (teamData.getProgress((Task)this) == 0L) {
                teamData.setProgress((Task)this, current_time + this.elapsedTime * 20L);
                teamData.setStarted(this.id, null);
            } else if (current_time > teamData.getProgress((Task)this)) {
                teamData.setProgress((Task)this, this.getMaxProgress());
            }
        }
    }
}

