/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.tasks;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import questsadditions.tasks.TasksRegistry;

public class DayTask
extends Task {
    int days = 1;

    public DayTask(Quest quest) {
        super(quest);
    }

    public TaskType getType() {
        return TasksRegistry.DAYS;
    }

    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128405_("days", this.days);
    }

    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.days = nbt.m_128451_("days");
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130130_(this.days);
    }

    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.days = buffer.m_130242_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addInt("days", this.days, v -> {
            this.days = v;
        }, 1, 1, Integer.MAX_VALUE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getAltTitle() {
        return Component.m_237110_((String)"questsadditions.task.days.title", (Object[])new Object[]{this.days});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
    }

    public int autoSubmitOnPlayerTick() {
        return 20;
    }

    public void submitTask(TeamData teamData, ServerPlayer player, ItemStack craftedItem) {
        if (!teamData.isCompleted((QuestObject)this) && (int)(player.m_9236_().m_46468_() / 24000L % Integer.MAX_VALUE) >= this.days) {
            teamData.addProgress((Task)this, 1L);
        }
    }
}

