/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.tasks;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.util.NBTUtils;
import dev.latvian.mods.itemfilters.api.ItemFiltersAPI;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import questsadditions.tasks.BlockInteractionTask;
import questsadditions.tasks.TasksRegistry;
import questsadditions.utils.TasksUtils;

public class BreakTask
extends BlockInteractionTask {
    public ItemStack item = ItemStack.f_41583_;
    public boolean checkItem;

    public BreakTask(Quest quest) {
        super(quest);
    }

    public TaskType getType() {
        return TasksRegistry.BREAK;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128379_("checkItem", this.checkItem);
        if (this.checkItem) {
            NBTUtils.write((CompoundTag)nbt, (String)"item", (ItemStack)this.item);
        }
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.checkItem = nbt.m_128471_("checkItem");
        if (this.checkItem) {
            this.item = NBTUtils.read((CompoundTag)nbt, (String)"item");
        }
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeBoolean(this.checkItem);
        if (this.checkItem) {
            FTBQuestsNetHandler.writeItemType((FriendlyByteBuf)buffer, (ItemStack)this.item);
        }
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.checkItem = buffer.readBoolean();
        if (this.checkItem) {
            this.item = FTBQuestsNetHandler.readItemType((FriendlyByteBuf)buffer);
        }
    }

    public boolean test(ItemStack stack) {
        return ItemFiltersAPI.filter((ItemStack)this.item, (ItemStack)stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addBool("checkItem", this.checkItem, v -> {
            this.checkItem = v;
        }, false).setNameKey("questsadditions.task.check_item");
        config.addItemStack("item", this.item, v -> {
            this.item = v;
        }, ItemStack.f_41583_, true, true).setNameKey("ftbquests.task.ftbquests.item");
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getAltTitle() {
        return Component.m_237110_((String)(this.checkItem ? "questsadditions.task.break.item.title" : "questsadditions.task.break.title"), (Object[])new Object[]{this.formatMaxProgress(), this.getBlockName(), this.item.m_41786_()});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        return this.checkItem ? TasksUtils.createHoldingIcon(super.getAltIcon(), this.item) : super.getAltIcon();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
    }

    public void Break(TeamData teamData, Block block, ItemStack itemStack) {
        if (!teamData.isCompleted((QuestObject)this) && this.checkBlock(block) && (!this.checkItem || this.test(itemStack))) {
            teamData.addProgress((Task)this, 1L);
        }
    }
}

